/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ResourceUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\r\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\fJ\b\u0010\u0018\u001a\u00020\u0015H\u0002J6\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000bH\u0002R)\u0010\t\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/ui/search/SearchableOptionIndexLoader;", "", "registrar", "Lcom/intellij/ide/ui/search/SearchableOptionsRegistrarImpl;", "storage", "", "", "", "(Lcom/intellij/ide/ui/search/SearchableOptionsRegistrarImpl;Ljava/util/Map;)V", "highlightOptionToSynonym", "Lcom/intellij/openapi/util/Couple;", "", "", "getHighlightOptionToSynonym", "()Ljava/util/Map;", "getRegistrar", "()Lcom/intellij/ide/ui/search/SearchableOptionsRegistrarImpl;", "storage$annotations", "()V", "getStorage", "load", "", "searchableOptions", "Ljava/net/URL;", "loadSynonyms", "putOptionWithHelpId", "option", "id", "groupName", "hit", "path", "intellij.platform.ide.impl"})
public final class SearchableOptionIndexLoader {
    @NotNull
    private final Map<CharSequence, long[]> storage;
    @NotNull
    private final Map<Couple<String>, Set<String>> highlightOptionToSynonym;
    @NotNull
    private final SearchableOptionsRegistrarImpl registrar;

    public static /* synthetic */ void storage$annotations() {
    }

    @NotNull
    public final Map<CharSequence, long[]> getStorage() {
        return this.storage;
    }

    @NotNull
    public final Map<Couple<String>, Set<String>> getHighlightOptionToSynonym() {
        return this.highlightOptionToSynonym;
    }

    public final void load(@NotNull Set<URL> searchableOptions) {
        Intrinsics.checkParameterIsNotNull(searchableOptions, (String)"searchableOptions");
        for (URL url : searchableOptions) {
            Element root;
            Intrinsics.checkExpressionValueIsNotNull((Object)JDOMUtil.load((URL)url), (String)"JDOMUtil.load(url)");
            for (Element configurable2 : root.getChildren("configurable")) {
                if (configurable2.getAttributeValue("id") == null) {
                    continue;
                }
                String groupName = configurable2.getAttributeValue("configurable_name");
                for (Element optionElement : configurable2.getChildren("option")) {
                    String id2;
                    String option2;
                    if (optionElement.getAttributeValue("name") == null) {
                        continue;
                    }
                    String path = optionElement.getAttributeValue("path");
                    String hit = optionElement.getAttributeValue("hit");
                    this.putOptionWithHelpId(option2, id2, groupName, hit, path);
                }
            }
        }
        this.loadSynonyms();
    }

    /*
     * WARNING - void declaration
     */
    private final void loadSynonyms() {
        Element root = JDOMUtil.load((InputStream)ResourceUtil.getResourceAsStream(SearchableOptionsRegistrar.class, (String)"/search/", (String)"synonyms.xml"));
        for (Element configurable2 : root.getChildren("configurable")) {
            String id2;
            Iterator<String> iterator2;
            if (configurable2.getAttributeValue("id") == null) {
                continue;
            }
            String groupName = configurable2.getAttributeValue("configurable_name");
            List synonyms = configurable2.getChildren("synonym");
            Iterator iterator3 = synonyms.iterator();
            while (iterator3.hasNext()) {
                String synonym;
                Element synonymElement;
                Element element2 = synonymElement = (Element)iterator3.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"synonymElement");
                if (element2.getTextNormalize() == null) {
                    continue;
                }
                Set<String> words = this.registrar.getProcessedWords(synonym);
                iterator2 = words.iterator();
                while (iterator2.hasNext()) {
                    String word;
                    String string = word = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"word");
                    this.putOptionWithHelpId(string, id2, groupName, synonym, null);
                }
            }
            for (Element optionElement : configurable2.getChildren("option")) {
                String option2 = optionElement.getAttributeValue("name");
                List list2 = optionElement.getChildren("synonym");
                iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    Object object;
                    Couple key$iv;
                    void $this$getOrPut$iv;
                    Object word;
                    String synonym;
                    Element synonymElement;
                    Element element3 = synonymElement = (Element)iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"synonymElement");
                    if (element3.getTextNormalize() == null) {
                        continue;
                    }
                    Set<String> words = this.registrar.getProcessedWords(synonym);
                    Iterator<String> iterator4 = words.iterator();
                    while (iterator4.hasNext()) {
                        Object object2 = word = iterator4.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"word");
                        this.putOptionWithHelpId((String)object2, id2, groupName, synonym, null);
                    }
                    word = this.highlightOptionToSynonym;
                    Intrinsics.checkExpressionValueIsNotNull((Object)Couple.of((Object)option2, (Object)id2), (String)"Couple.of(option, id)");
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl = false;
                        THashSet answer$iv = new THashSet();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Set)object).add(synonym);
                }
            }
        }
    }

    private final void putOptionWithHelpId(String option2, String id2, String groupName, String hit, String path) {
        SearchableOptionsRegistrarImpl.putOptionWithHelpId(option2, id2, groupName, hit, path, this.storage, this.registrar);
    }

    @NotNull
    public final SearchableOptionsRegistrarImpl getRegistrar() {
        return this.registrar;
    }

    public SearchableOptionIndexLoader(@NotNull SearchableOptionsRegistrarImpl registrar, @NotNull Map<CharSequence, long[]> storage) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)registrar), (String)"registrar");
        Intrinsics.checkParameterIsNotNull(storage, (String)"storage");
        this.registrar = registrar;
        this.storage = storage;
        this.highlightOptionToSynonym = (Map)new THashMap();
    }
}

