/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsBuiltInWhitelist;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionsCollectorImpl
extends ActionsCollector {
    private static final String GROUP = "actions";
    public static final String DEFAULT_ID = "third.party";
    private static final ActionsBuiltInWhitelist ourWhitelist = ActionsBuiltInWhitelist.getInstance();
    private final Map<AnAction, String> myOtherActions = ContainerUtil.createWeakMap();

    public void record(@Nullable String actionId, @Nullable InputEvent event, @NotNull Class context) {
        if (context == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(0);
        }
        String recorded = StringUtil.isNotEmpty((String)actionId) && ourWhitelist.isCustomAllowedAction(actionId) ? actionId : DEFAULT_ID;
        FeatureUsageData data2 = new FeatureUsageData().addData("action_id", recorded);
        if (event instanceof KeyEvent) {
            data2.addInputEvent((KeyEvent)event);
        } else if (event instanceof MouseEvent) {
            data2.addInputEvent((MouseEvent)event);
        }
        FUCounterUsageLogger.getInstance().logEvent(GROUP, "custom.action.invoked", data2);
    }

    public void record(@Nullable Project project, @Nullable AnAction action2, @Nullable AnActionEvent event, @Nullable Language lang) {
        ActionsCollectorImpl.record(GROUP, "action.invoked", project, action2, event, data2 -> {
            if (lang != null) {
                data2.addCurrentFile(lang);
            }
        });
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.3")
    public static void record(@NotNull String groupId2, @Nullable Project project, @Nullable AnAction action2, @Nullable AnActionEvent event, @Nullable Consumer<FeatureUsageData> configurator) {
        if (groupId2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(1);
        }
        ActionsCollectorImpl.record(groupId2, null, project, action2, event, configurator);
    }

    public static void record(@NotNull String groupId2, @Nullable String eventId, @Nullable Project project, @Nullable AnAction action2, @Nullable AnActionEvent event, @Nullable Consumer<FeatureUsageData> configurator) {
        if (groupId2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(2);
        }
        if (action2 == null) {
            return;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(action2.getClass());
        FeatureUsageData data2 = new FeatureUsageData().addProject(project).addPluginInfo(info);
        if (event != null) {
            data2.addInputEvent(event).addPlace(event.getPlace()).addData("context_menu", event.isFromContextMenu());
        }
        if (configurator != null) {
            configurator.accept(data2);
        }
        String actionClassName = info.isSafeToReport() ? action2.getClass().getName() : DEFAULT_ID;
        String actionId = ((ActionsCollectorImpl)ActionsCollectorImpl.getInstance()).getActionId(info, action2);
        if (action2 instanceof ActionWithDelegate) {
            Object delegate = ((ActionWithDelegate)action2).getDelegate();
            PluginInfo delegateInfo = PluginInfoDetectorKt.getPluginInfo(delegate.getClass());
            actionId = delegateInfo.isSafeToReport() ? delegate.getClass().getName() : DEFAULT_ID;
            data2.addData("class", actionId);
            data2.addData("parent", actionClassName);
        } else {
            data2.addData("class", actionClassName);
        }
        data2.addData("action_id", actionId);
        String reportedEventId = StringUtil.notNullize((String)eventId, (String)actionId);
        FUCounterUsageLogger.getInstance().logEvent(groupId2, reportedEventId, data2);
    }

    @NotNull
    private String getActionId(@NotNull PluginInfo pluginInfo, @NotNull AnAction action2) {
        if (pluginInfo == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(3);
        }
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(4);
        }
        if (!pluginInfo.isSafeToReport()) {
            return DEFAULT_ID;
        }
        String actionId = ActionManager.getInstance().getId(action2);
        if (actionId == null && action2 instanceof ActionIdProvider) {
            actionId = ((ActionIdProvider)action2).getId();
        }
        if (actionId != null && !ActionsCollectorImpl.canReportActionId(actionId)) {
            String string = action2.getClass().getName();
            if (string == null) {
                ActionsCollectorImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (actionId == null) {
            actionId = this.myOtherActions.get(action2);
        }
        String string = actionId != null ? actionId : action2.getClass().getName();
        if (string == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static boolean canReportActionId(@NotNull String actionId) {
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(7);
        }
        return ourWhitelist.isWhitelistedActionId(actionId);
    }

    public void onActionConfiguredByActionId(@NotNull AnAction action2, @NotNull String actionId) {
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(8);
        }
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(9);
        }
        if (ActionsCollectorImpl.canReportActionId(actionId)) {
            this.myOtherActions.put(action2, actionId);
        }
    }

    public static void onActionLoadedFromXml(@NotNull AnAction action2, @NotNull String actionId, @Nullable IdeaPluginDescriptor plugin) {
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(10);
        }
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(11);
        }
        ourWhitelist.addActionLoadedFromXml(actionId, plugin);
    }

    public static void onActionsLoadedFromKeymapXml(@NotNull Keymap keymap2, @NotNull Set<String> actionIds) {
        if (keymap2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(12);
        }
        if (actionIds == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(13);
        }
        ourWhitelist.addActionsLoadedFromKeymapXml(keymap2, actionIds);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginInfo";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymap";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getActionId";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canReportActionId";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onActionConfiguredByActionId";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onActionLoadedFromXml";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onActionsLoadedFromKeymapXml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

