/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.encoding;

import com.intellij.largeFilesEditor.encoding.ChangeFileEncodingAction;
import com.intellij.largeFilesEditor.encoding.LargeFileEditorAccess;
import com.intellij.largeFilesEditor.encoding.LargeFileEditorAccessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class EncodingWidget
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget {
    public static final String WIDGET_ID = "lfeEncoding";
    private static final Logger logger = Logger.getInstance(EncodingWidget.class);
    private final TextPanel myComponent;
    private Alarm myUpdateAlarm;
    private final LargeFileEditorAccessor myLargeFileEditorAccessor;
    private boolean myActionEnabled;

    public EncodingWidget(@NotNull Project project, LargeFileEditorAccessor largeFileEditorAccessor) {
        if (project == null) {
            EncodingWidget.$$$reportNull$$$0(0);
        }
        super(project);
        this.myLargeFileEditorAccessor = largeFileEditorAccessor;
        this.myComponent = new TextPanel.WithIconAndArrows();
        this.myComponent.setBorder(StatusBarWidget.WidgetBorder.WIDE);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            EncodingWidget.$$$reportNull$$$0(1);
        }
        this.requestUpdate();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            EncodingWidget.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            EncodingWidget.$$$reportNull$$$0(3);
        }
        this.requestUpdate();
    }

    public StatusBarWidget copy() {
        return new EncodingWidget(this.getProject(), this.myLargeFileEditorAccessor);
    }

    @NotNull
    public String ID() {
        return WIDGET_ID;
    }

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            EncodingWidget.$$$reportNull$$$0(4);
        }
        super.install(statusBar);
        this.myUpdateAlarm = new Alarm((Disposable)this);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                EncodingWidget.this.requestUpdate();
                EncodingWidget.this.tryShowPopup();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/largeFilesEditor/encoding/EncodingWidget$1", "onClick"));
            }
        }.installOn((Component)this.myComponent, true);
    }

    private void tryShowPopup() {
        if (!this.myActionEnabled) {
            return;
        }
        LargeFileEditorAccess largeFileEditorAccess = this.myLargeFileEditorAccessor.getAccess(this.getProject(), this.myStatusBar);
        if (largeFileEditorAccess != null) {
            this.showPopup(largeFileEditorAccess);
        } else {
            logger.warn("[LargeFileEditorSubsystem] EncodingWidget.tryShowPopup(): this method was called while LargeFileEditor is not available as active text editor");
            this.requestUpdate();
        }
    }

    private void showPopup(@NotNull LargeFileEditorAccess largeFileEditorAccess) {
        if (largeFileEditorAccess == null) {
            EncodingWidget.$$$reportNull$$$0(5);
        }
        ChangeFileEncodingAction action2 = new ChangeFileEncodingAction(this.myLargeFileEditorAccessor, this.getProject(), this.myStatusBar);
        JComponent where = this.getComponent();
        ListPopup popup2 = action2.createPopup(largeFileEditorAccess.getVirtualFile(), largeFileEditorAccess.getEditor(), where);
        RelativePoint pos = JBPopupFactory.getInstance().guessBestPopupLocation(where);
        popup2.showInScreenCoordinates((Component)where, pos.getScreenPoint());
    }

    public Project _getProject() {
        return this.getProject();
    }

    public void requestUpdate() {
        if (this.myUpdateAlarm.isDisposed()) {
            return;
        }
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(() -> this.update(), 200, ModalityState.any());
    }

    private void update() {
        String charsetName;
        String toolTipText;
        if (this.isDisposed()) {
            return;
        }
        LargeFileEditorAccess largeFileEditorAccess = this.myLargeFileEditorAccessor.getAccess(this.getProject(), this.myStatusBar);
        this.myActionEnabled = false;
        if (largeFileEditorAccess == null) {
            toolTipText = "";
            charsetName = "";
            this.myComponent.setVisible(false);
        } else {
            this.myActionEnabled = true;
            charsetName = largeFileEditorAccess.getCharsetName();
            toolTipText = EditorBundle.message((String)"large.file.editor.tooltip.file.encoding.is.some", (Object[])new Object[]{charsetName});
            this.myComponent.setVisible(true);
        }
        this.myComponent.setToolTipText(toolTipText);
        this.myComponent.setText(charsetName);
        if (this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        } else {
            logger.warn("[LargeFileEditorSubsystem] EncodingWidget.requestUpdate(): myStatusBar is null!!!)");
        }
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "largeFileEditorAccess";
                break;
            }
        }
        objectArray2[1] = "com/intellij/largeFilesEditor/encoding/EncodingWidget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fileOpened";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showPopup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

