/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.StringEscapesTokenTypes;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class ToggleCaseAction
extends TextComponentEditorAction {
    public ToggleCaseAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
            Ref toLowerCase = new Ref((Object)Boolean.FALSE);
            Handler.runForCaret(editor, caret, c -> {
                if (!c.hasSelection()) {
                    c.selectWordAtCaret(true);
                }
                int selectionStartOffset = c.getSelectionStart();
                int selectionEndOffset = c.getSelectionEnd();
                String originalText = editor.getDocument().getText(new TextRange(selectionStartOffset, selectionEndOffset));
                if (!originalText.equals(Handler.toCase(editor, selectionStartOffset, selectionEndOffset, true))) {
                    toLowerCase.set((Object)Boolean.TRUE);
                }
            });
            Handler.runForCaret(editor, caret, c -> {
                VisualPosition caretPosition = c.getVisualPosition();
                int selectionStartOffset = c.getSelectionStart();
                int selectionEndOffset = c.getSelectionEnd();
                editor.getDocument().replaceString(selectionStartOffset, selectionEndOffset, (CharSequence)Handler.toCase(editor, selectionStartOffset, selectionEndOffset, (Boolean)toLowerCase.get()));
                c.moveToVisualPosition(caretPosition);
            });
        }

        private static void runForCaret(Editor editor, Caret caret, CaretAction action2) {
            if (caret == null) {
                editor.getCaretModel().runForEachCaret(action2);
            } else {
                action2.perform(caret);
            }
        }

        private static String toCase(Editor editor, int startOffset, int endOffset, boolean lower) {
            EditorHighlighter highlighter;
            CharSequence text2 = editor.getDocument().getImmutableCharSequence();
            if (editor instanceof EditorEx) {
                highlighter = ((EditorEx)editor).getHighlighter();
            } else {
                highlighter = new EmptyEditorHighlighter(null);
                highlighter.setText(text2);
            }
            HighlighterIterator iterator2 = highlighter.createIterator(startOffset);
            StringBuilder builder2 = new StringBuilder(endOffset - startOffset);
            while (!iterator2.atEnd()) {
                int start2 = Handler.trim(iterator2.getStart(), startOffset, endOffset);
                int end = Handler.trim(iterator2.getEnd(), startOffset, endOffset);
                CharSequence fragment = text2.subSequence(start2, end);
                builder2.append(iterator2.getTokenType() == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN ? fragment : (lower ? fragment.toString().toLowerCase(Locale.getDefault()) : fragment.toString().toUpperCase(Locale.getDefault())));
                if (end == endOffset) break;
                iterator2.advance();
            }
            return builder2.toString();
        }

        private static int trim(int value2, int lowerLimit, int upperLimit) {
            return Math.min(upperLimit, Math.max(lowerLimit, value2));
        }
    }
}

