/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.TDoubleArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractProgressIndicatorBase
extends UserDataHolderBase
implements ProgressIndicator {
    private static final Logger LOG = Logger.getInstance(AbstractProgressIndicatorBase.class);
    private volatile String myText;
    private volatile double myFraction;
    private volatile String myText2;
    private volatile boolean myCanceled;
    private volatile boolean myRunning;
    private volatile boolean myFinished;
    private volatile boolean myIndeterminate = Registry.is((String)"ide.progress.indeterminate.by.default", (boolean)true);
    private volatile MacUtil.Activity myMacActivity;
    private volatile boolean myShouldStartActivity = true;
    private Stack<String> myTextStack;
    private TDoubleArrayList myFractionStack;
    private Stack<String> myText2Stack;
    private ProgressIndicator myModalityProgress;
    private volatile ModalityState myModalityState = ModalityState.NON_MODAL;
    private volatile int myNonCancelableSectionCount;
    private final Object lock = ObjectUtils.sentinel((String)"APIB lock");
    private static final Set<Class<?>> ourReportedReuseExceptions = ContainerUtil.newConcurrentSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.getLock();
        synchronized (object) {
            LOG.assertTrue(!this.isRunning(), (Object)"Attempt to start ProgressIndicator which is already running");
            if (this.myFinished) {
                if (this.myCanceled && !this.isReuseable() && ourReportedReuseExceptions.add(((Object)((Object)this)).getClass())) {
                    LOG.error("Attempt to start ProgressIndicator which is cancelled and already stopped:" + (Object)((Object)this) + "," + ((Object)((Object)this)).getClass());
                }
                this.myCanceled = false;
                this.myFinished = false;
            }
            this.myText = "";
            this.myFraction = 0.0;
            this.myText2 = "";
            this.startSystemActivity();
            this.myRunning = true;
        }
    }

    protected boolean isReuseable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.getLock();
        synchronized (object) {
            LOG.assertTrue(this.myRunning, (Object)"stop() should be called only if start() called before");
            this.myRunning = false;
            this.myFinished = true;
            this.stopSystemActivity();
        }
    }

    private void startSystemActivity() {
        this.myMacActivity = this.myShouldStartActivity ? MacUtil.wakeUpNeo((Object)((Object)this)) : null;
    }

    void stopSystemActivity() {
        MacUtil.Activity macActivity = this.myMacActivity;
        if (macActivity != null) {
            macActivity.matrixHasYou();
            this.myMacActivity = null;
        }
    }

    public boolean isRunning() {
        return this.myRunning;
    }

    public void cancel() {
        this.myCanceled = true;
        this.stopSystemActivity();
        if (ApplicationManager.getApplication() != null) {
            ProgressManager.canceled((ProgressIndicator)this);
        }
    }

    public boolean isCanceled() {
        return this.myCanceled;
    }

    public void checkCanceled() {
        this.throwIfCanceled();
        if (CoreProgressManager.runCheckCanceledHooks(this)) {
            this.throwIfCanceled();
        }
    }

    private void throwIfCanceled() {
        if (this.isCanceled() && this.isCancelable()) {
            Throwable trace = this.getCancellationTrace();
            throw trace instanceof ProcessCanceledException ? (ProcessCanceledException)trace : new ProcessCanceledException(trace);
        }
    }

    @Nullable
    protected Throwable getCancellationTrace() {
        if (this instanceof Disposable) {
            return Disposer.getDisposalTrace((Disposable)((Disposable)this));
        }
        return null;
    }

    public void setText(String text2) {
        this.myText = text2;
    }

    public String getText() {
        return this.myText;
    }

    public void setText2(String text2) {
        this.myText2 = text2;
    }

    public String getText2() {
        return this.myText2;
    }

    public double getFraction() {
        return this.myFraction;
    }

    public void setFraction(double fraction) {
        if (this.isIndeterminate()) {
            StackTraceElement[] trace = new Throwable().getStackTrace();
            Optional<StackTraceElement> first = Arrays.stream(trace).filter(element2 -> !element2.getClassName().startsWith("com.intellij.openapi.progress.util")).findFirst();
            String message = "This progress indicator is indeterminate, this may lead to visual inconsistency. Please call setIndeterminate(false) before you start progress.";
            if (first.isPresent()) {
                message = message + "\n" + first.get();
            }
            LOG.warn(message);
            this.setIndeterminate(false);
        }
        this.myFraction = fraction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushState() {
        Object object = this.getLock();
        synchronized (object) {
            this.getTextStack().push((Object)this.myText);
            this.getFractionStack().add(this.myFraction);
            this.getText2Stack().push((Object)this.myText2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popState() {
        Object object = this.getLock();
        synchronized (object) {
            LOG.assertTrue(!this.myTextStack.isEmpty());
            String oldText = (String)this.myTextStack.pop();
            String oldText2 = (String)this.myText2Stack.pop();
            this.setText(oldText);
            this.setText2(oldText2);
            double oldFraction = this.myFractionStack.remove(this.myFractionStack.size() - 1);
            if (!this.isIndeterminate()) {
                this.setFraction(oldFraction);
            }
        }
    }

    public void startNonCancelableSection() {
        ++this.myNonCancelableSectionCount;
    }

    public void finishNonCancelableSection() {
        --this.myNonCancelableSectionCount;
    }

    protected boolean isCancelable() {
        return this.myNonCancelableSectionCount == 0 && !ProgressManager.getInstance().isInNonCancelableSection();
    }

    public final boolean isModal() {
        return this.myModalityProgress != null;
    }

    final boolean isModalEntity() {
        return this.myModalityProgress == this;
    }

    @NotNull
    public ModalityState getModalityState() {
        ModalityState modalityState = this.myModalityState;
        if (modalityState == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(0);
        }
        return modalityState;
    }

    public void setModalityProgress(@Nullable ProgressIndicator modalityProgress) {
        LOG.assertTrue(!this.isRunning());
        this.myModalityProgress = modalityProgress;
        this.setModalityState(modalityProgress);
    }

    private void setModalityState(@Nullable ProgressIndicator modalityProgress) {
        ModalityState modalityState = ModalityState.defaultModalityState();
        if (modalityProgress != null) {
            modalityState = ((ModalityStateEx)modalityState).appendProgress(modalityProgress);
            ((TransactionGuardImpl)TransactionGuard.getInstance()).enteredModality(modalityState);
        }
        this.myModalityState = modalityState;
    }

    public boolean isIndeterminate() {
        return this.myIndeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.myIndeterminate = indeterminate;
    }

    @NonNls
    public String toString() {
        return "ProgressIndicator " + System.identityHashCode((Object)this) + ": running=" + this.isRunning() + "; canceled=" + this.isCanceled();
    }

    public boolean isPopupWasShown() {
        return true;
    }

    public boolean isShowing() {
        return this.isModal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initStateFrom(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(1);
        }
        Object object = this.getLock();
        synchronized (object) {
            this.myRunning = indicator.isRunning();
            this.myCanceled = indicator.isCanceled();
            this.myFraction = indicator.getFraction();
            this.myIndeterminate = indicator.isIndeterminate();
            this.myText = indicator.getText();
            this.myText2 = indicator.getText2();
            this.myFraction = indicator.getFraction();
            if (indicator instanceof AbstractProgressIndicatorBase) {
                AbstractProgressIndicatorBase stacked = (AbstractProgressIndicatorBase)indicator;
                this.myTextStack = stacked.myTextStack == null ? null : new Stack(stacked.getTextStack());
                this.myText2Stack = stacked.myText2Stack == null ? null : new Stack(stacked.getText2Stack());
                this.myFractionStack = stacked.myFractionStack == null ? null : new TDoubleArrayList(stacked.getFractionStack().toNativeArray());
            }
            this.dontStartActivity();
        }
    }

    protected void dontStartActivity() {
        this.myShouldStartActivity = false;
    }

    @NotNull
    private Stack<String> getTextStack() {
        Stack stack = this.myTextStack;
        if (stack == null) {
            this.myTextStack = stack = new Stack(2);
        }
        Stack stack2 = stack;
        if (stack2 == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(2);
        }
        return stack2;
    }

    @NotNull
    private TDoubleArrayList getFractionStack() {
        TDoubleArrayList stack = this.myFractionStack;
        if (stack == null) {
            this.myFractionStack = stack = new TDoubleArrayList(2);
        }
        TDoubleArrayList tDoubleArrayList = stack;
        if (tDoubleArrayList == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(3);
        }
        return tDoubleArrayList;
    }

    @NotNull
    private Stack<String> getText2Stack() {
        Stack stack = this.myText2Stack;
        if (stack == null) {
            this.myText2Stack = stack = new Stack(2);
        }
        Stack stack2 = stack;
        if (stack2 == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(4);
        }
        return stack2;
    }

    @NotNull
    protected Object getLock() {
        Object object = this.lock;
        if (object == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(5);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/AbstractProgressIndicatorBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/AbstractProgressIndicatorBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextStack";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFractionStack";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText2Stack";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLock";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initStateFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

