/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SmartPointerManagerImpl
extends SmartPointerManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SmartPointerManagerImpl.class);
    private final Project myProject;
    private final Key<SmartPointerTracker> POINTERS_KEY;
    private final PsiDocumentManagerBase myPsiDocManager;
    private static final Key<Reference<SmartPsiElementPointerImpl<?>>> CACHED_SMART_POINTER_KEY = Key.create((String)"CACHED_SMART_POINTER_KEY");

    public SmartPointerManagerImpl(@NotNull Project project) {
        if (project == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myPsiDocManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project);
        this.POINTERS_KEY = Key.create((String)("SMART_POINTERS " + (project.isDefault() ? "default" : Integer.valueOf(project.hashCode()))));
    }

    public void dispose() {
        SmartPointerTracker.processQueue();
    }

    @NotNull
    private static String anonymize(@NotNull Project project) {
        if (project == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(1);
        }
        String string = (project.isDisposed() ? "(Disposed)" : "") + (project.isDefault() ? "(Default)" : "") + project.hashCode();
        if (string == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void fastenBelts(@NotNull VirtualFile file2) {
        SmartPointerTracker pointers2;
        if (file2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(3);
        }
        if ((pointers2 = this.getTracker(file2)) != null) {
            pointers2.fastenBelts(this);
        }
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element2) {
        if (element2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element2.getContainingFile();
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element2, containingFile);
        if (smartPsiElementPointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(5);
        }
        return smartPsiElementPointer;
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element2, PsiFile containingFile) {
        if (element2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(6);
        }
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element2, containingFile, false);
        if (smartPsiElementPointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(7);
        }
        return smartPsiElementPointer;
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element2, PsiFile containingFile, boolean forInjected) {
        if (element2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(8);
        }
        SmartPointerManagerImpl.ensureValid(element2, containingFile);
        SmartPointerTracker.processQueue();
        this.ensureMyProject(containingFile != null ? containingFile.getProject() : element2.getProject());
        SmartPsiElementPointerImpl<E> pointer = SmartPointerManagerImpl.getCachedPointer(element2);
        if (!(pointer == null || pointer.getElementInfo() instanceof SelfElementInfo && ((SelfElementInfo)pointer.getElementInfo()).isForInjected() != forInjected || pointer.incrementAndGetReferenceCount(1) <= 0)) {
            SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
            if (smartPsiElementPointerImpl == null) {
                SmartPointerManagerImpl.$$$reportNull$$$0(9);
            }
            return smartPsiElementPointerImpl;
        }
        pointer = new SmartPsiElementPointerImpl<E>(this, element2, containingFile, forInjected);
        if (containingFile != null) {
            this.trackPointer(pointer, containingFile.getViewProvider().getVirtualFile());
        }
        element2.putUserData(CACHED_SMART_POINTER_KEY, (Object)new SoftReference(pointer));
        SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
        if (smartPsiElementPointerImpl == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(10);
        }
        return smartPsiElementPointerImpl;
    }

    private void ensureMyProject(@NotNull Project project) {
        if (project == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(11);
        }
        if (project != this.myProject) {
            throw new IllegalArgumentException("Element from alien project: " + SmartPointerManagerImpl.anonymize(project) + " expected: " + SmartPointerManagerImpl.anonymize(this.myProject));
        }
    }

    private static void ensureValid(@NotNull PsiElement element2, @Nullable PsiFile containingFile) {
        boolean valid;
        if (element2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(12);
        }
        boolean bl = valid = containingFile != null ? containingFile.isValid() : element2.isValid();
        if (!valid) {
            PsiUtilCore.ensureValid((PsiElement)element2);
            if (containingFile != null && !containingFile.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)containingFile, "Element " + element2.getClass() + "(" + element2.getLanguage() + ") claims to be valid but returns invalid containing file ");
            }
        }
    }

    private static <E extends PsiElement> SmartPsiElementPointerImpl<E> getCachedPointer(@NotNull E element2) {
        Object cachedElement;
        Reference data2;
        SmartPsiElementPointerImpl cachedPointer;
        if (element2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(13);
        }
        if ((cachedPointer = (SmartPsiElementPointerImpl)SoftReference.dereference((Reference)(data2 = (Reference)element2.getUserData(CACHED_SMART_POINTER_KEY)))) != null && (cachedElement = cachedPointer.getElement()) != element2) {
            return null;
        }
        return cachedPointer;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range2) {
        if (file2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(14);
        }
        if (range2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(15);
        }
        SmartPsiFileRange smartPsiFileRange = this.createSmartPsiFileRangePointer(file2, range2, false);
        if (smartPsiFileRange == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(16);
        }
        return smartPsiFileRange;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range2, boolean forInjected) {
        if (file2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(17);
        }
        if (range2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(18);
        }
        PsiUtilCore.ensureValid((PsiElement)file2);
        SmartPointerTracker.processQueue();
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(this, file2, ProperTextRange.create((Segment)range2), forInjected);
        this.trackPointer(pointer, file2.getViewProvider().getVirtualFile());
        SmartPsiFileRangePointerImpl smartPsiFileRangePointerImpl = pointer;
        if (smartPsiFileRangePointerImpl == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(19);
        }
        return smartPsiFileRangePointerImpl;
    }

    private <E extends PsiElement> void trackPointer(@NotNull SmartPsiElementPointerImpl<E> pointer, @NotNull VirtualFile containingFile) {
        SmartPointerTracker pointers2;
        SmartPointerElementInfo info;
        if (pointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(20);
        }
        if (containingFile == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(21);
        }
        if (!((info = pointer.getElementInfo()) instanceof SelfElementInfo)) {
            return;
        }
        SmartPointerTracker.PointerReference reference2 = new SmartPointerTracker.PointerReference(pointer, containingFile, this.POINTERS_KEY);
        do {
            if ((pointers2 = this.getTracker(containingFile)) != null) continue;
            pointers2 = (SmartPointerTracker)containingFile.putUserDataIfAbsent(this.POINTERS_KEY, (Object)new SmartPointerTracker());
        } while (!pointers2.addReference(reference2, pointer));
    }

    public void removePointer(@NotNull SmartPsiElementPointer<?> pointer) {
        if (pointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(22);
        }
        if (!(pointer instanceof SmartPsiElementPointerImpl) || this.myProject.isDisposed()) {
            return;
        }
        this.ensureMyProject(pointer.getProject());
        int refCount = ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(-1);
        if (refCount == -1) {
            LOG.error("Double smart pointer removal");
            return;
        }
        if (refCount == 0) {
            PsiElement element2 = ((SmartPointerEx)pointer).getCachedElement();
            if (element2 != null) {
                element2.putUserData(CACHED_SMART_POINTER_KEY, null);
            }
            SmartPointerElementInfo info = ((SmartPsiElementPointerImpl)pointer).getElementInfo();
            info.cleanup();
            SmartPointerTracker.PointerReference reference2 = ((SmartPsiElementPointerImpl)pointer).pointerReference;
            if (reference2 != null) {
                if (reference2.get() != pointer) {
                    throw new IllegalStateException("Reference points to " + reference2.get());
                }
                if (reference2.key != this.POINTERS_KEY) {
                    throw new IllegalStateException("Reference from wrong project: " + reference2.key + " vs " + this.POINTERS_KEY);
                }
                SmartPointerTracker pointers2 = this.getTracker(reference2.file);
                if (pointers2 != null) {
                    pointers2.removeReference(reference2);
                }
            }
        }
    }

    @Nullable
    SmartPointerTracker getTracker(@NotNull VirtualFile containingFile) {
        if (containingFile == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(23);
        }
        return (SmartPointerTracker)containingFile.getUserData(this.POINTERS_KEY);
    }

    public int getPointersNumber(@NotNull PsiFile containingFile) {
        VirtualFile file2;
        SmartPointerTracker pointers2;
        if (containingFile == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(24);
        }
        return (pointers2 = this.getTracker(file2 = containingFile.getViewProvider().getVirtualFile())) == null ? 0 : pointers2.getSize();
    }

    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer<?> pointer1, @NotNull SmartPsiElementPointer<?> pointer2) {
        if (pointer1 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(25);
        }
        if (pointer2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(26);
        }
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }

    public void updatePointers(@NotNull Document document, @NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        VirtualFile file2;
        SmartPointerTracker list2;
        if (document == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(27);
        }
        if (frozen == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(28);
        }
        if (events == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(29);
        }
        SmartPointerTracker smartPointerTracker = list2 = (file2 = FileDocumentManager.getInstance().getFile(document)) == null ? null : this.getTracker(file2);
        if (list2 != null) {
            list2.updateMarkers(frozen, events);
        }
    }

    public void updatePointerTargetsAfterReparse(@NotNull VirtualFile file2) {
        SmartPointerTracker list2;
        if (file2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(30);
        }
        if ((list2 = this.getTracker(file2)) != null) {
            list2.updatePointerTargetsAfterReparse();
        }
    }

    @NotNull
    Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(31);
        }
        return project;
    }

    @NotNull
    PsiDocumentManagerBase getPsiDocumentManager() {
        PsiDocumentManagerBase psiDocumentManagerBase = this.myPsiDocManager;
        if (psiDocumentManagerBase == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(32);
        }
        return psiDocumentManagerBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl";
                break;
            }
            case 3: 
            case 14: 
            case 17: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer1";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer2";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frozen";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "anonymize";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmartPsiElementPointer";
                break;
            }
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmartPsiFileRangePointer";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiDocumentManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "anonymize";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 31: 
            case 32: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fastenBelts";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSmartPsiElementPointer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "ensureMyProject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPointer";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createSmartPsiFileRangePointer";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "trackPointer";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removePointer";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTracker";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPointersNumber";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "pointToTheSameElement";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updatePointers";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updatePointerTargetsAfterReparse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

