/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.xml.breadcrumbs.BreadcrumbsForceShownSettings;
import com.intellij.xml.breadcrumbs.ToggleBreadcrumbsAction;
import org.jetbrains.annotations.NotNull;

class ToggleBreadcrumbsSettingsAction
extends ToggleBreadcrumbsAction {
    private final boolean show;
    private final boolean above;

    private ToggleBreadcrumbsSettingsAction(boolean show2, boolean above) {
        this.show = show2;
        this.above = above;
    }

    @Override
    public boolean isSelected(@NotNull AnActionEvent event) {
        if (event == null) {
            ToggleBreadcrumbsSettingsAction.$$$reportNull$$$0(0);
        }
        boolean selected2 = super.isSelected(event);
        if (this.show && selected2) {
            return this.above == EditorSettingsExternalizable.getInstance().isBreadcrumbsAbove();
        }
        return !this.show && !selected2;
    }

    public void setSelected(AnActionEvent event, boolean selected2) {
        Editor editor = ToggleBreadcrumbsSettingsAction.findEditor(event);
        boolean modified = editor != null && BreadcrumbsForceShownSettings.setForcedShown(null, editor);
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        if (settings.setBreadcrumbsShown(this.show)) {
            modified = true;
        }
        if (this.show) {
            String languageID;
            if (settings.setBreadcrumbsAbove(this.above)) {
                modified = true;
            }
            if ((languageID = ToggleBreadcrumbsSettingsAction.findLanguageID(event)) != null && settings.setBreadcrumbsShownFor(languageID, true)) {
                modified = true;
            }
        }
        if (modified) {
            UISettings.getInstance().fireUISettingsChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/ToggleBreadcrumbsSettingsAction", "isSelected"));
    }

    static final class HideBoth
    extends ToggleBreadcrumbsSettingsAction {
        HideBoth() {
            super(false, false);
        }
    }

    static final class ShowBelow
    extends ToggleBreadcrumbsSettingsAction {
        ShowBelow() {
            super(true, false);
        }
    }

    static final class ShowAbove
    extends ToggleBreadcrumbsSettingsAction {
        ShowAbove() {
            super(true, true);
        }
    }
}

