/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;

public class SimpleTerminalPipe {
    private final MyPipedInputStream myInputStream;
    private final PipedOutputStream myReversedInputStream;
    private final OutputStream myOutputStream;
    private final PipedInputStream myReversedOutputStream;

    public SimpleTerminalPipe(@NotNull String debugId) throws IOException {
        if (debugId == null) {
            SimpleTerminalPipe.$$$reportNull$$$0(0);
        }
        this.myInputStream = new MyPipedInputStream(debugId + ":writeToT");
        this.myReversedInputStream = new MyPipedOutputStream(this.myInputStream);
        this.myReversedOutputStream = new MyPipedInputStream(":readFromT");
        this.myOutputStream = new MyPipedOutputStream(this.myReversedOutputStream);
    }

    public InputStream getTerminalOutput() {
        return this.myInputStream;
    }

    public OutputStream getTerminalInput() {
        return this.myOutputStream;
    }

    public PipedOutputStream getWriteToTerminalStream() {
        return this.myReversedInputStream;
    }

    public PipedInputStream getReadFromTerminalStream() {
        return this.myReversedOutputStream;
    }

    public void close() throws IOException {
        this.myOutputStream.close();
        this.myReversedInputStream.close();
    }

    protected void releaseWriteToTerminalThread() {
        this.myInputStream.forgetWriterThread();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugId", "com/intellij/docker/agent/SimpleTerminalPipe", "<init>"));
    }

    public static class MyPipedOutputStream
    extends PipedOutputStream {
        public MyPipedOutputStream(PipedInputStream snk) throws IOException {
            super(snk);
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            this.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.flush();
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
            if (b == null) {
                MyPipedOutputStream.$$$reportNull$$$0(0);
            }
            this.write(b, 0, b.length);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/docker/agent/SimpleTerminalPipe$MyPipedOutputStream", "write"));
        }
    }

    public static class MyPipedInputStream
    extends PipedInputStream {
        private static final String WITHOUT_ID = "<unnamed>";
        private final String myDebugId;
        private static Field ourWriteSideField;
        private static boolean ourWriteSideFieldNotAccessible;

        public MyPipedInputStream() {
            this(WITHOUT_ID);
        }

        public MyPipedInputStream(String debugId) {
            this.myDebugId = debugId;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            try {
                int n = super.read(b, off, len);
                return n;
            }
            catch (IOException e) {
                throw this.appendIdToPipeException(e);
            }
            finally {
                this.notifyAll();
            }
        }

        @NotNull
        private IOException appendIdToPipeException(@NotNull IOException exception) {
            if (exception == null) {
                MyPipedInputStream.$$$reportNull$$$0(0);
            }
            if (WITHOUT_ID.equals(this.myDebugId)) {
                IOException iOException = exception;
                if (iOException == null) {
                    MyPipedInputStream.$$$reportNull$$$0(1);
                }
                return iOException;
            }
            if (exception.getMessage() == null || !exception.getMessage().contains("Pipe")) {
                IOException iOException = exception;
                if (iOException == null) {
                    MyPipedInputStream.$$$reportNull$$$0(2);
                }
                return iOException;
            }
            return new IOException(exception.getMessage() + ", pipe id: `" + this.myDebugId + "`", exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forgetWriterThread() {
            if (ourWriteSideFieldNotAccessible) {
                return;
            }
            Field accessor = MyPipedInputStream.getWriteSideAccessor();
            try {
                assert (accessor != null);
                MyPipedInputStream myPipedInputStream = this;
                synchronized (myPipedInputStream) {
                    accessor.set(this, null);
                }
            }
            catch (IllegalAccessException e) {
                ourWriteSideFieldNotAccessible = true;
                throw new IllegalStateException("Can't fix write side: " + this.myDebugId, e);
            }
        }

        private static Field getWriteSideAccessor() {
            if (ourWriteSideFieldNotAccessible) {
                throw new IllegalStateException();
            }
            if (ourWriteSideField == null) {
                try {
                    ourWriteSideField = MyPipedInputStream.class.getSuperclass().getDeclaredField("writeSide");
                    ourWriteSideField.setAccessible(true);
                }
                catch (NoSuchFieldException | SecurityException e) {
                    ourWriteSideFieldNotAccessible = true;
                    throw new IllegalStateException("Can't fix write side reflectively", e);
                }
            }
            return ourWriteSideField;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exception";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/agent/SimpleTerminalPipe$MyPipedInputStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/agent/SimpleTerminalPipe$MyPipedInputStream";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendIdToPipeException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "appendIdToPipeException";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

