/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.puppet.PuppetLanguage;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.formatter.PuppetAlignmentProcessor;
import com.intellij.lang.puppet.formatter.PuppetFormattingBlock;
import com.intellij.lang.puppet.formatter.PuppetIndentProcessor;
import com.intellij.lang.puppet.formatter.PuppetWrappingProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class PuppetFormattingModelBuilder
implements FormattingModelBuilder {
    private static final TokenSet NO_SPACE_BEFORE_SPACE_AFTER_TOKENSET = TokenSet.create((IElementType[])new IElementType[]{PuppetTokenTypes.COMMA, PuppetTokenTypes.COLON, PuppetTokenTypes.SEMIC});
    private static final TokenSet SPACES_AROUND_TOKENSET = TokenSet.create((IElementType[])new IElementType[]{PuppetTokenTypes.FARROW, PuppetTokenTypes.PARROW, PuppetTokenTypes.APPENDS, PuppetTokenTypes.DELETES, PuppetTokenTypes.NOTEQUAL, PuppetTokenTypes.QMARK, PuppetTokenTypes.ISEQUAL, PuppetTokenTypes.GREATEREQUAL, PuppetTokenTypes.LESSEQUAL, PuppetTokenTypes.LSHIFT, PuppetTokenTypes.RSHIFT, PuppetTokenTypes.MATCH, PuppetTokenTypes.NOMATCH, PuppetTokenTypes.OUT_EDGE, PuppetTokenTypes.IN_EDGE, PuppetTokenTypes.IN_EDGE_SUB, PuppetTokenTypes.OUT_EDGE_SUB, PuppetTokenTypes.EQUALS, PuppetTokenTypes.GREATERTHAN, PuppetTokenTypes.LESSTHAN, PuppetTokenTypes.MODULO, PuppetTokenTypes.DIV, PuppetTokenTypes.PLUS, PuppetTokenTypes.MINUS, PuppetTokenTypes.TIMES, PuppetTokenTypes.PARENTHESIZED_PARAMETERS_LIST_BLOCK, PuppetTokenTypes.PIPED_PARAMETERS_LIST_BLOCK});
    private static final TokenSet POSSIBLE_UNARY_OPS = TokenSet.create((IElementType[])new IElementType[]{PuppetTokenTypes.MINUS, PuppetTokenTypes.NOT, PuppetTokenTypes.TIMES});
    private static final TokenSet NO_SPACES_AROUND_TOKENSET = TokenSet.create((IElementType[])new IElementType[]{PuppetTokenTypes.DOT});
    private static final TokenSet SPACE_BEFORE_TOKENSET = TokenSet.create((IElementType[])new IElementType[]{PuppetTokenTypes.BRACED_STATEMENTS_BLOCK, PuppetTokenTypes.BRACED_RESOURCE_BY_CLASSNAME_CONTENTS_BLOCK, PuppetTokenTypes.RESOURCE_LIKE_CLASS_DECLARATION_BLOCK, PuppetTokenTypes.BRACED_CASE_OPTS_BLOCK, PuppetTokenTypes.BRACED_SELECTOR_VALUES_BLOCK, PuppetTokenTypes.ANONYMOUS_BLOCK});

    @NotNull
    public FormattingModel createModel(PsiElement rootElement, CodeStyleSettings settings) {
        PsiFile file = rootElement.getContainingFile();
        PuppetFormattingBlock rootBlock = new PuppetFormattingBlock(rootElement.getNode(), PuppetFormattingModelBuilder.createSpacingBuilder(settings), new PuppetIndentProcessor(), new PuppetAlignmentProcessor(), new PuppetWrappingProcessor(file));
        return new DocumentBasedFormattingModel((Block)rootBlock, file.getProject(), settings, file.getFileType(), file);
    }

    private static SpacingBuilder createSpacingBuilder(CodeStyleSettings settings) {
        return new SpacingBuilder(settings, (Language)PuppetLanguage.INSTANCE).between(PuppetTokenTypes.LPAREN, PuppetTokenTypes.PARAMETER).lineBreakInCodeIf(true).between(PuppetTokenTypes.PARAMETER, PuppetTokenTypes.RPAREN).lineBreakInCodeIf(true).betweenInside(PuppetTokenTypes.COMMA, PuppetTokenTypes.PARAMETER, PuppetTokenTypes.PARENTHESIZED_PARAMETERS_LIST_BLOCK).lineBreakInCodeIf(true).betweenInside(PuppetTokenTypes.PARAMETER, PuppetTokenTypes.COMMA, PuppetTokenTypes.PARENTHESIZED_PARAMETERS_LIST_BLOCK).lineBreakInCodeIf(false).betweenInside(PuppetTokenTypes.COMMA, PuppetTokenTypes.RPAREN, PuppetTokenTypes.PARENTHESIZED_PARAMETERS_LIST_BLOCK).lineBreakInCodeIf(true).between(PuppetTokenTypes.SEMIC, PuppetTokenTypes.RESOURCE_INSTANCE_DECLARATION).lineBreakInCodeIf(true).between(PuppetTokenTypes.LBRACE, PuppetTokenTypes.SELECTOR_VALUE).lineBreakInCodeIf(true).between(PuppetTokenTypes.COMMA, PuppetTokenTypes.SELECTOR_VALUE).lineBreakInCodeIf(true).between(PuppetTokenTypes.SELECTOR_VALUE, PuppetTokenTypes.RBRACE).lineBreakInCodeIf(true).between(PuppetTokenTypes.LBRACE, PuppetTokenTypes.CASE_OPTION).lineBreakInCodeIf(true).between(PuppetTokenTypes.CASE_OPTION, PuppetTokenTypes.CASE_OPTION).lineBreakInCodeIf(true).between(PuppetTokenTypes.CASE_OPTION, PuppetTokenTypes.RBRACE).lineBreakInCodeIf(true).afterInside(PuppetTokenTypes.LPAREN, PuppetTokenTypes.PARENTHESIZED_EXPRESSIONS_LIST_BLOCK).none().beforeInside(PuppetTokenTypes.RPAREN, PuppetTokenTypes.PARENTHESIZED_EXPRESSIONS_LIST_BLOCK).none().between(PuppetTokenTypes.REGULAR_NAME_WRAPPER, PuppetTokenTypes.PARENTHESIZED_EXPRESSIONS_LIST_BLOCK).none().between(PuppetTokenTypes.LBRACE, PuppetTokenTypes.RBRACE).spaces(0).withinPair(PuppetTokenTypes.LBRACE, PuppetTokenTypes.RBRACE).spaceIf(true).after(PuppetTokenTypes.RBRACE).spaceIf(true).before(SPACE_BEFORE_TOKENSET).spaceIf(true).between(PuppetTokenTypes.CASE_OPTION, PuppetTokenTypes.CASE_OPTION).spaceIf(true).around(NO_SPACES_AROUND_TOKENSET).none().before(NO_SPACE_BEFORE_SPACE_AFTER_TOKENSET).none().after(NO_SPACE_BEFORE_SPACE_AFTER_TOKENSET).spaceIf(true).afterInside(POSSIBLE_UNARY_OPS, PuppetTokenTypes.EXPRESSION_UNARY).none().around(SPACES_AROUND_TOKENSET).spaces(1);
    }
}

