/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.DropTargetNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.projectView.ResourceBundleAwareNode;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleNode
extends ProjectViewNode<ResourceBundle>
implements ValidateableNode,
DropTargetNode,
ResourceBundleAwareNode {
    public ResourceBundleNode(@NotNull Project project, @NotNull ResourceBundle resourceBundle, ViewSettings settings) {
        if (project == null) {
            ResourceBundleNode.$$$reportNull$$$0(0);
        }
        if (resourceBundle == null) {
            ResourceBundleNode.$$$reportNull$$$0(1);
        }
        super(project, (Object)resourceBundle, settings);
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        List<PropertiesFile> propertiesFiles = this.getResourceBundle().getPropertiesFiles();
        ArrayList children = new ArrayList();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            PsiFileNode node = new PsiFileNode(this.myProject, propertiesFile.getContainingFile(), this.getSettings());
            children.add((AbstractTreeNode<?>)node);
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            ResourceBundleNode.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            ResourceBundleNode.$$$reportNull$$$0(3);
        }
        if (!file.isValid()) {
            return false;
        }
        assert (this.myProject != null);
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(psiFile);
        return propertiesFile != null && this.getResourceBundle().getPropertiesFiles().contains(propertiesFile);
    }

    public VirtualFile getVirtualFile() {
        ResourceBundle rb = this.getResourceBundle();
        if (!rb.isValid()) {
            return null;
        }
        List<PropertiesFile> list = rb.getPropertiesFiles();
        if (!list.isEmpty()) {
            return list.get(0).getVirtualFile();
        }
        return null;
    }

    public void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            ResourceBundleNode.$$$reportNull$$$0(4);
        }
        presentation.setIcon(AllIcons.Nodes.ResourceBundle);
        ResourceBundle rb = this.getResourceBundle();
        if (rb.isValid()) {
            presentation.setPresentableText(PropertiesBundle.message("project.view.resource.bundle.tree.node.text", rb.getBaseName()));
        }
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public boolean canNavigate() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        assert (this.myProject != null);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, (VirtualFile)new ResourceBundleAsVirtualFile(this.getResourceBundle()));
        FileEditorManager.getInstance((Project)this.myProject).openTextEditor(descriptor, requestFocus);
    }

    public boolean isSortByFirstChild() {
        return true;
    }

    public Comparable getTypeSortKey() {
        return new PsiFileNode.ExtensionSortKey(StdFileTypes.PROPERTIES.getDefaultExtension());
    }

    public boolean validate() {
        ResourceBundle currentBundle;
        if (!super.validate()) {
            return false;
        }
        ResourceBundle newBundle = this.getResourceBundle().getDefaultPropertiesFile().getResourceBundle();
        if (!Comparing.equal((Object)newBundle, (Object)(currentBundle = this.getResourceBundle()))) {
            return false;
        }
        return currentBundle.isValid();
    }

    public boolean isValid() {
        return this.getResourceBundle().isValid();
    }

    public boolean canDrop(TreeNode @NotNull [] sourceNodes) {
        if (sourceNodes == null) {
            ResourceBundleNode.$$$reportNull$$$0(5);
        }
        for (TreeNode node : sourceNodes) {
            if (ResourceBundleNode.extractPropertiesFileFromNode(node) != null) continue;
            return false;
        }
        return true;
    }

    public void drop(TreeNode @NotNull [] sourceNodes, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            ResourceBundleNode.$$$reportNull$$$0(6);
        }
        if (sourceNodes == null) {
            ResourceBundleNode.$$$reportNull$$$0(7);
        }
        MultiMap bundleGrouping = new MultiMap();
        for (TreeNode sourceNode : sourceNodes) {
            PropertiesFile propertiesFile = ResourceBundleNode.extractPropertiesFileFromNode(sourceNode);
            if (propertiesFile == null) {
                return;
            }
            bundleGrouping.putValue((Object)propertiesFile.getResourceBundle(), (Object)propertiesFile);
        }
        ResourceBundle resourceBundle = this.getResourceBundle();
        bundleGrouping.remove((Object)resourceBundle);
        ResourceBundleManager resourceBundleManager = ResourceBundleManager.getInstance(this.myProject);
        ArrayList<PropertiesFile> toAddInResourceBundle = new ArrayList<PropertiesFile>();
        for (Map.Entry entry : bundleGrouping.entrySet()) {
            toAddInResourceBundle.addAll((Collection)entry.getValue());
            ResourceBundle currentBundle = (ResourceBundle)entry.getKey();
            Collection propertiesFilesToMove = (Collection)entry.getValue();
            if (currentBundle.getPropertiesFiles().size() - propertiesFilesToMove.size() <= 0) continue;
            String currentBundleBaseName = currentBundle.getBaseName();
            ArrayList<PropertiesFile> files = new ArrayList<PropertiesFile>(currentBundle.getPropertiesFiles());
            files.removeAll(propertiesFilesToMove);
            resourceBundleManager.dissociateResourceBundle(currentBundle);
            resourceBundleManager.combineToResourceBundle(files, currentBundleBaseName);
        }
        toAddInResourceBundle.addAll(resourceBundle.getPropertiesFiles());
        String baseName = resourceBundle.getBaseName();
        assert (this.myProject != null);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        fileEditorManager.closeFile((VirtualFile)new ResourceBundleAsVirtualFile(resourceBundle));
        resourceBundleManager.dissociateResourceBundle(resourceBundle);
        ResourceBundle updatedBundle = resourceBundleManager.combineToResourceBundleAndGet(toAddInResourceBundle, baseName);
        FileEditorManager.getInstance((Project)this.myProject).openFile((VirtualFile)new ResourceBundleAsVirtualFile(updatedBundle), true);
        ProjectView.getInstance((Project)this.myProject).refresh();
    }

    public void dropExternalFiles(PsiFileSystemItem[] sourceFileArray, DataContext dataContext) {
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        ResourceBundle rb = this.getResourceBundle();
        List list = rb.isValid() ? ContainerUtil.map(rb.getPropertiesFiles(), PropertiesFile::getVirtualFile) : Collections.emptyList();
        if (list == null) {
            ResourceBundleNode.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    public ResourceBundle getResourceBundle() {
        ResourceBundle resourceBundle = (ResourceBundle)Objects.requireNonNull(this.getValue());
        if (resourceBundle == null) {
            ResourceBundleNode.$$$reportNull$$$0(9);
        }
        return resourceBundle;
    }

    @Nullable
    private static PropertiesFile extractPropertiesFileFromNode(TreeNode node) {
        if (!(node instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
        if (!(userObject instanceof PsiFileNode)) {
            return null;
        }
        PsiFile file = (PsiFile)((PsiFileNode)userObject).getValue();
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(file);
        if (propertiesFile == null || !file.getManager().isInProject((PsiElement)file) || !file.isValid()) {
            return null;
        }
        return propertiesFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceBundle";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/projectView/ResourceBundleNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNodes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/projectView/ResourceBundleNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canDrop";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

