/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import a.g.lb;
import com.intellij.coverage.BaseCoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleCoverageAnnotator
extends BaseCoverageAnnotator {
    private final Map<String, BaseCoverageAnnotator.FileCoverageInfo> c = new HashMap<String, BaseCoverageAnnotator.FileCoverageInfo>();
    private final Map<String, BaseCoverageAnnotator.DirCoverageInfo> b = new HashMap<String, BaseCoverageAnnotator.DirCoverageInfo>();
    private final Map<String, BaseCoverageAnnotator.DirCoverageInfo> d = new HashMap<String, BaseCoverageAnnotator.DirCoverageInfo>();
    private static final long f = lb.a(6078454535379617237L, -3604813037000310805L, MethodHandles.lookup().lookupClass()).a(100705166077175L);

    public SimpleCoverageAnnotator(Project project) {
        super(project);
    }

    @Override
    public void onSuiteChosen(CoverageSuitesBundle newSuite) {
        super.onSuiteChosen(newSuite);
        this.c.clear();
        this.b.clear();
        this.d.clear();
    }

    @Nullable
    protected BaseCoverageAnnotator.DirCoverageInfo getDirCoverageInfo(@NotNull PsiDirectory directory, @NotNull CoverageSuitesBundle currentSuite) {
        if (directory == null) {
            SimpleCoverageAnnotator.b(0);
        }
        if (currentSuite == null) {
            SimpleCoverageAnnotator.b(1);
        }
        VirtualFile virtualFile = directory.getVirtualFile();
        boolean bl2 = TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)directory.getProject());
        if (!currentSuite.isTrackTestFolders() && bl2) {
            return null;
        }
        String string = SimpleCoverageAnnotator.normalizeFilePath(virtualFile.getPath());
        return bl2 ? this.b.get(string) : this.d.get(string);
    }

    @Override
    @Nullable
    public String getDirCoverageInformationString(@NotNull PsiDirectory directory, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        BaseCoverageAnnotator.DirCoverageInfo dirCoverageInfo;
        long l2 = f ^ 0x664FE1861567L;
        if (directory == null) {
            SimpleCoverageAnnotator.b(2);
        }
        if (currentSuite == null) {
            SimpleCoverageAnnotator.b(3);
        }
        if (manager == null) {
            SimpleCoverageAnnotator.b(4);
        }
        if ((dirCoverageInfo = this.getDirCoverageInfo(directory, currentSuite)) == null) {
            return null;
        }
        if (manager.isSubCoverageActive()) {
            return dirCoverageInfo.coveredLineCount > 0 ? CoverageBundle.message("coverage.view.text.covered", new Object[0]) : null;
        }
        String string = this.getFilesCoverageInformationString(dirCoverageInfo);
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            String string2 = this.getLinesCoverageInformationString(dirCoverageInfo);
            if (string2 != null) {
                stringBuilder.append(", ").append(string2);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    @Deprecated
    public static String getFilePath(String filePath) {
        return SimpleCoverageAnnotator.normalizeFilePath(filePath);
    }

    @NotNull
    protected static String normalizeFilePath(@NotNull String filePath) {
        if (filePath == null) {
            SimpleCoverageAnnotator.b(5);
        }
        if (SystemInfo.isWindows) {
            filePath = StringUtil.toLowerCase((String)filePath);
        }
        String string = FileUtil.toSystemIndependentName((String)filePath);
        if (string == null) {
            SimpleCoverageAnnotator.b(6);
        }
        return string;
    }

    @Override
    @Nullable
    public String getFileCoverageInformationString(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        VirtualFile virtualFile;
        long l2 = f ^ 0x4665023E83CEL;
        if (psiFile == null) {
            SimpleCoverageAnnotator.b(7);
        }
        if (currentSuite == null) {
            SimpleCoverageAnnotator.b(8);
        }
        if (manager == null) {
            SimpleCoverageAnnotator.b(9);
        }
        if ((virtualFile = psiFile.getVirtualFile().getCanonicalFile()) == null) {
            virtualFile = psiFile.getVirtualFile();
        }
        assert (virtualFile != null);
        String string = SimpleCoverageAnnotator.normalizeFilePath(virtualFile.getPath());
        BaseCoverageAnnotator.FileCoverageInfo fileCoverageInfo = this.c.get(string);
        if (fileCoverageInfo == null) {
            return null;
        }
        if (manager.isSubCoverageActive()) {
            return fileCoverageInfo.coveredLineCount > 0 ? CoverageBundle.message("coverage.view.text.covered", new Object[0]) : null;
        }
        return this.getLinesCoverageInformationString(fileCoverageInfo);
    }

    @Nullable
    protected BaseCoverageAnnotator.FileCoverageInfo collectBaseFileCoverage(@NotNull VirtualFile file, @NotNull Annotator annotator, @NotNull ProjectData projectData, @NotNull Map<String, String> normalizedFiles2Files) {
        if (file == null) {
            SimpleCoverageAnnotator.b(10);
        }
        if (annotator == null) {
            SimpleCoverageAnnotator.b(11);
        }
        if (projectData == null) {
            SimpleCoverageAnnotator.b(12);
        }
        if (normalizedFiles2Files == null) {
            SimpleCoverageAnnotator.b(13);
        }
        VirtualFile virtualFile = file = file.getCanonicalFile() != null ? file.getCanonicalFile() : file;
        assert (file != null);
        String string = SimpleCoverageAnnotator.normalizeFilePath(file.getPath());
        ClassData classData = SimpleCoverageAnnotator.getClassData(string, projectData, normalizedFiles2Files);
        BaseCoverageAnnotator.FileCoverageInfo fileCoverageInfo = classData != null ? this.fileInfoForCoveredFile(classData) : this.fillInfoForUncoveredFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        if (fileCoverageInfo != null) {
            annotator.annotateFile(string, fileCoverageInfo);
        }
        return fileCoverageInfo;
    }

    @Nullable
    protected static ClassData getClassData(@NotNull String filePath, @NotNull ProjectData data, @NotNull Map<String, String> normalizedFiles2Files) {
        String string;
        if (filePath == null) {
            SimpleCoverageAnnotator.b(14);
        }
        if (data == null) {
            SimpleCoverageAnnotator.b(15);
        }
        if (normalizedFiles2Files == null) {
            SimpleCoverageAnnotator.b(16);
        }
        if ((string = normalizedFiles2Files.get(filePath)) == null) {
            return null;
        }
        return data.getClassData(string);
    }

    @Nullable
    protected BaseCoverageAnnotator.DirCoverageInfo collectFolderCoverage(@NotNull VirtualFile dir, @NotNull CoverageDataManager dataManager, Annotator annotator, ProjectData projectInfo, boolean trackTestFolders, @NotNull ProjectFileIndex index, @NotNull CoverageEngine coverageEngine, Set<? super VirtualFile> visitedDirs, @NotNull Map<String, String> normalizedFiles2Files) {
        if (dir == null) {
            SimpleCoverageAnnotator.b(17);
        }
        if (dataManager == null) {
            SimpleCoverageAnnotator.b(18);
        }
        if (index == null) {
            SimpleCoverageAnnotator.b(19);
        }
        if (coverageEngine == null) {
            SimpleCoverageAnnotator.b(20);
        }
        if (normalizedFiles2Files == null) {
            SimpleCoverageAnnotator.b(21);
        }
        if (!index.isInContent(dir) && !index.isInLibrary(dir)) {
            return null;
        }
        if (visitedDirs.contains(dir)) {
            return null;
        }
        if (!this.shouldCollectCoverageInsideLibraryDirs() && index.isInLibrary(dir)) {
            return null;
        }
        visitedDirs.add((VirtualFile)dir);
        boolean bl2 = TestSourcesFilter.isTestSources((VirtualFile)dir, (Project)this.getProject());
        if (!trackTestFolders && bl2) {
            return null;
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])dataManager.doInReadActionIfProjectOpen(() -> ((VirtualFile)dir).getChildren());
        if (virtualFileArray == null) {
            return null;
        }
        BaseCoverageAnnotator.DirCoverageInfo dirCoverageInfo = new BaseCoverageAnnotator.DirCoverageInfo();
        for (VirtualFile virtualFile : virtualFileArray) {
            BaseCoverageAnnotator.FileCoverageInfo fileCoverageInfo;
            if (virtualFile.isDirectory()) {
                fileCoverageInfo = this.collectFolderCoverage(virtualFile, dataManager, annotator, projectInfo, trackTestFolders, index, coverageEngine, visitedDirs, normalizedFiles2Files);
                if (fileCoverageInfo == null) continue;
                dirCoverageInfo.totalFilesCount += ((BaseCoverageAnnotator.DirCoverageInfo)fileCoverageInfo).totalFilesCount;
                dirCoverageInfo.coveredFilesCount += ((BaseCoverageAnnotator.DirCoverageInfo)fileCoverageInfo).coveredFilesCount;
                dirCoverageInfo.totalLineCount += ((BaseCoverageAnnotator.DirCoverageInfo)fileCoverageInfo).totalLineCount;
                dirCoverageInfo.coveredLineCount += ((BaseCoverageAnnotator.DirCoverageInfo)fileCoverageInfo).coveredLineCount;
                continue;
            }
            if (!coverageEngine.coverageProjectViewStatisticsApplicableTo(virtualFile) || (fileCoverageInfo = this.collectBaseFileCoverage(virtualFile, annotator, projectInfo, normalizedFiles2Files)) == null) continue;
            dirCoverageInfo.totalLineCount += fileCoverageInfo.totalLineCount;
            ++dirCoverageInfo.totalFilesCount;
            if (fileCoverageInfo.coveredLineCount <= 0) continue;
            ++dirCoverageInfo.coveredFilesCount;
            dirCoverageInfo.coveredLineCount += fileCoverageInfo.coveredLineCount;
        }
        if (dirCoverageInfo.totalFilesCount == 0) {
            return null;
        }
        String string = SimpleCoverageAnnotator.normalizeFilePath(dir.getPath());
        if (bl2) {
            annotator.annotateTestDirectory(string, dirCoverageInfo);
        } else {
            annotator.annotateSourceDirectory(string, dirCoverageInfo);
        }
        return dirCoverageInfo;
    }

    protected boolean shouldCollectCoverageInsideLibraryDirs() {
        return true;
    }

    public void annotate(@NotNull VirtualFile contentRoot, @NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager, @NotNull ProjectData data, Project project, Annotator annotator) {
        if (contentRoot == null) {
            SimpleCoverageAnnotator.b(22);
        }
        if (suite == null) {
            SimpleCoverageAnnotator.b(23);
        }
        if (dataManager == null) {
            SimpleCoverageAnnotator.b(24);
        }
        if (data == null) {
            SimpleCoverageAnnotator.b(25);
        }
        if (!contentRoot.isValid()) {
            return;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Set set = data.getClasses().keySet();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : set) {
            hashMap.put(SimpleCoverageAnnotator.normalizeFilePath(string), string);
        }
        this.collectFolderCoverage(contentRoot, dataManager, annotator, data, suite.isTrackTestFolders(), projectFileIndex, suite.getCoverageEngine(), new HashSet(), Collections.unmodifiableMap(hashMap));
    }

    @Override
    @Nullable
    protected Runnable createRenewRequest(@NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager) {
        ProjectData projectData;
        if (suite == null) {
            SimpleCoverageAnnotator.b(26);
        }
        if (dataManager == null) {
            SimpleCoverageAnnotator.b(27);
        }
        if ((projectData = suite.getCoverageData()) == null) {
            return null;
        }
        return () -> {
            Project project = this.getProject();
            VirtualFile[] virtualFileArray = this.getRoots(project, dataManager, suite);
            if (virtualFileArray == null) {
                return;
            }
            for (VirtualFile virtualFile : virtualFileArray) {
                this.annotate(virtualFile, suite, dataManager, projectData, project, new Annotator(){
                    private static final long a = lb.a(3839751533843337471L, 7332140848168368105L, MethodHandles.lookup().lookupClass()).a(81495982066967L);

                    @Override
                    public void annotateSourceDirectory(String dirPath, BaseCoverageAnnotator.DirCoverageInfo info) {
                        SimpleCoverageAnnotator.this.d.put(dirPath, info);
                        try {
                            SimpleCoverageAnnotator.this.d.put(new File(dirPath).getCanonicalPath(), info);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void annotateTestDirectory(String dirPath, BaseCoverageAnnotator.DirCoverageInfo info) {
                        SimpleCoverageAnnotator.this.b.put(dirPath, info);
                        try {
                            SimpleCoverageAnnotator.this.b.put(new File(dirPath).getCanonicalPath(), info);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void annotateFile(@NotNull String filePath, @NotNull BaseCoverageAnnotator.FileCoverageInfo info) {
                        if (filePath == null) {
                            1.a(0);
                        }
                        if (info == null) {
                            1.a(1);
                        }
                        SimpleCoverageAnnotator.this.c.put(filePath, info);
                        try {
                            SimpleCoverageAnnotator.this.c.put(new File(filePath).getCanonicalPath(), info);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        long l2 = a ^ 0x162EC56BB6BFL;
                        Object[] objectArray2 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "filePath";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "info";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/coverage/SimpleCoverageAnnotator$1";
                        objectArray[2] = "annotateFile";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            dataManager.triggerPresentationUpdate();
        };
    }

    protected VirtualFile[] getRoots(Project project, @NotNull CoverageDataManager dataManager, CoverageSuitesBundle suite) {
        if (dataManager == null) {
            SimpleCoverageAnnotator.b(28);
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        return (VirtualFile[])dataManager.doInReadActionIfProjectOpen(() -> projectRootManager.getContentRoots());
    }

    @Nullable
    protected String getLinesCoverageInformationString(@NotNull BaseCoverageAnnotator.FileCoverageInfo info) {
        long l2 = f ^ 0x193899BFC336L;
        if (info == null) {
            SimpleCoverageAnnotator.b(29);
        }
        return CoverageBundle.message("coverage.view.text.lines.covered", SimpleCoverageAnnotator.calcCoveragePercentage(info));
    }

    protected static int calcCoveragePercentage(BaseCoverageAnnotator.FileCoverageInfo info) {
        return SimpleCoverageAnnotator.a(info.coveredLineCount, info.totalLineCount);
    }

    private static int a(int n2, int n3) {
        return n3 != 0 ? (int)((double)n2 / (double)n3 * 100.0) : 100;
    }

    @Nullable
    @Nls
    protected String getFilesCoverageInformationString(@NotNull BaseCoverageAnnotator.DirCoverageInfo info) {
        long l2 = f ^ 0x69AF5F4E638CL;
        if (info == null) {
            SimpleCoverageAnnotator.b(30);
        }
        return CoverageBundle.message("coverage.view.text.files.covered", SimpleCoverageAnnotator.a(info.coveredFilesCount, info.totalFilesCount));
    }

    @Nullable
    protected BaseCoverageAnnotator.FileCoverageInfo fileInfoForCoveredFile(@NotNull ClassData classData) {
        Object[] objectArray;
        int n2;
        if (classData == null) {
            SimpleCoverageAnnotator.b(31);
        }
        if ((n2 = (objectArray = classData.getLines()).length - 1) == 0) {
            return null;
        }
        BaseCoverageAnnotator.FileCoverageInfo fileCoverageInfo = new BaseCoverageAnnotator.FileCoverageInfo();
        fileCoverageInfo.coveredLineCount = 0;
        fileCoverageInfo.totalLineCount = 0;
        for (int i10 = 1; i10 <= n2; ++i10) {
            LineData lineData = classData.getLineData(i10);
            this.processLineData(fileCoverageInfo, lineData);
        }
        return fileCoverageInfo;
    }

    protected void processLineData(@NotNull BaseCoverageAnnotator.FileCoverageInfo info, @Nullable LineData lineData) {
        if (info == null) {
            SimpleCoverageAnnotator.b(32);
        }
        if (lineData == null) {
            return;
        }
        int n2 = lineData.getStatus();
        if (n2 != 0) {
            ++info.coveredLineCount;
        }
        ++info.totalLineCount;
    }

    @Nullable
    protected BaseCoverageAnnotator.FileCoverageInfo fillInfoForUncoveredFile(@NotNull File file) {
        if (file == null) {
            SimpleCoverageAnnotator.b(33);
        }
        return null;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x48B9804FD769L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSuite";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/SimpleCoverageAnnotator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 10: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 13: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedFiles2Files";
                break;
            }
            case 15: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 18: 
            case 24: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataManager";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageEngine";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 29: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classData";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/SimpleCoverageAnnotator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeFilePath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDirCoverageInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDirCoverageInformationString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "normalizeFilePath";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileCoverageInformationString";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectBaseFileCoverage";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getClassData";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectFolderCoverage";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createRenewRequest";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getLinesCoverageInformationString";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getFilesCoverageInformationString";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "fileInfoForCoveredFile";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processLineData";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "fillInfoForUncoveredFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface Annotator {
        public void annotateSourceDirectory(String var1, BaseCoverageAnnotator.DirCoverageInfo var2);

        public void annotateTestDirectory(String var1, BaseCoverageAnnotator.DirCoverageInfo var2);

        public void annotateFile(@NotNull String var1, @NotNull BaseCoverageAnnotator.FileCoverageInfo var2);
    }
}

