/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import org.jetbrains.annotations.NonNls;

public class PredefinedConfigurationUtil {
    public static Configuration createSearchTemplateInfo(String name, @NonNls String criteria, String category) {
        return PredefinedConfigurationUtil.createSearchTemplateInfo(name, criteria, category, StdFileTypes.JAVA);
    }

    public static Configuration createSearchTemplateInfo(String name, @NonNls String criteria, String category, LanguageFileType fileType) {
        return PredefinedConfigurationUtil.createSearchTemplateInfo(name, criteria, category, fileType, null);
    }

    public static Configuration createSearchTemplateInfo(String name, @NonNls String criteria, String category, LanguageFileType fileType, PatternContext context) {
        SearchConfiguration searchConfiguration = new SearchConfiguration(name, category);
        searchConfiguration.setPredefined(true);
        MatchOptions matchOptions = searchConfiguration.getMatchOptions();
        matchOptions.fillSearchCriteria(criteria);
        matchOptions.setFileType(fileType);
        matchOptions.setCaseSensitiveMatch(true);
        matchOptions.setPatternContext(context);
        return searchConfiguration;
    }

    public static Configuration createSearchTemplateInfoSimple(String name, @NonNls String criteria, String category) {
        Configuration configuration = PredefinedConfigurationUtil.createSearchTemplateInfo(name, criteria, category);
        configuration.getMatchOptions().setRecursiveSearch(false);
        return configuration;
    }
}

