/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import a.g.lb;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.HyphenNameStrategy;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaNameStrategy;
import com.intellij.util.xml.NameStrategy;
import com.intellij.util.xml.NameStrategyForAttributes;
import com.intellij.util.xml.Namespace;
import com.intellij.util.xml.Resolve;
import com.intellij.util.xml.SubTag;
import com.intellij.util.xml.SubTagList;
import com.intellij.util.xml.TagValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import gnu.trove.THashSet;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DomImplUtil {
    private static final Logger a;
    private static final long b;

    private DomImplUtil() {
    }

    public static void assertValidity(DomElement element, String msg) {
        if (element instanceof DomFileElementImpl) {
            String string = ((DomFileElementImpl)element).checkValidity();
            if (string != null) {
                throw new AssertionError((Object)string);
            }
            return;
        }
        DomInvocationHandler domInvocationHandler = DomManagerImpl.getDomInvocationHandler(element);
        assert (domInvocationHandler != null);
        try {
            domInvocationHandler.assertValid();
        }
        catch (AssertionError assertionError) {
            throw new AssertionError((Object)(msg + ((Throwable)((Object)assertionError)).getMessage()));
        }
    }

    public static boolean isTagValueGetter(JavaMethod method) {
        long l2 = b ^ 0x665A9E74D4CFL;
        if (!DomImplUtil.isGetter(method)) {
            return false;
        }
        if (DomImplUtil.a(method)) {
            return true;
        }
        if ("getValue".equals(method.getName())) {
            if (method.getAnnotation(SubTag.class) != null) {
                return false;
            }
            if (method.getAnnotation(SubTagList.class) != null) {
                return false;
            }
            if (method.getAnnotation(Convert.class) != null || method.getAnnotation(Resolve.class) != null) {
                return !ReflectionUtil.isAssignable(GenericDomValue.class, (Class)method.getReturnType());
            }
            return !ReflectionUtil.isAssignable(DomElement.class, (Class)method.getReturnType());
        }
        return false;
    }

    private static boolean a(JavaMethod javaMethod) {
        return javaMethod.getAnnotation(TagValue.class) != null;
    }

    public static boolean isGetter(JavaMethod method) {
        boolean bl2;
        long l2 = b ^ 0x63E7C8849646L;
        String string = method.getName();
        boolean bl3 = string.startsWith("get");
        boolean bl4 = bl2 = !bl3 && string.startsWith("is");
        if (!bl3 && !bl2) {
            return false;
        }
        if (method.getGenericParameterTypes().length != 0) {
            return false;
        }
        Type type = method.getGenericReturnType();
        if (bl3) {
            return type != Void.TYPE;
        }
        return DomReflectionUtil.canHaveIsPropertyGetterPrefix((Type)type);
    }

    public static boolean isTagValueSetter(JavaMethod method) {
        long l2 = b ^ 0x1FEA6A60D9F7L;
        boolean bl2 = method.getName().startsWith("set") && method.getGenericParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
        return bl2 && (DomImplUtil.a(method) || "setValue".equals(method.getName()));
    }

    @Nullable
    public static DomNameStrategy getDomNameStrategy(Class<?> rawType, boolean isAttribute) {
        NameStrategyForAttributes nameStrategyForAttributes;
        Class clazz = null;
        if (isAttribute && (nameStrategyForAttributes = (NameStrategyForAttributes)DomReflectionUtil.findAnnotationDFS(rawType, NameStrategyForAttributes.class)) != null) {
            clazz = nameStrategyForAttributes.value();
        }
        if (clazz == null && (nameStrategyForAttributes = (NameStrategy)DomReflectionUtil.findAnnotationDFS(rawType, NameStrategy.class)) != null) {
            clazz = nameStrategyForAttributes.value();
        }
        if (clazz != null) {
            if (HyphenNameStrategy.class.equals(clazz)) {
                return DomNameStrategy.HYPHEN_STRATEGY;
            }
            if (JavaNameStrategy.class.equals((Object)clazz)) {
                return DomNameStrategy.JAVA_STRATEGY;
            }
            try {
                return (DomNameStrategy)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                a.error((Throwable)reflectiveOperationException);
            }
        }
        return null;
    }

    public static List<XmlTag> findSubTags(@NotNull XmlTag tag, EvaluatedXmlName name, XmlFile file) {
        if (tag == null) {
            DomImplUtil.a(0);
        }
        return DomImplUtil.findSubTags(tag, name, file, true);
    }

    static List<XmlTag> findSubTags(@NotNull XmlTag tag, EvaluatedXmlName name, XmlFile file, boolean processIncludes) {
        Object[] objectArray;
        long l2 = b ^ 0x3761B69C7D34L;
        if (tag == null) {
            DomImplUtil.a(1);
        }
        if (!tag.isValid()) {
            throw new AssertionError((Object)"Invalid tag");
        }
        Object[] objectArray2 = objectArray = tag instanceof XmlTagImpl ? ((XmlTagImpl)tag).getSubTags(processIncludes) : tag.getSubTags();
        if (objectArray.length == 0) {
            return Collections.emptyList();
        }
        return ContainerUtil.findAll((Object[])objectArray, xmlTag2 -> {
            long l2 = b ^ 0x5C6ACBFB9466L;
            ProgressManager.checkCanceled();
            try {
                return DomImplUtil.a(name, xmlTag2, file);
            }
            catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
                if (!xmlTag2.isValid()) {
                    a.error("tag.getSubTags() returned invalid, tag=" + tag + ", containing file: " + tag.getContainingFile() + "subTag.parent=" + xmlTag2.getNode().getTreeParent());
                    return false;
                }
                throw psiInvalidElementAccessException;
            }
        });
    }

    public static List<XmlTag> findSubTags(XmlTag[] tags, EvaluatedXmlName name, XmlFile file) {
        if (tags.length == 0) {
            return Collections.emptyList();
        }
        return ContainerUtil.findAll((Object[])tags, xmlTag -> DomImplUtil.a(name, xmlTag, file));
    }

    public static boolean isNameSuitable(XmlName name, XmlTag tag, @NotNull DomInvocationHandler handler, XmlFile file) {
        if (handler == null) {
            DomImplUtil.a(2);
        }
        return DomImplUtil.a(handler.createEvaluatedXmlName(name), tag, file);
    }

    private static boolean a(EvaluatedXmlName evaluatedXmlName, XmlTag xmlTag, XmlFile xmlFile) {
        String string = evaluatedXmlName.getXmlName().getLocalName();
        boolean bl2 = string.equals(xmlTag.getName());
        return (bl2 || string.equals(xmlTag.getLocalName())) && evaluatedXmlName.isNamespaceAllowed(xmlTag.getNamespace(), xmlFile, !bl2);
    }

    @Nullable
    public static XmlName createXmlName(@NotNull String name, Type type, @Nullable JavaMethod javaMethod) {
        Class<?> clazz;
        if (name == null) {
            DomImplUtil.a(3);
        }
        if ((clazz = DomImplUtil.a(type)) == null) {
            return null;
        }
        String string = DomImplUtil.a(clazz);
        if (string == null && javaMethod != null) {
            for (Method method : javaMethod.getHierarchy()) {
                String string2 = DomImplUtil.a(method.getDeclaringClass());
                if (string2 == null) continue;
                return new XmlName(name, string2);
            }
        }
        return new XmlName(name, string);
    }

    @Nullable
    private static Class<?> a(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return DomImplUtil.a(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            for (Type type2 : ((TypeVariable)type).getBounds()) {
                Class<?> type3 = DomImplUtil.a(type2);
                if (type3 == null) continue;
                return type3;
            }
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type type2 : wildcardType.getUpperBounds()) {
                Class<?> clazz = DomImplUtil.a(type2);
                if (clazz == null) continue;
                return clazz;
            }
        }
        return null;
    }

    @Nullable
    private static String a(@NotNull Class<?> clazz) {
        Namespace namespace;
        if (clazz == null) {
            DomImplUtil.a(4);
        }
        return (namespace = (Namespace)DomReflectionUtil.findAnnotationDFS(clazz, Namespace.class)) != null ? namespace.value() : null;
    }

    @Nullable
    public static XmlName createXmlName(@NotNull String name, JavaMethod method) {
        if (name == null) {
            DomImplUtil.a(5);
        }
        return DomImplUtil.createXmlName(name, method.getGenericReturnType(), method);
    }

    public static List<XmlTag> getCustomSubTags(DomInvocationHandler handler, XmlTag[] subTags, XmlFile file) {
        if (subTags.length == 0) {
            return Collections.emptyList();
        }
        DomGenericInfoEx domGenericInfoEx = handler.getGenericInfo();
        THashSet tHashSet = new THashSet();
        List list2 = domGenericInfoEx.getCollectionChildrenDescriptions();
        int n2 = list2.size();
        for (int i10 = 0; i10 < n2; ++i10) {
            DomCollectionChildDescription domCollectionChildDescription = (DomCollectionChildDescription)list2.get(i10);
            tHashSet.add(domCollectionChildDescription.getXmlName());
        }
        List list3 = domGenericInfoEx.getFixedChildrenDescriptions();
        int n3 = list3.size();
        for (n2 = 0; n2 < n3; ++n2) {
            DomFixedChildDescription domFixedChildDescription = (DomFixedChildDescription)list3.get(n2);
            tHashSet.add(domFixedChildDescription.getXmlName());
        }
        return ContainerUtil.findAll((Object[])subTags, arg_0 -> DomImplUtil.a((Set)tHashSet, handler, file, arg_0));
    }

    static XmlFile getFile(DomElement domElement) {
        long l2 = b ^ 0x4867B4D1AF14L;
        if (domElement instanceof DomFileElement) {
            return ((DomFileElement)domElement).getFile();
        }
        DomInvocationHandler domInvocationHandler = DomManagerImpl.getDomInvocationHandler(domElement);
        assert (domInvocationHandler != null) : domElement;
        while (!(domInvocationHandler instanceof DomRootInvocationHandler)) {
            XmlTag xmlTag = domInvocationHandler.getXmlTag();
            if (xmlTag != null) {
                return DomImplUtil.a(xmlTag);
            }
            DomInvocationHandler domInvocationHandler2 = domInvocationHandler.getParentHandler();
            if (domInvocationHandler2 == null) {
                throw new AssertionError((Object)("No parent for " + domInvocationHandler.toStringEx()));
            }
            domInvocationHandler = domInvocationHandler2;
        }
        return ((DomRootInvocationHandler)domInvocationHandler).getParent().getFile();
    }

    private static XmlFile a(XmlTag xmlTag) {
        PsiElement psiElement;
        while ((psiElement = PhysicalDomParentStrategy.getParentTagCandidate((XmlElement)xmlTag)) instanceof XmlTag) {
            xmlTag = (XmlTag)psiElement;
        }
        return (XmlFile)xmlTag.getContainingFile();
    }

    private static /* synthetic */ boolean a(Set set, DomInvocationHandler domInvocationHandler, XmlFile xmlFile, XmlTag xmlTag) {
        if (StringUtil.isEmpty((String)xmlTag.getLocalName())) {
            return false;
        }
        for (XmlName xmlName : set) {
            if (!DomImplUtil.isNameSuitable(xmlName, xmlTag, domInvocationHandler, xmlFile)) continue;
            return false;
        }
        return true;
    }

    static {
        b = lb.a(27567565011759296L, 736915227996765585L, MethodHandles.lookup().lookupClass()).a(159208079715924L);
        a = Logger.getInstance(DomImplUtil.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x333A38E65F6BL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/xml/impl/DomImplUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findSubTags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isNameSuitable";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createXmlName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamespaceKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

