/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.breakpoints.JavaScriptExceptionBreakpointProperties;
import com.intellij.javascript.debugger.breakpoints.JavaScriptExceptionBreakpointType;
import com.intellij.util.Function;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import gnu.trove.THashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.debugger.ExceptionData;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0011\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001c\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J \u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001e\u0010\u0018\u001a\u00020\u00172\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0019\u001a\u00020\u0014H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/javascript/debugger/ChromeExceptionBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lcom/intellij/javascript/debugger/breakpoints/JavaScriptExceptionBreakpointProperties;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "activeBreakpoints", "Lgnu/trove/THashSet;", "exceptionCatchMode", "Lorg/jetbrains/debugger/ExceptionCatchMode;", "findActiveBreakpoint", "exceptionName", "", "findBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "exceptionData", "Lorg/jetbrains/debugger/ExceptionData;", "getResult", "isSuitable", "", "breakpoint", "registerBreakpoint", "", "unregisterBreakpoint", "temporary", "intellij.javascript.debugger"})
public final class ChromeExceptionBreakpointHandler
extends XBreakpointHandler<XBreakpoint<JavaScriptExceptionBreakpointProperties>> {
    private final THashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> activeBreakpoints;
    private volatile ExceptionCatchMode exceptionCatchMode;
    private final JavaScriptDebugProcess<?> debugProcess;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBreakpoint(@NotNull XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint) {
        ExceptionCatchMode exceptionCatchMode;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        THashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> tHashSet = this.activeBreakpoints;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (tHashSet) {
            boolean bl3 = false;
            this.activeBreakpoints.add(breakpoint);
            XBreakpointProperties xBreakpointProperties = breakpoint.getProperties();
            Intrinsics.checkExpressionValueIsNotNull((Object)xBreakpointProperties, (String)"breakpoint.properties");
            exceptionCatchMode = ((JavaScriptExceptionBreakpointProperties)xBreakpointProperties).getUncaughtOnly() ? ExceptionCatchMode.UNCAUGHT : ExceptionCatchMode.ALL;
        }
        ExceptionCatchMode newMode = exceptionCatchMode;
        if (newMode == this.exceptionCatchMode || this.exceptionCatchMode == ExceptionCatchMode.ALL) {
            return;
        }
        this.exceptionCatchMode = newMode;
        Vm vm = this.debugProcess.getActiveOrMainVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        Promise promise2 = vm.setBreakOnException(newMode);
        XDebugSession xDebugSession = this.debugProcess.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
        promise2.onError((Consumer)new RejectErrorReporter(xDebugSession, "Cannot set exception catch mode : "));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBreakpoint(@NotNull XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint, boolean temporary) {
        ExceptionCatchMode exceptionCatchMode;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        THashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> tHashSet = this.activeBreakpoints;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (tHashSet) {
            boolean bl3 = false;
            ExceptionCatchMode newMode = null;
            this.activeBreakpoints.remove(breakpoint);
            if (this.activeBreakpoints.isEmpty()) {
                newMode = ExceptionCatchMode.NONE;
            } else {
                newMode = ExceptionCatchMode.UNCAUGHT;
                Iterator iterator = this.activeBreakpoints.iterator();
                while (iterator.hasNext()) {
                    XBreakpoint activeBreakpoint;
                    XBreakpoint xBreakpoint = activeBreakpoint = (XBreakpoint)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)xBreakpoint, (String)"activeBreakpoint");
                    XBreakpointProperties xBreakpointProperties = xBreakpoint.getProperties();
                    Intrinsics.checkExpressionValueIsNotNull((Object)xBreakpointProperties, (String)"activeBreakpoint.properties");
                    if (((JavaScriptExceptionBreakpointProperties)xBreakpointProperties).getUncaughtOnly()) continue;
                    newMode = ExceptionCatchMode.ALL;
                    break;
                }
            }
            exceptionCatchMode = newMode;
        }
        ExceptionCatchMode newMode = exceptionCatchMode;
        if (newMode != this.exceptionCatchMode) {
            this.exceptionCatchMode = newMode;
            Vm vm = this.debugProcess.getActiveOrMainVm();
            if (vm == null) {
                Intrinsics.throwNpe();
            }
            vm.setBreakOnException(newMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final Promise<XBreakpoint<?>> findBreakpoint(@Nullable ExceptionData exceptionData) {
        if (exceptionData == null) {
            return Promises.rejectedPromise((String)"Internal error");
        }
        Value exceptionValue = exceptionData.getExceptionValue();
        if (!(exceptionValue instanceof ObjectValue)) {
            return Promises.resolvedPromise(this.getResult(exceptionData, null));
        }
        ObjectValue object = (ObjectValue)exceptionValue;
        String className = object.getClassName();
        if (className != null) {
            THashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> tHashSet = this.activeBreakpoints;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (tHashSet) {
                boolean bl3 = false;
                Iterator iterator = this.activeBreakpoints.iterator();
                while (iterator.hasNext()) {
                    XBreakpoint breakpoint;
                    XBreakpoint xBreakpoint = breakpoint = (XBreakpoint)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)xBreakpoint, (String)"breakpoint");
                    XBreakpointProperties xBreakpointProperties = xBreakpoint.getProperties();
                    Intrinsics.checkExpressionValueIsNotNull((Object)xBreakpointProperties, (String)"breakpoint.properties");
                    if (!Intrinsics.areEqual((Object)className, (Object)((JavaScriptExceptionBreakpointProperties)xBreakpointProperties).getExceptionName()) || !this.isSuitable(exceptionData, (XBreakpoint<JavaScriptExceptionBreakpointProperties>)breakpoint)) continue;
                    return Promises.resolvedPromise((Object)breakpoint);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        Promise promise2 = object.getProperties().then(new Function<T, SUB_RESULT>(this, exceptionData){
            final /* synthetic */ ChromeExceptionBreakpointHandler this$0;
            final /* synthetic */ ExceptionData $exceptionData;

            @Nullable
            public final XBreakpoint<?> fun(List<? extends Variable> it) {
                Value value;
                Variable variable;
                Variable name = null;
                Variable type = null;
                for (Variable variable2 : it) {
                    if (Intrinsics.areEqual((Object)"name", (Object)variable2.getName())) {
                        name = variable2;
                    } else if (Intrinsics.areEqual((Object)"type", (Object)variable2.getName())) {
                        type = variable2;
                    }
                    if (name == null) continue;
                    break;
                }
                if ((variable = name) == null) {
                    variable = type;
                }
                Variable variable3 = variable;
                String exceptionName = null;
                if (variable3 != null && (value = variable3.getValue()) != null) {
                    exceptionName = value.getValueString();
                }
                return ChromeExceptionBreakpointHandler.access$getResult(this.this$0, this.$exceptionData, exceptionName);
            }
            {
                this.this$0 = chromeExceptionBreakpointHandler;
                this.$exceptionData = exceptionData;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"`object`.properties\n    \u2026a, exceptionName)\n      }");
        return promise2;
    }

    private final XBreakpoint<?> getResult(ExceptionData exceptionData, String exceptionName) {
        XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint = this.findActiveBreakpoint(exceptionName);
        return breakpoint != null && this.isSuitable(exceptionData, breakpoint) ? breakpoint : null;
    }

    private final boolean isSuitable(ExceptionData exceptionData, XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint) {
        XBreakpointProperties xBreakpointProperties = breakpoint.getProperties();
        Intrinsics.checkExpressionValueIsNotNull((Object)xBreakpointProperties, (String)"breakpoint.properties");
        return !((JavaScriptExceptionBreakpointProperties)xBreakpointProperties).getUncaughtOnly() || exceptionData.isUncaught() != ThreeState.NO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final XBreakpoint<JavaScriptExceptionBreakpointProperties> findActiveBreakpoint(String exceptionName) {
        THashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> tHashSet = this.activeBreakpoints;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (tHashSet) {
            XBreakpoint breakpoint;
            boolean bl3 = false;
            XBreakpoint defaultBreakpoint = null;
            Iterator iterator = this.activeBreakpoints.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return defaultBreakpoint;
                }
                XBreakpoint xBreakpoint = breakpoint = (XBreakpoint)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)xBreakpoint, (String)"breakpoint");
                XBreakpointProperties xBreakpointProperties = xBreakpoint.getProperties();
                Intrinsics.checkExpressionValueIsNotNull((Object)xBreakpointProperties, (String)"breakpoint.properties");
                String name = ((JavaScriptExceptionBreakpointProperties)xBreakpointProperties).getExceptionName();
                if (name == null) {
                    defaultBreakpoint = breakpoint;
                    if (exceptionName != null) continue;
                    return defaultBreakpoint;
                }
                if (Intrinsics.areEqual((Object)name, (Object)exceptionName)) break;
            }
            return breakpoint;
        }
    }

    public ChromeExceptionBreakpointHandler(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        super(JavaScriptExceptionBreakpointType.class);
        this.debugProcess = debugProcess;
        this.activeBreakpoints = new THashSet();
        this.exceptionCatchMode = ExceptionCatchMode.NONE;
    }

    public static final /* synthetic */ XBreakpoint access$getResult(ChromeExceptionBreakpointHandler $this, ExceptionData exceptionData, String exceptionName) {
        return $this.getResult(exceptionData, exceptionName);
    }
}

