/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.idea.cloudConfig.ETagCloudConfigFileClient;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cloudconfig.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LocalCloudConfigFileClient
extends ETagCloudConfigFileClient {
    private final File myLocation;
    private final Set<String> myTags;

    public LocalCloudConfigFileClient(@NotNull File location) {
        if (location == null) {
            LocalCloudConfigFileClient.$$$reportNull$$$0(0);
        }
        super(new Configuration());
        this.myTags = new HashSet<String>();
        this.myLocation = location;
    }

    public List<String> list(String file) {
        File target = new File(this.myLocation, file);
        if (!target.exists()) {
            return Collections.emptyList();
        }
        File[] files = this.myLocation.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (File child : files) {
            if (!child.exists() || !child.isFile()) continue;
            result.add(child.getName());
        }
        return result;
    }

    public InputStream read(String file) throws IOException {
        if (this.myTags.contains(file)) {
            return null;
        }
        File target = new File(this.myLocation, file);
        if (target.exists() && target.isFile()) {
            this.myTags.add(file);
            return new FileInputStream(target);
        }
        throw new FileNotFoundException();
    }

    public void write(String file, InputStream content) throws IOException {
        File target = new File(this.myLocation, file);
        FileUtil.createParentDirs((File)target);
        try (FileOutputStream stream = new FileOutputStream(target);){
            FileUtil.copy((InputStream)content, (OutputStream)stream);
            this.myTags.remove(file);
        }
    }

    public void delete(String file) {
        FileUtil.delete((File)new File(this.myLocation, file));
        this.myTags.remove(file);
    }

    public void clearTags() {
        this.myTags.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/cloudConfig/LocalCloudConfigFileClient", "<init>"));
    }
}

