/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.diff.AsyncDiffElement;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.reference.SoftReference;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.plugins.webDeployment.AlwaysAsk;
import com.jetbrains.plugins.webDeployment.AlwaysOverwrite;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.SyncLocalVsRemoteAction;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.CompositeDiffElement;
import com.jetbrains.plugins.webDeployment.ui.LocalItemDiffElement;
import com.jetbrains.plugins.webDeployment.ui.RemoteDiffElement;
import com.jetbrains.plugins.webDeployment.ui.RemoteReadOnlyVirtualFile;
import com.jetbrains.plugins.webDeployment.ui.SyncLoadComponent;
import com.jetbrains.plugins.webDeployment.ui.SyncUtils;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FilesCache;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class RemoteItemDiffElement
extends DiffElement<FileObject>
implements AsyncDiffElement,
RemoteDiffElement {
    private static final Logger LOG = Logger.getInstance(RemoteItemDiffElement.class);
    private static final RemoteItemDiffElement[] EMPTY = new RemoteItemDiffElement[0];
    public static final int UNKNOWN_VALUE = -1;
    private static final long MAX_SIZE = 0x100000L;
    private final AtomicBoolean myOperationRunning;
    private final Project myProject;
    private final RemoteConnection myConnection;
    private final PublishConfig myConfig;
    private final Deployable myServer;
    private final FileObject myFile;
    private final org.apache.commons.vfs2.FileType myFileType;
    private final DirDiffSettings mySettings;
    private final String myName;
    private final boolean myIsRoot;
    private long mySize;
    private long myLastModified;
    private boolean myExcluded;
    private final DeploymentPathMapping myMapping;
    private SoftReference<byte[]> myCachedContent;
    private RemoteItemDiffElement[] myCachedChildren;
    private RemoteItemDiffElement[] myCachedExcludedChildren;

    public RemoteItemDiffElement(RemoteConnection connection, Deployable server, FileObject file, Project project, PublishConfig config, boolean excluded, DeploymentPathMapping mapping, DirDiffSettings settings, @NotNull String name, boolean isRoot) throws FileSystemException {
        if (name == null) {
            RemoteItemDiffElement.$$$reportNull$$$0(0);
        }
        this.myOperationRunning = new AtomicBoolean(false);
        this.myConnection = connection;
        this.myServer = server;
        this.myFile = file;
        this.myProject = project;
        this.myExcluded = excluded;
        this.myMapping = mapping;
        this.myConfig = config;
        this.mySettings = settings;
        this.myName = name;
        this.myIsRoot = isRoot;
        this.myFileType = ServerTreeNode.getFileType(file);
        if (org.apache.commons.vfs2.FileType.IMAGINARY != this.myFileType) {
            FileContent content = file.getContent();
            this.myLastModified = content.getLastModifiedTime(this.myServer.getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER);
            this.mySize = this.myFileType.hasContent() ? content.getSize() : 0L;
        } else {
            this.myLastModified = -1L;
            this.mySize = 0L;
        }
    }

    public RemoteItemDiffElement(RemoteConnection connection, Deployable server, FileObject file, Project project, PublishConfig config, boolean excluded, DeploymentPathMapping mapping, DirDiffSettings settings, boolean isRoot) throws FileSystemException {
        this(connection, server, file, project, config, excluded, mapping, settings, CompositeDiffElement.getSimpleRootName(file), isRoot);
    }

    public String getPath() {
        return this.myServer.getPresentablePath(this.myFile);
    }

    public String getPresentablePath() {
        return WDBundle.message("remote.diff.title.0.on.server.1", this.getShortPresentablePath(), this.myServer.getName());
    }

    protected String getShortPresentablePath() {
        return this.myServer.getPresentablePath(this.myFile);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RemoteItemDiffElement.$$$reportNull$$$0(1);
        }
        return string;
    }

    public long getSize() {
        if (this.shouldBeHidden()) {
            return -1L;
        }
        return this.mySize;
    }

    private boolean shouldBeHidden() {
        return this.myExcluded && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings);
    }

    public long getTimeStamp() {
        long result = this.shouldBeHidden() ? -1L : this.myLastModified;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timestamp of " + this.myServer.getPresentablePath(this.myFile) + " is " + this.myLastModified);
        }
        return result;
    }

    public boolean isContainer() {
        return this.myFileType.hasChildren();
    }

    public RemoteItemDiffElement[] getChildren() throws IOException {
        boolean showExcluded;
        LOG.assertTrue(this.isContainer());
        if (this.shouldBeHidden()) {
            return EMPTY;
        }
        boolean bl = showExcluded = !SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings);
        if (this.myCachedChildren == null || showExcluded && this.myCachedExcludedChildren == null) {
            FileObject[] children;
            if (this.myFile.isSymbolicLink()) {
                this.myCachedChildren = new RemoteItemDiffElement[0];
                this.myCachedExcludedChildren = new RemoteItemDiffElement[0];
                return EMPTY;
            }
            try {
                children = ServerTreeNode.getChildren(this.myFile, this.myServer, (ThrowableComputable<? extends RemoteConnection, ? extends FileSystemException>)((ThrowableComputable)() -> this.myConnection));
            }
            catch (CustomFileSystemException e) {
                throw new IOException(e.getMessage(), (Throwable)((Object)e));
            }
            if (children.length == 0) {
                return EMPTY;
            }
            ArrayList result = new ArrayList(children.length);
            ArrayList excludedResult = new ArrayList(children.length);
            try {
                for (FileObject child : children) {
                    this.myConnection.executeServerOperation((ThrowableRunnable<FileSystemException>)((ThrowableRunnable)() -> {
                        boolean excluded = SyncUtils.isExcludedRemoteOrCorresponding(child, this.myMapping, this.myServer, this.myConfig, this.mySettings);
                        if (!excluded) {
                            result.add(new RemoteItemDiffElement(this.myConnection, this.myServer, child, this.myProject, this.myConfig, excluded, this.myMapping, this.mySettings, false));
                        } else if (showExcluded) {
                            excludedResult.add(new RemoteItemDiffElement(this.myConnection, this.myServer, child, this.myProject, this.myConfig, excluded, this.myMapping, this.mySettings, false));
                        }
                    }), null);
                }
            }
            catch (FileSystemException e) {
                throw new IOException(e.getMessage(), e);
            }
            this.myCachedChildren = result.toArray(new RemoteItemDiffElement[0]);
            if (showExcluded) {
                this.myCachedExcludedChildren = excludedResult.toArray(new RemoteItemDiffElement[0]);
            }
        }
        if (!showExcluded) {
            return this.myCachedChildren;
        }
        RemoteItemDiffElement[] result = new RemoteItemDiffElement[this.myCachedChildren.length + this.myCachedExcludedChildren.length];
        System.arraycopy(this.myCachedChildren, 0, result, 0, this.myCachedChildren.length);
        System.arraycopy(this.myCachedExcludedChildren, 0, result, this.myCachedChildren.length, this.myCachedExcludedChildren.length);
        return result;
    }

    public byte @Nullable [] getContent() throws IOException {
        if (this.shouldBeHidden()) {
            return null;
        }
        if (this.myFileType == org.apache.commons.vfs2.FileType.IMAGINARY) {
            throw new IOException(WDBundle.message("file.0.can.not.be.found", this.myServer.getPresentablePath(this.myFile)));
        }
        if (RemoteItemDiffElement.isTooBig(this)) {
            return null;
        }
        byte[] result = this.getCachedRemoteContent();
        if (result == null) {
            Pair resultPair = (Pair)this.myConnection.executeServerOperationSilently(() -> {
                try {
                    return new Pair((Object)FileTransferUtil.getContent(this.myFile, null), null);
                }
                catch (IOException e) {
                    return new Pair(null, (Object)e);
                }
            }, null);
            if (resultPair.getSecond() != null) {
                throw (IOException)resultPair.getSecond();
            }
            result = (byte[])resultPair.getFirst();
            this.myCachedContent = new SoftReference((Object)result);
        }
        return result;
    }

    public FileObject getValue() {
        return this.myFile;
    }

    public Icon getIcon() {
        Icon basicIcon;
        Icon icon = basicIcon = this.isContainer() ? PlatformIcons.FOLDER_ICON : this.getFileType().getIcon();
        if (this.myFileType == org.apache.commons.vfs2.FileType.IMAGINARY) {
            return new LayeredIcon(new Icon[]{basicIcon, AllIcons.General.WarningDecorator});
        }
        return basicIcon;
    }

    public FileType getFileType() {
        String localPath = this.myMapping.mapToLocalPath(this.myFile, (Mappable)this.myServer);
        VirtualFile localFile = LocalFileSystem.getInstance().findFileByPath(localPath);
        if (localFile != null) {
            return localFile.getFileType();
        }
        return super.getFileType();
    }

    @NotNull
    public Charset getCharset() {
        String localPath = this.myMapping.mapToLocalPath(this.myFile, (Mappable)this.myServer);
        VirtualFile localFile = LocalFileSystem.getInstance().findFileByPath(localPath);
        if (localFile != null) {
            Charset charset = localFile.getCharset();
            if (charset == null) {
                RemoteItemDiffElement.$$$reportNull$$$0(2);
            }
            return charset;
        }
        Charset charset = EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset();
        if (charset == null) {
            RemoteItemDiffElement.$$$reportNull$$$0(3);
        }
        return charset;
    }

    @NotNull
    public DiffContent createDiffContent(@Nullable Project project, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        DiffContent diffContent;
        if (indicator == null) {
            RemoteItemDiffElement.$$$reportNull$$$0(4);
        }
        try {
            LOG.assertTrue(!this.shouldBeHidden());
            if (RemoteItemDiffElement.isTooBig(this)) {
                String message = WDBundle.message("can.not.build.diff.for.file.0.file.is.too.big.and.there.are.too.many.changes", this.getPath());
                throw new DiffRequestProducerException(message);
            }
            if (this.myFileType == org.apache.commons.vfs2.FileType.IMAGINARY) {
                String message = WDBundle.message("can.not.provide.content.of.file.0.probably.it.s.a.recursive.symlink", this.getPath());
                throw new DiffRequestProducerException(message);
            }
            byte[] content = this.getContent();
            if (content == null) {
                throw new DiffRequestProducerException("Can't get content");
            }
            diffContent = DiffContentFactory.getInstance().create(project, this.getVirtualFile(content));
        }
        catch (IOException e) {
            throw new DiffRequestProducerException((Throwable)e);
        }
        if (diffContent == null) {
            RemoteItemDiffElement.$$$reportNull$$$0(5);
        }
        return diffContent;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            RemoteItemDiffElement.$$$reportNull$$$0(6);
        }
        return project;
    }

    @NotNull
    public Promise<DiffElement> copyToAsync(@NotNull DiffElement container, final @Nullable DiffElement targetElement, @NotNull String path) {
        Document document;
        if (container == null) {
            RemoteItemDiffElement.$$$reportNull$$$0(7);
        }
        if (path == null) {
            RemoteItemDiffElement.$$$reportNull$$$0(8);
        }
        if (this.shouldBeHidden()) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                RemoteItemDiffElement.$$$reportNull$$$0(9);
            }
            return promise;
        }
        String errorMessage = DeploymentPathUtils.getErrorMessageForUnsupportedName(this.myFile.getName(), this.myServer);
        if (errorMessage != null) {
            Promise promise = Promises.rejectedPromise((String)errorMessage);
            if (promise == null) {
                RemoteItemDiffElement.$$$reportNull$$$0(10);
            }
            return promise;
        }
        LOG.assertTrue(container instanceof LocalItemDiffElement || container instanceof CompositeDiffElement.LocalCompositeDiffElement, container.getClass());
        if (!this.myOperationRunning.compareAndSet(false, true)) {
            LOG.debug("Operation is still running on " + this.getShortPresentablePath());
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                RemoteItemDiffElement.$$$reportNull$$$0(11);
            }
            return promise;
        }
        final String localPath = this.myMapping.mapToLocalPath(this.myFile, (Mappable)this.myServer);
        VirtualFile childFile = LocalFileSystem.getInstance().findFileByPath(localPath);
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document2 = document = childFile == null ? null : documentManager.getDocument(childFile);
        if (document != null) {
            documentManager.saveDocument(document);
        }
        SyncLoadComponent component = (SyncLoadComponent)this.mySettings.customSettings.get("syncLoadComponent");
        FileObject target = DeploymentPathUtils.getLocalFile(localPath);
        if (target == null) {
            LOG.warn("No child for download");
            String message = this.getErrorMessage();
            component.reportSkipping(message);
            this.myOperationRunning.set(false);
            Promise promise = Promises.rejectedPromise((String)message);
            if (promise == null) {
                RemoteItemDiffElement.$$$reportNull$$$0(12);
            }
            return promise;
        }
        final AsyncPromise promise = new AsyncPromise();
        TransferOperation.Copy operation = new TransferOperation.Copy(this.myFile, target){

            @Override
            public void execute(ExecutionContext context) throws FileSystemException {
                LocalItemDiffElement finalNewElement;
                LocalItemDiffElement newElement = null;
                try {
                    if (targetElement != null) {
                        context.setIgnoreOverwritingStrategy(AlwaysOverwrite.INSTANCE);
                    }
                    super.execute(context);
                    VirtualFile child = LocalFileSystem.getInstance().refreshAndFindFileByPath(localPath);
                    if (child == null) {
                        promise.setError(WDBundle.message("failed.to.create.local.file.0", localPath));
                    } else {
                        newElement = LocalItemDiffElement.createLocalElement(child, RemoteItemDiffElement.this.myMapping, RemoteItemDiffElement.this.myConfig, RemoteItemDiffElement.this.myServer, RemoteItemDiffElement.this.mySettings, RemoteItemDiffElement.this.myProject);
                    }
                    context.setIgnoreOverwritingStrategy(AlwaysAsk.INSTANCE);
                    RemoteItemDiffElement.this.myOperationRunning.set(false);
                    finalNewElement = newElement;
                }
                catch (FileSystemException e) {
                    try {
                        LOG.warn((Throwable)e);
                        promise.setError(WDBundle.message("failed.to.download.file.0", RemoteItemDiffElement.this.getPresentablePath()));
                        throw e;
                    }
                    catch (Throwable throwable) {
                        context.setIgnoreOverwritingStrategy(AlwaysAsk.INSTANCE);
                        RemoteItemDiffElement.this.myOperationRunning.set(false);
                        LocalItemDiffElement finalNewElement2 = newElement;
                        ApplicationManager.getApplication().invokeAndWait(() -> promise.setResult((Object)finalNewElement2));
                        throw throwable;
                    }
                }
                ApplicationManager.getApplication().invokeAndWait(() -> 1.lambda$execute$0(promise, (DiffElement)finalNewElement));
            }
        };
        component.offerTransferOperation(operation, false);
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            RemoteItemDiffElement.$$$reportNull$$$0(13);
        }
        return asyncPromise;
    }

    private String getErrorMessage() {
        return WDBundle.message("failed.to.copy.file.0.1", this.getShortPresentablePath(), WDBundle.message("destination.differs.from.mapped.destination", new Object[0]));
    }

    @NotNull
    public Promise<Void> deleteAsync() {
        if (!this.myOperationRunning.compareAndSet(false, true)) {
            LOG.debug("Operation is still running on " + this.getShortPresentablePath());
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                RemoteItemDiffElement.$$$reportNull$$$0(14);
            }
            return promise;
        }
        if (this.shouldBeHidden()) {
            LOG.debug("Excluded " + this.getPresentablePath());
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                RemoteItemDiffElement.$$$reportNull$$$0(15);
            }
            return promise;
        }
        final AsyncPromise promise = new AsyncPromise();
        SyncLoadComponent component = (SyncLoadComponent)this.mySettings.customSettings.get("syncLoadComponent");
        TransferOperation.Delete operation = new TransferOperation.Delete(this.myFile, false, true){

            @Override
            public void execute(ExecutionContext context) throws FileSystemException {
                try {
                    super.execute(context);
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    promise.setError(WDBundle.message("failed.to.delete.remote.file.0", RemoteItemDiffElement.this.getPresentablePath()));
                    throw e;
                }
                finally {
                    RemoteItemDiffElement.this.myOperationRunning.set(false);
                    ApplicationManager.getApplication().invokeAndWait(() -> promise.setResult(null));
                }
            }
        };
        component.offerTransferOperation(operation, true);
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            RemoteItemDiffElement.$$$reportNull$$$0(16);
        }
        return asyncPromise;
    }

    @Override
    @NotNull
    public RemoteConnection getConnection() {
        RemoteConnection remoteConnection = this.myConnection;
        if (remoteConnection == null) {
            RemoteItemDiffElement.$$$reportNull$$$0(17);
        }
        return remoteConnection;
    }

    public byte @Nullable [] getCachedRemoteContent() {
        return (byte[])SoftReference.dereference(this.myCachedContent);
    }

    public boolean isOperationsEnabled() {
        if (this.myIsRoot) {
            return true;
        }
        if (this.myOperationRunning.get() || this.myFileType == org.apache.commons.vfs2.FileType.IMAGINARY) {
            return false;
        }
        if (!SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            return true;
        }
        if (this.isExcluded()) {
            return false;
        }
        String localPath = this.myMapping.mapToLocalPath(this.myFile, (Mappable)this.myServer);
        return !this.myConfig.isExcludedByName(localPath) && !PublishConfig.isLocalPathExcluded(localPath, this.myServer, this.myConfig) && !SyncUtils.isLocalPathExcludedFromProject(localPath, this.mySettings);
    }

    public DiffElement<?> copyTo(DiffElement container, String relativePath) {
        throw new UnsupportedOperationException("Use BackgroundOperatingDiffElement.copyTo()");
    }

    public boolean delete() {
        throw new UnsupportedOperationException("Use BackgroundOperatingDiffElement.delete()");
    }

    protected boolean isExcluded() {
        return this.myExcluded;
    }

    public void refresh(boolean userInitiated) throws IOException {
        if (userInitiated && this.myFileType != org.apache.commons.vfs2.FileType.IMAGINARY) {
            try {
                this.myConnection.executeServerOperation((ThrowableRunnable<FileSystemException>)((ThrowableRunnable)() -> {
                    FileSystemManager manager = Objects.requireNonNull(PublishUtils.getManager());
                    FilesCache cache = manager.getFilesCache();
                    FileSystem fs = this.myFile.getFileSystem();
                    RemoteItemDiffElement.clearFileSystemCache(this, cache, fs);
                    this.myFile.refresh();
                    FileContent content = this.myFile.getContent();
                    this.myLastModified = content.getLastModifiedTime(this.myServer.getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER);
                    this.mySize = this.myFileType.hasContent() ? content.getSize() : 0L;
                    this.myCachedChildren = null;
                    this.myCachedExcludedChildren = null;
                    this.myCachedContent = null;
                    this.myExcluded = Boolean.TRUE.booleanValue() == this.myConfig.isExcludedByName(this.myServer.getPresentablePath(this.myFile));
                }), null);
            }
            catch (FileSystemException e) {
                LOG.warn((Throwable)e);
                throw new IOException(PublishUtils.getMessage(e, true), e);
            }
        }
    }

    private static void clearFileSystemCache(RemoteItemDiffElement element, FilesCache cache, FileSystem fileSystem) {
        cache.removeFile(fileSystem, element.getValue().getName());
        if (element.isContainer() && element.myCachedChildren != null) {
            for (RemoteItemDiffElement child : element.myCachedChildren) {
                RemoteItemDiffElement.clearFileSystemCache(child, cache, fileSystem);
            }
        }
    }

    public void reset(long size, long timestamp, byte @Nullable [] content) {
        this.mySize = size;
        this.myLastModified = timestamp;
        this.myCachedContent = content != null ? new SoftReference((Object)content) : null;
        this.myCachedChildren = null;
        this.myCachedExcludedChildren = null;
    }

    private VirtualFile getVirtualFile(byte[] content) {
        return new RemoteReadOnlyVirtualFile(this.myFile, content, false, this.getCharset());
    }

    public static boolean isTooBig(DiffElement element) {
        return element.getSize() > 0x100000L;
    }

    @NonNls
    public String toString() {
        return "RemoteItemDiffElement{name=" + this.getName() + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffContent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToAsync";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteAsync";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDiffContent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyToAsync";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

