/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.IgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RecursiveFileHolder
implements IgnoredFilesHolder {
    private final Project myProject;
    private final Set<FilePath> myMap;

    public RecursiveFileHolder(Project project) {
        this.myProject = project;
        this.myMap = new HashSet<FilePath>();
    }

    @Override
    public void cleanAll() {
        this.myMap.clear();
    }

    @Override
    public void addFile(@NotNull FilePath file) {
        if (file == null) {
            RecursiveFileHolder.$$$reportNull$$$0(0);
        }
        if (!this.containsFile(file)) {
            this.myMap.add(file);
        }
    }

    @Override
    public RecursiveFileHolder copy() {
        RecursiveFileHolder copyHolder = new RecursiveFileHolder(this.myProject);
        copyHolder.myMap.addAll(this.myMap);
        return copyHolder;
    }

    @Override
    public boolean containsFile(@NotNull FilePath file) {
        if (file == null) {
            RecursiveFileHolder.$$$reportNull$$$0(1);
        }
        if (this.myMap.isEmpty()) {
            return false;
        }
        for (FilePath parent = file; parent != null; parent = parent.getParentPath()) {
            if (!this.myMap.contains(parent)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<FilePath> values() {
        Set<FilePath> set = this.myMap;
        if (set == null) {
            RecursiveFileHolder.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    public void cleanAndAdjustScope(@NotNull VcsModifiableDirtyScope scope) {
        if (scope == null) {
            RecursiveFileHolder.$$$reportNull$$$0(3);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        Iterator<FilePath> iterator = this.myMap.iterator();
        while (iterator.hasNext()) {
            FilePath file = iterator.next();
            if (!RecursiveFileHolder.isFileDirty((VcsDirtyScope)scope, file)) continue;
            iterator.remove();
        }
    }

    private static boolean isFileDirty(@NotNull VcsDirtyScope scope, @NotNull FilePath filePath) {
        if (scope == null) {
            RecursiveFileHolder.$$$reportNull$$$0(4);
        }
        if (filePath == null) {
            RecursiveFileHolder.$$$reportNull$$$0(5);
        }
        return scope.belongsTo(filePath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecursiveFileHolder that = (RecursiveFileHolder)o;
        return this.myMap.equals(that.myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/RecursiveFileHolder";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/RecursiveFileHolder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cleanAndAdjustScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFileDirty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

