/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeInfoCalculator;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.LocalChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.RollbackUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RollbackChangesDialog
extends DialogWrapper {
    public static final String DELETE_LOCALLY_ADDED_FILES_KEY = "delete.locally.added.files";
    private final Project myProject;
    private final LocalChangesBrowser myBrowser;
    private final boolean myInvokedFromModalContext;
    private final JCheckBox myDeleteLocallyAddedFiles;
    private final ChangeInfoCalculator myInfoCalculator;
    private final CommitLegendPanel myCommitLegendPanel;
    private final Runnable myListChangeListener;
    private String myOperationName;

    public static void rollbackChanges(Project project, Collection<? extends Change> changes) {
        ChangeListManagerEx manager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)project);
        if (changes.isEmpty()) {
            RollbackChangesDialog.showNoChangesDialog(project);
            return;
        }
        THashSet lists = new THashSet();
        lists.addAll(manager.getAffectedLists(changes));
        new RollbackChangesDialog(project, new ArrayList<LocalChangeList>((Collection<LocalChangeList>)lists), new ArrayList<Change>(changes)).show();
    }

    public static void rollbackChanges(Project project, LocalChangeList changeList) {
        ArrayList changes = new ArrayList(changeList.getChanges());
        if (changes.isEmpty()) {
            RollbackChangesDialog.showNoChangesDialog(project);
            return;
        }
        new RollbackChangesDialog(project, Collections.singletonList(changeList), Collections.emptyList()).show();
    }

    private static void showNoChangesDialog(Project project) {
        String operationName = UIUtil.removeMnemonic((String)RollbackUtil.getRollbackOperationName(project));
        Messages.showWarningDialog((Project)project, (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.text", (Object[])new Object[0]), (String)VcsBundle.message((String)"changes.action.rollback.nothing", (Object[])new Object[]{operationName}));
    }

    public RollbackChangesDialog(Project project, List<LocalChangeList> changeLists, List<Change> changes) {
        super(project, true);
        this.myProject = project;
        this.myInvokedFromModalContext = LaterInvocator.isInModalContext();
        this.myInfoCalculator = new ChangeInfoCalculator();
        this.myCommitLegendPanel = new CommitLegendPanel(this.myInfoCalculator);
        this.myListChangeListener = new Runnable(){

            @Override
            public void run() {
                if (RollbackChangesDialog.this.myBrowser != null) {
                    List<Change> allChanges = RollbackChangesDialog.this.myBrowser.getAllChanges();
                    List<Change> includedChanges = RollbackChangesDialog.this.myBrowser.getIncludedChanges();
                    RollbackChangesDialog.this.myInfoCalculator.update(allChanges, new ArrayList<Change>(includedChanges));
                    RollbackChangesDialog.this.myCommitLegendPanel.update();
                    boolean hasNewFiles = ContainerUtil.exists(includedChanges, change -> change.getType() == Change.Type.NEW);
                    RollbackChangesDialog.this.myDeleteLocallyAddedFiles.setEnabled(hasNewFiles);
                }
            }
        };
        this.myBrowser = new LocalChangesBrowser(project);
        this.myBrowser.setIncludedChanges(changes);
        this.myBrowser.setChangeLists(changeLists);
        this.myBrowser.setInclusionChangedListener(this.myListChangeListener);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myBrowser);
        this.myOperationName = RollbackChangesDialog.operationNameByChanges(project, this.myBrowser.getAllChanges());
        this.myBrowser.setToggleActionTitle("&Include in " + StringUtil.toLowerCase((String)this.myOperationName));
        this.setOKButtonText(this.myOperationName);
        this.myOperationName = UIUtil.removeMnemonic((String)this.myOperationName);
        this.setTitle(VcsBundle.message((String)"changes.action.rollback.custom.title", (Object[])new Object[]{this.myOperationName}));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.myDeleteLocallyAddedFiles = new JCheckBox(VcsBundle.message((String)"changes.checkbox.delete.locally.added.files", (Object[])new Object[0]));
        this.myDeleteLocallyAddedFiles.setSelected(PropertiesComponent.getInstance().isTrueValue(DELETE_LOCALLY_ADDED_FILES_KEY));
        this.myDeleteLocallyAddedFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesComponent.getInstance().setValue(RollbackChangesDialog.DELETE_LOCALLY_ADDED_FILES_KEY, RollbackChangesDialog.this.myDeleteLocallyAddedFiles.isSelected());
            }
        });
        this.init();
        this.myListChangeListener.run();
    }

    @NotNull
    public static String operationNameByChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes) {
        if (project == null) {
            RollbackChangesDialog.$$$reportNull$$$0(0);
        }
        if (changes == null) {
            RollbackChangesDialog.$$$reportNull$$$0(1);
        }
        String string = RollbackUtil.getRollbackOperationName(ChangesUtil.getAffectedVcses(changes, (Project)project));
        if (string == null) {
            RollbackChangesDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void doOKAction() {
        super.doOKAction();
        RollbackWorker worker = new RollbackWorker(this.myProject, this.myOperationName, this.myInvokedFromModalContext);
        worker.doRollback(this.myBrowser.getIncludedChanges(), this.myDeleteLocallyAddedFiles.isSelected());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)1), 0, 0);
        gb.fill = 2;
        gb.weightx = 1.0;
        JPanel border = new JPanel(new BorderLayout());
        border.setBorder((Border)JBUI.Borders.emptyTop((int)2));
        border.add((Component)this.myBrowser, "Center");
        gb.fill = 1;
        gb.weighty = 1.0;
        ++gb.gridy;
        panel2.add((Component)border, gb);
        SimpleColoredComponent commitLegendPanel = this.myCommitLegendPanel.getComponent();
        commitLegendPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
        gb.fill = 0;
        gb.weightx = 0.0;
        gb.weighty = 0.0;
        ++gb.gridy;
        panel2.add((Component)commitLegendPanel, gb);
        ++gb.gridy;
        panel2.add((Component)this.myDeleteLocallyAddedFiles, gb);
        return panel2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myBrowser.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "RollbackChangesDialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/RollbackChangesDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/RollbackChangesDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "operationNameByChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "operationNameByChanges";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

