/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import org.jetbrains.annotations.NotNull;

public class LimitHistoryCheck {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myFilePath;
    private int myLimit;
    private int myCount;
    private boolean myWarningShown;

    public LimitHistoryCheck(@NotNull Project project, @NotNull String filePath) {
        if (project == null) {
            LimitHistoryCheck.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            LimitHistoryCheck.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFilePath = filePath;
        this.myWarningShown = false;
        this.init();
    }

    private void init() {
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myLimit = configuration.LIMIT_HISTORY ? configuration.MAXIMUM_HISTORY_ROWS : -1;
        this.myCount = 0;
    }

    public void checkNumber() {
        if (this.myLimit <= 0) {
            return;
        }
        ++this.myCount;
        if (this.isOver()) {
            if (!this.myWarningShown) {
                String message = VcsBundle.message((String)"file.history.exceeded.limit.message", (Object[])new Object[]{this.myLimit, this.myFilePath});
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message, MessageType.WARNING, new NamedRunnable[0]);
                this.myWarningShown = true;
            }
            throw new VcsFileHistoryLimitReachedException();
        }
    }

    public void reset() {
        this.init();
    }

    public boolean isOver() {
        return this.isOver(this.myCount);
    }

    public boolean isOver(int count) {
        return this.myLimit > 0 && this.myLimit < count;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "filePath";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/history/LimitHistoryCheck";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class VcsFileHistoryLimitReachedException
    extends RuntimeException {
    }
}

