/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.primitives.Ints;
import com.intellij.diff.editor.VCSContentVirtualFile;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.navigation.History;
import com.intellij.util.Consumer;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.actions.IntelliSortChooserPopupAction;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.ui.frame.FrameDiffPreview;
import com.intellij.vcs.log.ui.frame.VcsLogChangeProcessor;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import com.intellij.vcs.log.ui.frame.VcsLogCommitDetailsListPanel;
import com.intellij.vcs.log.ui.table.CommitSelectionListener;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.BekUtil;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import com.intellij.vcsUtil.UIVcsUtilKt;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import kotlin.Unit;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainFrame
extends JPanel
implements DataProvider,
Disposable {
    private static final String DIFF_SPLITTER_PROPORTION = "vcs.log.diff.splitter.proportion";
    private static final String DETAILS_SPLITTER_PROPORTION = "vcs.log.details.splitter.proportion";
    private static final String CHANGES_SPLITTER_PROPORTION = "vcs.log.changes.splitter.proportion";
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final JComponent myToolbar;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final VcsLogFilterUiEx myFilterUi;
    @NotNull
    private final VcsLogChangesBrowser myChangesBrowser;
    @NotNull
    private final Splitter myChangesBrowserSplitter;
    @NotNull
    private final VcsLogCommitDetailsListPanel myDetailsPanel;
    @NotNull
    private final Splitter myDetailsSplitter;
    @NotNull
    private final EditorNotificationPanel myNotificationLabel;
    @NotNull
    private final AbstractVcsLogUi myLogUi;
    @Nullable
    private final FrameDiffPreview<VcsLogChangeProcessor> myDiffPreview;
    @Nullable
    private VCSContentVirtualFile myGraphViewFile;
    @NotNull
    private final JComponent myToolbarsAndTable;

    public MainFrame(@NotNull VcsLogData logData, final @NotNull AbstractVcsLogUi logUi, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogFilterUiEx filterUi, boolean withDiffPreview) {
        if (logData == null) {
            MainFrame.$$$reportNull$$$0(0);
        }
        if (logUi == null) {
            MainFrame.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            MainFrame.$$$reportNull$$$0(2);
        }
        if (filterUi == null) {
            MainFrame.$$$reportNull$$$0(3);
        }
        this.myLogData = logData;
        this.myUiProperties = uiProperties;
        this.myFilterUi = filterUi;
        this.myLogUi = logUi;
        this.myGraphTable = new MyVcsLogGraphTable(logUi, logData);
        this.myGraphTable.setCompactReferencesView(this.myUiProperties.get(MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW));
        this.myGraphTable.setShowTagNames(this.myUiProperties.get(MainVcsLogUiProperties.SHOW_TAG_NAMES));
        this.myGraphTable.setLabelsLeftAligned(this.myUiProperties.get(MainVcsLogUiProperties.LABELS_LEFT_ALIGNED));
        PopupHandler.installPopupHandler((JComponent)((Object)this.myGraphTable), (String)"Vcs.Log.ContextMenu", (String)"Vcs.Log.ContextMenu");
        this.myDetailsPanel = new VcsLogCommitDetailsListPanel(logData, logUi.getColorManager(), this){

            @Override
            protected void navigate(@NotNull CommitId commit) {
                if (commit == null) {
                    1.$$$reportNull$$$0(0);
                }
                logUi.jumpToCommit(commit.getHash(), commit.getRoot());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/ui/frame/MainFrame$1", "navigate"));
            }
        };
        this.myChangesBrowser = new VcsLogChangesBrowser(logData.getProject(), this.myUiProperties, (Function<? super CommitId, ? extends VcsShortCommitDetails>)((Function)commitId -> {
            int index = this.myLogData.getCommitIndex(commitId.getHash(), commitId.getRoot());
            return this.myLogData.getMiniDetailsGetter().getCommitData(index, Collections.singleton(index));
        }), this);
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(this.myChangesBrowser.getDiffAction().getShortcutSet(), (JComponent)((Object)this.getGraphTable()));
        JBLoadingPanel changesLoadingPane = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
        changesLoadingPane.add((Component)this.myChangesBrowser);
        this.myToolbar = this.createActionsToolbar();
        this.myChangesBrowser.setToolbarHeightReferent(this.myToolbar);
        MyCommitSelectionListenerForDiff listenerForDiff = new MyCommitSelectionListenerForDiff(changesLoadingPane);
        this.myGraphTable.getSelectionModel().addListSelectionListener(listenerForDiff);
        Disposer.register((Disposable)this, () -> this.myGraphTable.getSelectionModel().removeListSelectionListener(listenerForDiff));
        this.myDetailsPanel.installCommitSelectionListener(this.myGraphTable);
        VcsLogUiUtil.installDetailsListeners(this.myGraphTable, this.myDetailsPanel, this.myLogData, this);
        this.myNotificationLabel = new EditorNotificationPanel(UIUtil.getPanelBackground());
        this.myNotificationLabel.setVisible(false);
        this.myNotificationLabel.setBorder((Border)new CompoundBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0), (Border)ObjectUtils.notNull((Object)this.myNotificationLabel.getBorder(), (Object)JBUI.Borders.empty())));
        JPanel toolbars = new JPanel(new BorderLayout());
        toolbars.add((Component)this.myToolbar, "North");
        toolbars.add((Component)this.myNotificationLabel, "Center");
        this.myToolbarsAndTable = new JPanel(new BorderLayout());
        this.myToolbarsAndTable.add((Component)toolbars, "North");
        this.myToolbarsAndTable.add((Component)VcsLogUiUtil.installProgress(VcsLogUiUtil.setupScrolledGraph(this.myGraphTable, 2), this.myLogData, logUi.getId(), this), "Center");
        this.myDetailsSplitter = new OnePixelSplitter(true, DETAILS_SPLITTER_PROPORTION, 0.7f);
        this.myDetailsSplitter.setFirstComponent((JComponent)changesLoadingPane);
        this.showDetails(this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
        this.myChangesBrowserSplitter = new OnePixelSplitter(false, CHANGES_SPLITTER_PROPORTION, 0.7f);
        this.installGraphView();
        this.myChangesBrowserSplitter.setSecondComponent((JComponent)this.myDetailsSplitter);
        this.setLayout(new BorderLayout());
        if (withDiffPreview) {
            this.myDiffPreview = new FrameDiffPreview<VcsLogChangeProcessor>(this.createDiffPreview(false, this.myChangesBrowser), (VcsLogUiProperties)this.myUiProperties, (JComponent)this.myChangesBrowserSplitter, DIFF_SPLITTER_PROPORTION, Registry.is((String)"vcs.log.diff.preview.vertical"), 0.7f){

                @Override
                public void updatePreview(boolean state) {
                    ((VcsLogChangeProcessor)this.getPreviewDiff()).updatePreview(state);
                }
            };
            this.add(this.myDiffPreview.getMainComponent());
        } else {
            this.myDiffPreview = null;
            this.add((Component)this.myChangesBrowserSplitter);
        }
        Disposer.register((Disposable)logUi, (Disposable)this);
        this.myGraphTable.resetDefaultFocusTraversalKeys();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)((Object)new MyFocusPolicy()));
    }

    @NotNull
    public VcsLogChangeProcessor createDiffPreview(boolean isInEditor, @NotNull Disposable parent) {
        if (parent == null) {
            MainFrame.$$$reportNull$$$0(4);
        }
        VcsLogChangeProcessor processor = new VcsLogChangeProcessor(this.myLogData.getProject(), this.myChangesBrowser, isInEditor, parent);
        if (!isInEditor) {
            processor.getToolbarWrapper().setVerticalSizeReferent(this.getToolbar());
        }
        VcsLogChangeProcessor vcsLogChangeProcessor = processor;
        if (vcsLogChangeProcessor == null) {
            MainFrame.$$$reportNull$$$0(5);
        }
        return vcsLogChangeProcessor;
    }

    private void installGraphView() {
        if (Registry.is((String)"show.log.as.editor.tab")) {
            DataManager.registerDataProvider((JComponent)this.myToolbarsAndTable, (DataProvider)this);
            ApplicationManager.getApplication().invokeLater(this::openLogEditorTab, ModalityState.NON_MODAL);
            new AnAction(){
                {
                    this.setShortcutSet(CommonShortcuts.ESCAPE);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    MainFrame.this.openLogEditorTab();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/frame/MainFrame$3", "actionPerformed"));
                }
            }.registerCustomShortcutSet((JComponent)this.myChangesBrowser, (Disposable)this);
        } else {
            this.myChangesBrowserSplitter.setFirstComponent(this.myToolbarsAndTable);
        }
    }

    public void openLogEditorTab() {
        VirtualFile file = this.getOrCreateGraphViewFile();
        FileEditor[] editors = FileEditorManager.getInstance((Project)this.myLogData.getProject()).openFile(file, true);
        assert (editors.length == 1) : "opened multiple log editors for " + file;
        FileEditor editor = editors[0];
        JComponent component = editor.getComponent();
        EditorWindowHolder holder = (EditorWindowHolder)ComponentUtil.getParentOfType(EditorWindowHolder.class, (Component)component);
        if (holder == null) {
            return;
        }
        EditorWindow editorWindow = holder.getEditorWindow();
        editorWindow.setFilePinned(file, true);
    }

    private VirtualFile getOrCreateGraphViewFile() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myGraphViewFile == null || !this.myGraphViewFile.isValid()) {
            this.myGraphViewFile = new VCSContentVirtualFile(this.myToolbarsAndTable, () -> this.getTabName());
            this.myGraphViewFile.putUserData(VCSContentVirtualFile.TabSelector, () -> {
                VcsLogContentUtil.findAndSelect(this.myLogData.getProject(), AbstractVcsLogUi.class, ui1 -> ui1.getId() == this.myLogUi.getId());
                return Unit.INSTANCE;
            });
        }
        Disposer.register((Disposable)this, () -> {
            this.myGraphViewFile = null;
        });
        return this.myGraphViewFile;
    }

    private String getTabName() {
        String name = "all";
        VcsLogFilterCollection filters = this.myFilterUi.getFilters();
        if (!filters.isEmpty()) {
            name = StringUtil.shortenTextWithEllipsis((String)VcsLogFiltersKt.getPresentation(filters), (int)150, (int)20);
        }
        return ContentUtilEx.getFullName((String)VcsLogContentProvider.TAB_NAME, (String)name);
    }

    public void setExplanationHtml(@Nullable String text2) {
        this.myNotificationLabel.setText(text2);
        this.myNotificationLabel.setVisible(text2 != null);
    }

    public void updateDataPack(@NotNull VisiblePack dataPack, boolean permGraphChanged) {
        if (dataPack == null) {
            MainFrame.$$$reportNull$$$0(6);
        }
        this.myFilterUi.updateDataPack(dataPack);
        this.myGraphTable.updateDataPack(dataPack, permGraphChanged);
        this.myChangesBrowser.setAffectedPaths(VcsLogUtil.getAffectedPaths(dataPack));
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myGraphTable;
        if (vcsLogGraphTable == null) {
            MainFrame.$$$reportNull$$$0(7);
        }
        return vcsLogGraphTable;
    }

    @NotNull
    public VcsLogFilterUiEx getFilterUi() {
        VcsLogFilterUiEx vcsLogFilterUiEx = this.myFilterUi;
        if (vcsLogFilterUiEx == null) {
            MainFrame.$$$reportNull$$$0(8);
        }
        return vcsLogFilterUiEx;
    }

    @NotNull
    private JComponent createActionsToolbar() {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.copyFromGroup((DefaultActionGroup)ActionManager.getInstance().getAction("Vcs.Log.Toolbar.Internal"));
        if (BekUtil.isBekEnabled()) {
            Constraints constraint = new Constraints(Anchor.BEFORE, "Vcs.Log.PresentationSettings");
            if (BekUtil.isLinearBekEnabled()) {
                toolbarGroup.add((AnAction)new IntelliSortChooserPopupAction(), constraint);
            } else {
                toolbarGroup.add(ActionManager.getInstance().getAction("Vcs.Log.IntelliSortChooser"), constraint);
            }
        }
        DefaultActionGroup mainGroup = new DefaultActionGroup();
        mainGroup.add(ActionManager.getInstance().getAction("Vcs.Log.TextFilterSettings"));
        mainGroup.add((AnAction)new Separator());
        mainGroup.add((AnAction)this.myFilterUi.createActionGroup());
        mainGroup.addSeparator();
        mainGroup.add((AnAction)toolbarGroup);
        ActionToolbar toolbar = this.createActionsToolbar(mainGroup);
        Wrapper textFilter = new Wrapper((JComponent)this.myFilterUi.getTextFilterComponent());
        textFilter.setVerticalSizeReferent(toolbar.getComponent());
        DefaultActionGroup rightCornerGroup = new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("Vcs.Log.Toolbar.RightCorner")});
        ActionToolbar rightCornerToolbar = this.createActionsToolbar(rightCornerGroup);
        rightCornerToolbar.setReservePlaceAutoPopupIcon(false);
        rightCornerToolbar.setLayoutPolicy(0);
        DefaultActionGroup leftCornerGroup = new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("Vcs.Log.Toolbar.LeftCorner")});
        ActionToolbar leftCornerToolbar = this.createActionsToolbar(leftCornerGroup);
        leftCornerToolbar.setReservePlaceAutoPopupIcon(false);
        leftCornerToolbar.setLayoutPolicy(0);
        JPanel panel2 = new JPanel((LayoutManager)new MigLayout("ins 0, fill", "[]0[left]0[left, fill]push[right]", "center"));
        UIVcsUtilKt.installVisibilityReferent((JComponent)panel2, (JComponent)toolbar.getComponent());
        panel2.add(leftCornerToolbar.getComponent());
        panel2.add((Component)textFilter);
        panel2.add(toolbar.getComponent());
        panel2.add(rightCornerToolbar.getComponent());
        JPanel jPanel = panel2;
        if (jPanel == null) {
            MainFrame.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    @NotNull
    private ActionToolbar createActionsToolbar(@NotNull DefaultActionGroup mainGroup) {
        if (mainGroup == null) {
            MainFrame.$$$reportNull$$$0(10);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("Vcs.Log.Toolbar", (ActionGroup)mainGroup, true);
        toolbar.setTargetComponent((JComponent)this);
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            MainFrame.$$$reportNull$$$0(11);
        }
        return actionToolbar;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            MainFrame.$$$reportNull$$$0(12);
        }
        if (VcsDataKeys.CHANGES.is(dataId) || VcsDataKeys.SELECTED_CHANGES.is(dataId)) {
            return this.myChangesBrowser.getDirectChanges().toArray(new Change[0]);
        }
        if (VcsLogInternalDataKeys.LOG_UI_PROPERTIES.is(dataId)) {
            return this.myUiProperties;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            Collection<VirtualFile> roots = this.getSelectedRoots();
            return VfsUtilCore.toVirtualFileArray(roots);
        }
        if (VcsLogInternalDataKeys.LOG_DIFF_HANDLER.is(dataId)) {
            Collection<VirtualFile> roots = this.getSelectedRoots();
            if (roots.size() != 1) {
                return null;
            }
            return this.myLogData.getLogProvider((VirtualFile)Objects.requireNonNull(ContainerUtil.getFirstItem(roots))).getDiffHandler();
        }
        if (VcsLogDataKeys.VCS_LOG.is(dataId)) {
            return this.myLogUi.getVcsLog();
        }
        if (VcsLogDataKeys.VCS_LOG_UI.is(dataId)) {
            return this.myLogUi;
        }
        if (VcsDataKeys.VCS_REVISION_NUMBER.is(dataId)) {
            List hashes = this.myLogUi.getVcsLog().getSelectedCommits();
            if (hashes.isEmpty()) {
                return null;
            }
            return VcsLogUtil.convertToRevisionNumber(((CommitId)Objects.requireNonNull(ContainerUtil.getFirstItem((List)hashes))).getHash());
        }
        if (VcsDataKeys.VCS_REVISION_NUMBERS.is(dataId)) {
            List hashes = this.myLogUi.getVcsLog().getSelectedCommits();
            if (hashes.size() > 1000) {
                return null;
            }
            return ContainerUtil.map((Collection)hashes, commitId -> VcsLogUtil.convertToRevisionNumber(commitId.getHash())).toArray(new VcsRevisionNumber[0]);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myLogUi.getHelpId();
        }
        if (History.KEY.is(dataId)) {
            return this.myLogUi.getNavigationHistory();
        }
        return null;
    }

    @NotNull
    private Collection<VirtualFile> getSelectedRoots() {
        Collection<VirtualFile> roots = this.myLogData.getRoots();
        if (roots.size() == 1) {
            Collection<VirtualFile> collection = roots;
            if (collection == null) {
                MainFrame.$$$reportNull$$$0(13);
            }
            return collection;
        }
        int[] selectedRows = this.myGraphTable.getSelectedRows();
        if (selectedRows.length == 0 || selectedRows.length > 1000) {
            Set<VirtualFile> set = VcsLogUtil.getAllVisibleRoots(roots, this.myFilterUi.getFilters());
            if (set == null) {
                MainFrame.$$$reportNull$$$0(14);
            }
            return set;
        }
        Set set = ContainerUtil.map2Set((Collection)Ints.asList((int[])selectedRows), row2 -> this.myGraphTable.getModel().getRootAtRow((int)row2));
        if (set == null) {
            MainFrame.$$$reportNull$$$0(15);
        }
        return set;
    }

    @NotNull
    public JComponent getToolbar() {
        JComponent jComponent = this.myToolbar;
        if (jComponent == null) {
            MainFrame.$$$reportNull$$$0(16);
        }
        return jComponent;
    }

    @NotNull
    public VcsLogChangesBrowser getChangesBrowser() {
        VcsLogChangesBrowser vcsLogChangesBrowser = this.myChangesBrowser;
        if (vcsLogChangesBrowser == null) {
            MainFrame.$$$reportNull$$$0(17);
        }
        return vcsLogChangesBrowser;
    }

    public void showDetails(boolean state) {
        this.myDetailsSplitter.setSecondComponent((JComponent)((Object)(state ? this.myDetailsPanel : null)));
    }

    public void dispose() {
        this.myDetailsSplitter.dispose();
        this.myChangesBrowserSplitter.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterUi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/MainFrame";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainGroup";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/MainFrame";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffPreview";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphTable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterUi";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionsToolbar";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRoots";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDiffPreview";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateDataPack";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createActionsToolbar";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyVcsLogGraphTable
    extends VcsLogGraphTable {
        @NotNull
        private final Runnable myRefresh;

        MyVcsLogGraphTable(@NotNull AbstractVcsLogUi ui2, VcsLogData logData) {
            if (ui2 == null) {
                MyVcsLogGraphTable.$$$reportNull$$$0(0);
            }
            if (logData == null) {
                MyVcsLogGraphTable.$$$reportNull$$$0(1);
            }
            super(ui2.getId(), logData, ui2.getProperties(), ui2.getColorManager(), (Consumer<Runnable>)((Consumer)ui2::requestMore), ui2);
            this.myRefresh = () -> ui2.getRefresher().onRefresh();
        }

        @Override
        protected void updateEmptyText() {
            StatusText statusText2 = this.getEmptyText();
            VisiblePack visiblePack = this.getModel().getVisiblePack();
            DataPackBase dataPack = visiblePack.getDataPack();
            if (dataPack instanceof DataPack.ErrorDataPack) {
                this.setErrorEmptyText(((DataPack.ErrorDataPack)dataPack).getError(), VcsLogBundle.message((String)"vcs.log.error.loading.status", (Object[])new Object[0]));
                this.appendActionToEmptyText(VcsLogBundle.message((String)"vcs.log.refresh.status.action", (Object[])new Object[0]), () -> MainFrame.this.myLogData.refresh(MainFrame.this.myLogData.getLogProviders().keySet()));
            } else if (visiblePack instanceof VisiblePack.ErrorVisiblePack) {
                this.setErrorEmptyText(((VisiblePack.ErrorVisiblePack)visiblePack).getError(), VcsLogBundle.message((String)"vcs.log.error.filtering.status", (Object[])new Object[0]));
                if (visiblePack.getFilters().isEmpty()) {
                    this.appendActionToEmptyText(VcsLogBundle.message((String)"vcs.log.refresh.status.action", (Object[])new Object[0]), this.myRefresh);
                } else {
                    VcsLogUiUtil.appendResetFiltersActionToEmptyText(MainFrame.this.myFilterUi, this.getEmptyText());
                }
            } else if (visiblePack.getVisibleGraph().getVisibleCommitCount() == 0) {
                if (visiblePack.getFilters().isEmpty()) {
                    statusText2.setText(VcsLogBundle.message((String)"vcs.log.no.commits.status", (Object[])new Object[0])).appendSecondaryText(VcsLogBundle.message((String)"vcs.log.commit.status.action", (Object[])new Object[0]), VcsLogUiUtil.getLinkAttributes(), ActionUtil.createActionListener((String)"CheckinProject", (Component)((Object)this), (String)"unknown"));
                    String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"CheckinProject");
                    if (!shortcutText.isEmpty()) {
                        statusText2.appendSecondaryText(" (" + shortcutText + ")", StatusText.DEFAULT_ATTRIBUTES, null);
                    }
                } else {
                    MainFrame.this.myFilterUi.setCustomEmptyText(this.getEmptyText());
                }
            } else {
                statusText2.setText(VcsLogBundle.message((String)"vcs.log.default.status", (Object[])new Object[0]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ui";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "logData";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/frame/MainFrame$MyVcsLogGraphTable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFocusPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyFocusPolicy() {
        }

        @NotNull
        protected List<Component> getOrderedComponents() {
            ArrayList components = ContainerUtil.newArrayList((Object[])new Component[]{MainFrame.this.myGraphTable, MainFrame.this.myChangesBrowser.getPreferredFocusedComponent(), MainFrame.this.myFilterUi.getTextFilterComponent().getTextEditor()});
            if (MainFrame.this.myDiffPreview != null) {
                components.add(2, ((VcsLogChangeProcessor)MainFrame.this.myDiffPreview.getPreviewDiff()).getPreferredFocusedComponent());
            }
            ArrayList arrayList = components;
            if (arrayList == null) {
                MyFocusPolicy.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame$MyFocusPolicy", "getOrderedComponents"));
        }
    }

    private class MyCommitSelectionListenerForDiff
    extends CommitSelectionListener<VcsFullCommitDetails> {
        @NotNull
        private final JBLoadingPanel myChangesLoadingPane;

        protected MyCommitSelectionListenerForDiff(JBLoadingPanel changesLoadingPane) {
            if (changesLoadingPane == null) {
                MyCommitSelectionListenerForDiff.$$$reportNull$$$0(0);
            }
            super(MainFrame.this.myGraphTable, MainFrame.this.myLogData.getCommitDetailsGetter());
            this.myChangesLoadingPane = changesLoadingPane;
        }

        @Override
        protected void onEmptySelection() {
            MainFrame.this.myChangesBrowser.setSelectedDetails(Collections.emptyList());
        }

        @Override
        protected void onDetailsLoaded(@NotNull List<? extends VcsFullCommitDetails> detailsList) {
            int maxSize;
            if (detailsList == null) {
                MyCommitSelectionListenerForDiff.$$$reportNull$$$0(1);
            }
            if ((maxSize = VcsLogUtil.getMaxSize(detailsList)) > VcsLogUtil.getShownChangesLimit()) {
                String sizeText = VcsLogUtil.getSizeText(maxSize);
                MainFrame.this.myChangesBrowser.showText(statusText2 -> {
                    statusText2.setText(VcsLogBundle.message((String)"vcs.log.changes.too.many.status", (Object[])new Object[]{detailsList.size(), sizeText}));
                    statusText2.appendSecondaryText(VcsLogBundle.message((String)"vcs.log.changes.too.many.show.anyway.status.action", (Object[])new Object[0]), VcsLogUiUtil.getLinkAttributes(), e -> MainFrame.this.myChangesBrowser.setSelectedDetails(detailsList));
                });
            } else {
                MainFrame.this.myChangesBrowser.setSelectedDetails(detailsList);
            }
        }

        @Override
        protected void onSelection(int @NotNull [] selection) {
            if (selection == null) {
                MyCommitSelectionListenerForDiff.$$$reportNull$$$0(2);
            }
            if (Registry.is((String)"show.log.as.editor.tab")) {
                ChangesViewContentManager.getInstance(MainFrame.this.myLogData.getProject()).selectContent("Repository");
            }
            MainFrame.this.myChangesBrowser.resetSelectedDetails();
        }

        @Override
        protected void startLoading() {
            this.myChangesLoadingPane.startLoading();
        }

        @Override
        protected void stopLoading() {
            this.myChangesLoadingPane.stopLoading();
        }

        @Override
        protected void onError(@NotNull Throwable error) {
            if (error == null) {
                MyCommitSelectionListenerForDiff.$$$reportNull$$$0(3);
            }
            MainFrame.this.myChangesBrowser.showText(statusText2 -> statusText2.setText(VcsLogBundle.message((String)"vcs.log.error.loading.status", (Object[])new Object[0])));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesLoadingPane";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "detailsList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/frame/MainFrame$MyCommitSelectionListenerForDiff";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onDetailsLoaded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onSelection";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onError";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

