/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.testing.JsTestRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTestRunnerManager {
    private static final Key<CachedValue<Set<JsTestRunConfigurationProducer<?>>>> KEY = Key.create((String)JsTestRunConfigurationProducer.class.getSimpleName());
    private static final JSTestRunnerManager INSTANCE = new JSTestRunnerManager();

    @NotNull
    public static JSTestRunnerManager getInstance() {
        JSTestRunnerManager jSTestRunnerManager = INSTANCE;
        if (jSTestRunnerManager == null) {
            JSTestRunnerManager.$$$reportNull$$$0(0);
        }
        return jSTestRunnerManager;
    }

    @NotNull
    private static Set<JsTestRunConfigurationProducer<?>> findTestRunnerAsDirectDependency(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull NotNullLazyValue<List<JsTestRunConfigurationProducer<?>>> allProducers) {
        if (project == null) {
            JSTestRunnerManager.$$$reportNull$$$0(1);
        }
        if (fileOrDir == null) {
            JSTestRunnerManager.$$$reportNull$$$0(2);
        }
        if (allProducers == null) {
            JSTestRunnerManager.$$$reportNull$$$0(3);
        }
        HashSet producers = new HashSet(1);
        PackageJsonUtil.processUpPackageJsonFiles(project, fileOrDir, (Processor<? super VirtualFile>)((Processor)packageJson -> {
            PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
            for (JsTestRunConfigurationProducer producer : (List)allProducers.getValue()) {
                if (!JSTestRunnerManager.isAnyPackageDeclared(data, producer.getTestRunnerPackageDescriptor()) || JSTestRunnerManager.isAnyPackageDeclared(data, producer.getStopPackageDescriptor())) continue;
                producers.add(producer);
            }
            return true;
        }));
        HashSet hashSet = producers;
        if (hashSet == null) {
            JSTestRunnerManager.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static boolean isAnyPackageDeclared(@NotNull PackageJsonData data, @NotNull NodePackageDescriptor pkgDescriptor) {
        if (data == null) {
            JSTestRunnerManager.$$$reportNull$$$0(5);
        }
        if (pkgDescriptor == null) {
            JSTestRunnerManager.$$$reportNull$$$0(6);
        }
        for (String packageName : pkgDescriptor.getPackageNames()) {
            String dependency;
            if (!data.isDependencyOfAnyType(packageName) || (dependency = pkgDescriptor.getDependencyByPackageName(packageName)) != null && !data.isDependencyOfAnyType(dependency)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Set<JsTestRunConfigurationProducer<?>> findTestRunnerAsIndirectDependency(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull NotNullLazyValue<List<JsTestRunConfigurationProducer<?>>> allProducers) {
        if (project == null) {
            JSTestRunnerManager.$$$reportNull$$$0(7);
        }
        if (fileOrDir == null) {
            JSTestRunnerManager.$$$reportNull$$$0(8);
        }
        if (allProducers == null) {
            JSTestRunnerManager.$$$reportNull$$$0(9);
        }
        HashSet result2 = new HashSet(1);
        NodeModuleSearchUtil.processUpNodeModulesDirs(project, fileOrDir, (Processor<? super VirtualFile>)((Processor)nodeModulesDir -> {
            for (JsTestRunConfigurationProducer producer : (List)allProducers.getValue()) {
                if (!JSTestRunnerManager.isAnyPackageInstalled(nodeModulesDir, producer.getTestRunnerPackageDescriptor()) || JSTestRunnerManager.isAnyPackageInstalled(nodeModulesDir, producer.getStopPackageDescriptor())) continue;
                result2.add(producer);
            }
            return true;
        }));
        HashSet hashSet = result2;
        if (hashSet == null) {
            JSTestRunnerManager.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    private static boolean isAnyPackageInstalled(@NotNull VirtualFile nodeModulesDir, @NotNull NodePackageDescriptor packageDescriptor) {
        if (nodeModulesDir == null) {
            JSTestRunnerManager.$$$reportNull$$$0(11);
        }
        if (packageDescriptor == null) {
            JSTestRunnerManager.$$$reportNull$$$0(12);
        }
        for (String packageName : packageDescriptor.getPackageNames()) {
            if (!JSTestRunnerManager.isPackageInstalled(nodeModulesDir, packageName)) continue;
            String dependency = packageDescriptor.getDependencyByPackageName(packageName);
            return dependency == null || JSTestRunnerManager.isPackageInstalled(nodeModulesDir, dependency);
        }
        return false;
    }

    private static boolean isPackageInstalled(@NotNull VirtualFile nodeModulesDir, @NotNull String packageName) {
        VirtualFile packageDir;
        if (nodeModulesDir == null) {
            JSTestRunnerManager.$$$reportNull$$$0(13);
        }
        if (packageName == null) {
            JSTestRunnerManager.$$$reportNull$$$0(14);
        }
        return (packageDir = nodeModulesDir.findFileByRelativePath(packageName)) != null && packageDir.isDirectory() && packageDir.isValid();
    }

    public boolean isTestRunnerAvailableFor(@NotNull PsiElement element) {
        if (element == null) {
            JSTestRunnerManager.$$$reportNull$$$0(15);
        }
        return !this.findProducers(element).isEmpty();
    }

    @NotNull
    public Set<JsTestRunConfigurationProducer<?>> findProducers(@NotNull PsiElement psiElement) {
        PsiDirectory directory;
        if (psiElement == null) {
            JSTestRunnerManager.$$$reportNull$$$0(16);
        }
        if (psiElement instanceof PsiDirectory) {
            directory = (PsiDirectory)psiElement;
        } else {
            PsiFile file2 = psiElement.getContainingFile();
            PsiDirectory psiDirectory = directory = file2 != null ? file2.getContainingDirectory() : null;
        }
        if (directory == null) {
            Set<JsTestRunConfigurationProducer<?>> set = Collections.emptySet();
            if (set == null) {
                JSTestRunnerManager.$$$reportNull$$$0(17);
            }
            return set;
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)directory, KEY, () -> {
            Project project = directory.getProject();
            Set<JsTestRunConfigurationProducer<?>> producers = JSTestRunnerManager.findProducers(project, PsiUtilCore.getVirtualFile((PsiElement)directory));
            return new CachedValueProvider.Result(producers, new Object[]{NodeModulesDirectoryManager.getInstance(project).getNodeModulesDirChangeTracker(), PackageJsonFileManager.getInstance(project).getModificationTracker()});
        });
        if (set == null) {
            JSTestRunnerManager.$$$reportNull$$$0(18);
        }
        return set;
    }

    @NotNull
    private static Set<JsTestRunConfigurationProducer<?>> findProducers(@NotNull Project project, @Nullable VirtualFile fileOrDir) {
        NotNullLazyValue allProducers;
        if (project == null) {
            JSTestRunnerManager.$$$reportNull$$$0(19);
        }
        Set<JsTestRunConfigurationProducer<?>> producers = Collections.emptySet();
        if (fileOrDir != null && (producers = JSTestRunnerManager.findTestRunnerAsDirectDependency(project, fileOrDir, allProducers = NotNullLazyValue.createValue(JSTestRunnerManager::getAllProducers))).isEmpty()) {
            producers = JSTestRunnerManager.findTestRunnerAsIndirectDependency(project, fileOrDir, allProducers);
        }
        Set<JsTestRunConfigurationProducer<?>> set = producers;
        if (set == null) {
            JSTestRunnerManager.$$$reportNull$$$0(20);
        }
        return set;
    }

    @NotNull
    static List<JsTestRunConfigurationProducer<?>> getAllProducers() {
        List producers;
        List list2 = producers = ContainerUtil.filterIsInstance((Collection)RunConfigurationProducer.EP_NAME.getExtensionList(), JsTestRunConfigurationProducer.class);
        if (list2 == null) {
            JSTestRunnerManager.$$$reportNull$$$0(21);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/JSTestRunnerManager";
                break;
            }
            case 1: 
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allProducers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgDescriptor";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDescriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/JSTestRunnerManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestRunnerAsDirectDependency";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestRunnerAsIndirectDependency";
                break;
            }
            case 17: 
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findProducers";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProducers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTestRunnerAsDirectDependency";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAnyPackageDeclared";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findTestRunnerAsIndirectDependency";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAnyPackageInstalled";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPackageInstalled";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isTestRunnerAvailableFor";
                break;
            }
            case 16: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findProducers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

