/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.javascript.testFramework.navigation.JSTestLocationProvider;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.javascript.testing.JSTestFailedLineManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestConsoleProperties
extends SMTRunnerConsoleProperties
implements SMCustomMessagesParsing {
    private final CompositeFilter myStackTraceFilter;

    public JsTestConsoleProperties(@NotNull RunConfiguration config2, @NotNull String testFrameworkName, @NotNull Executor executor) {
        if (config2 == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(0);
        }
        if (testFrameworkName == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(2);
        }
        super(config2, testFrameworkName, executor);
        this.myStackTraceFilter = new CompositeFilter(config2.getProject());
    }

    public void addStackTraceFilter(@NotNull Filter filter) {
        if (filter == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(3);
        }
        this.myStackTraceFilter.addFilter(filter);
    }

    @NotNull
    public List<Filter> getStackTrackFilters() {
        List list2 = this.myStackTraceFilter.getFilters();
        if (list2 == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Nullable
    public Navigatable getErrorNavigatable(@NotNull Location<?> location, @NotNull String stacktrace) {
        if (location == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(5);
        }
        if (stacktrace == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(6);
        }
        if (this.myStackTraceFilter.isEmpty()) {
            return null;
        }
        JSTestFailedLineManager manager2 = JSTestFailedLineManager.getInstance(this.getProject());
        JSTestFailedLineManager.ResolveResult result2 = manager2.findFailedLineForTest(location.getPsiElement());
        return result2 != null ? result2.getDescriptor() : null;
    }

    public OutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
        if (testFrameworkName == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(7);
        }
        if (consoleProperties == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(8);
        }
        return new JSTestEventsConverter((JsTestConsoleProperties)consoleProperties);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/JsTestConsoleProperties";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktrace";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/JsTestConsoleProperties";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackTrackFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addStackTraceFilter";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getErrorNavigatable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTestEventsConverter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JSTestEventsConverter
    extends OutputToGeneralTestEventsConverter {
        private final Project myProject;
        private final Filter myStackTraceFilter;
        private final boolean myLocationUrlStartedWithTestFilePath;

        protected JSTestEventsConverter(@NotNull JsTestConsoleProperties consoleProperties) {
            if (consoleProperties == null) {
                JSTestEventsConverter.$$$reportNull$$$0(0);
            }
            super(consoleProperties.getTestFrameworkName(), false, false, !consoleProperties.isIdBasedTestTree());
            this.myProject = consoleProperties.getProject();
            this.myStackTraceFilter = consoleProperties.myStackTraceFilter;
            if (consoleProperties.getTestLocator() instanceof JSTestLocationProvider) {
                JSTestLocationProvider provider = (JSTestLocationProvider)consoleProperties.getTestLocator();
                this.myLocationUrlStartedWithTestFilePath = provider.isLocationUrlStartedWithTestFilePath();
            } else {
                this.myLocationUrlStartedWithTestFilePath = false;
            }
        }

        @Deprecated
        public JSTestEventsConverter(String testFrameworkName, boolean stdinEnabled) {
            super(testFrameworkName, false, false, false);
            this.myProject = null;
            this.myStackTraceFilter = null;
            this.myLocationUrlStartedWithTestFilePath = false;
        }

        public void setProcessor(@Nullable GeneralTestEventsProcessor processor) {
            if (processor != null && this.myProject != null && this.myStackTraceFilter != null) {
                JSTestFailedLineManager.getInstance(this.myProject).onTestConfigurationStarted(processor, this.myStackTraceFilter);
                if (this.myLocationUrlStartedWithTestFilePath) {
                    this.registerLocationUrlWithoutTestFilePath(processor);
                }
            }
            super.setProcessor(processor);
        }

        private void registerLocationUrlWithoutTestFilePath(@NotNull GeneralTestEventsProcessor processor) {
            if (processor == null) {
                JSTestEventsConverter.$$$reportNull$$$0(1);
            }
            processor.addEventsListener((SMTRunnerEventsListener)new SMTRunnerEventsAdapter(){

                public void onTestFinished(@NotNull SMTestProxy test) {
                    if (test == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (test.isPassed()) {
                        this.registerLocationUrlWithoutTestFilePath(test);
                    }
                }

                public void onTestFailed(@NotNull SMTestProxy test) {
                    if (test == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.registerLocationUrlWithoutTestFilePath(test);
                }

                public void onTestIgnored(@NotNull SMTestProxy test) {
                    if (test == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    this.registerLocationUrlWithoutTestFilePath(test);
                }

                public void onSuiteFinished(@NotNull SMTestProxy suite) {
                    if (suite == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    this.registerLocationUrlWithoutTestFilePath(suite);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "test";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "suite";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/javascript/testing/JsTestConsoleProperties$JSTestEventsConverter$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTestFinished";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTestFailed";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTestIgnored";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onSuiteFinished";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private void registerLocationUrlWithoutTestFilePath(@NotNull SMTestProxy test) {
            String locationUrlWithoutTestFilePath;
            if (test == null) {
                JSTestEventsConverter.$$$reportNull$$$0(2);
            }
            if ((locationUrlWithoutTestFilePath = JSTestEventsConverter.removeTestFilePath(test.getLocationUrl())) != null) {
                TestStateStorage storage = TestStateStorage.getInstance((Project)this.myProject);
                storage.writeState(locationUrlWithoutTestFilePath, new TestStateStorage.Record(test.getMagnitude(), new Date(), 0L, -1, null, null, null));
            }
        }

        @Nullable
        private static String removeTestFilePath(@Nullable String locationUrl) {
            String path;
            List list2;
            String protocol;
            if (locationUrl != null && ("test".equals(protocol = VirtualFileManager.extractProtocol((String)locationUrl)) || "suite".equals(protocol)) && (list2 = EscapeUtils.split((String)(path = VirtualFileManager.extractPath((String)locationUrl)), (char)'.')).size() > 1) {
                return protocol + "://" + EscapeUtils.join(list2.subList(1, list2.size()), (char)'.');
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleProperties";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "test";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/testing/JsTestConsoleProperties$JSTestEventsConverter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerLocationUrlWithoutTestFilePath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

