/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.util.PlatformUtils;
import org.jetbrains.annotations.NotNull;

final class WebStormDiagramsConfigurator
implements ActionConfigurationCustomizer {
    private static final String[] REMOVE_ACTIONS = new String[]{"Uml.ShowDiff", "UML.ShowChanges"};

    WebStormDiagramsConfigurator() {
        if (!PlatformUtils.isWebStorm()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    public void customize(@NotNull ActionManager actionManager) {
        if (actionManager == null) {
            WebStormDiagramsConfigurator.$$$reportNull$$$0(0);
        }
        AbbreviationManager abbreviationManager = AbbreviationManager.getInstance();
        for (String actionId : REMOVE_ACTIONS) {
            for (String abbreviation : abbreviationManager.getAbbreviations(actionId)) {
                abbreviationManager.remove(abbreviation, actionId);
            }
        }
        for (String actionId : REMOVE_ACTIONS) {
            ActionGroup group;
            AnAction action = actionManager.getAction(actionId);
            if (action == null) continue;
            if (actionManager.isGroup(actionId) && (group = (ActionGroup)action) instanceof DefaultActionGroup) {
                ((DefaultActionGroup)group).removeAll();
            }
            actionManager.unregisterAction(actionId);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/lang/javascript/WebStormDiagramsConfigurator", "customize"));
    }
}

