/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.types.OverloadStrictness;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypePredicate;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.typescript.TypeScriptResolveHelper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReferenceExpressionResolver
extends JSReferenceExpressionResolver
implements ResolveCache.PolyVariantResolver<JSReferenceExpressionImpl> {
    public TypeScriptReferenceExpressionResolver(JSReferenceExpressionImpl expression, boolean ignorePerformanceLimits) {
        super(expression, ignorePerformanceLimits);
    }

    @Override
    public ResolveResult @NotNull [] resolve(@NotNull JSReferenceExpressionImpl expression, boolean incompleteCode) {
        JSCallLikeExpression callLikeExpression;
        if (expression == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(0);
        }
        if (this.myReferencedName == null || Registry.is((String)"typescript.disable.ide.resolve")) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(1);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiElement currentParent = JSResolveUtil.getTopReferenceParent(this.myParent);
        if (JSResolveUtil.isSelfReference(currentParent, (PsiElement)this.myRef)) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult(currentParent)};
            if (resolveResultArray == null) {
                TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }
        if (currentParent instanceof TypeScriptTypePredicate) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult((PsiElement)((TypeScriptTypePredicate)currentParent).getParameterMatchName())};
            if (resolveResultArray == null) {
                TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        if (!incompleteCode && (callLikeExpression = TypeScriptSignatureChooser.getCallLikeExpression((PsiElement)expression)) != null) {
            ResolveResult[] results = expression.multiResolve(true);
            if (this.myQualifier instanceof JSSuperExpression && !TypeScriptUtil.isValidSuperQualifier(this.myQualifier)) {
                if (results == null) {
                    TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(4);
                }
                return results;
            }
            ResolveResult[] resolveResultArray = new JSTypeSignatureChooser((JSCallItem)callLikeExpression).chooseOverload(results, OverloadStrictness.UNIQUE);
            if (resolveResultArray == null) {
                TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(5);
            }
            return resolveResultArray;
        }
        Object[] resolveResults = this.doResolveReference(incompleteCode);
        if (currentParent instanceof TypeScriptModule) {
            ResolveResult[] resolveResultArray = (ResolveResult[])ArrayUtil.mergeArrays((Object[])resolveResults, (Object[])new ResolveResult[]{new JSResolveResult(currentParent)});
            if (resolveResultArray == null) {
                TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(6);
            }
            return resolveResultArray;
        }
        if (this.isDummyResolve((ResolveResult[])resolveResults)) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult((PsiElement)this.myRef)};
            if (resolveResultArray == null) {
                TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(7);
            }
            return resolveResultArray;
        }
        if (resolveResults == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(8);
        }
        return resolveResults;
    }

    private boolean isDummyResolve(ResolveResult[] results) {
        if (this.undefinedResolve(results)) {
            return true;
        }
        if (results != null && results.length != 0) {
            return false;
        }
        return this.isGlobalThis();
    }

    private ResolveResult[] doResolveReference(boolean incompleteCode) {
        ResolveResult[] resultsFromProviders;
        assert (this.myReferencedName != null);
        TypeScriptResolveProcessor<ResolveResultSink> localProcessor = new TypeScriptResolveProcessor<ResolveResultSink>(new ResolveResultSink((PsiElement)this.myRef, this.myReferencedName, false, incompleteCode), this.myContainingFile, (PsiElement)this.myRef);
        boolean isTypeContext = JSResolveUtil.isExprInTypeContext(this.myRef);
        boolean excludeJSLibsForIndices = false;
        if (!(!this.myUnqualifiedOrLocalResolve || this.myQualifier instanceof JSThisExpression && !TypeScriptUtil.isValidThisQualifier(this.myQualifier) || this.myQualifier instanceof JSSuperExpression && !TypeScriptUtil.isValidSuperQualifier(this.myQualifier))) {
            localProcessor.setToProcessHierarchy(true);
            boolean strictTypeContext = localProcessor.isStrictTypeContext();
            if (strictTypeContext) {
                this.processLocalDeclarationsByExportScopes(localProcessor, this.myRef);
            } else {
                this.processLocalDeclarations(localProcessor, (PsiElement)this.myRef, false, null);
            }
            ResolveResult[] results = localProcessor.getResultsAsResolveResults();
            PsiElement complete = ((ResolveResultSink)localProcessor.getResultSink()).getCompleteResult();
            if (complete != null) {
                return results;
            }
            if (!(this.myQualifier instanceof JSThisExpression) && !(this.myQualifier instanceof JSSuperExpression)) {
                TypeScriptResolveHelper.processGlobalThings(localProcessor, ResolveState.initial(), (PsiElement)this.myRef);
            }
            return localProcessor.getResultsAsResolveResults();
        }
        localProcessor.setTypeContext(isTypeContext);
        JSTypeEvaluator.evaluateTypes(this.myQualifier, this.myContainingFile, localProcessor);
        ResolveResultSink resultSink = (ResolveResultSink)localProcessor.getResultSink();
        JSResolveResult candidateResult = resultSink.getCandidateResult();
        if (localProcessor.resolved.isSuitableForReferenceResolve() || resultSink.getCompleteResult() != null || candidateResult != null && candidateResult.getResolveProblemKey() != null) {
            ResolveResult[] results = localProcessor.getResultsAsResolveResults();
            if (results.length > 0 || localProcessor.resolved != QualifiedItemProcessor.TypeResolveState.ResolvedAllowsExtras) {
                return results;
            }
            excludeJSLibsForIndices = true;
        }
        if ((resultsFromProviders = this.resolveFromProviders()) != null) {
            return resultsFromProviders;
        }
        return this.resolveFromIndices(localProcessor, excludeJSLibsForIndices, isTypeContext);
    }

    private void processLocalDeclarationsByExportScopes(@NotNull TypeScriptResolveProcessor<ResolveResultSink> localProcessor, @NotNull JSElement startElement) {
        if (localProcessor == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(9);
        }
        if (startElement == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(10);
        }
        JSElement scope = startElement;
        while (scope != null) {
            if (!(scope instanceof JSExpressionCodeFragment) && TypeScriptReferenceExpressionResolver.isExportedScope((PsiElement)scope)) {
                if (!scope.processDeclarations(localProcessor, ResolveState.initial(), (PsiElement)scope, (PsiElement)this.myRef)) {
                    break;
                }
            } else {
                JSElement context = scope;
                if ((scope = TypeScriptReferenceExpressionResolver.getExportedScopeOrContext((PsiElement)scope)) instanceof JSExpressionCodeFragment) {
                    scope = null;
                }
                this.processLocalDeclarations(localProcessor, (PsiElement)context, true, (PsiElement)scope);
                if (((ResolveResultSink)localProcessor.getResultSink()).getCompleteResult() != null) break;
            }
            scope = TypeScriptReferenceExpressionResolver.getExportedScopeOrContext((PsiElement)scope);
        }
    }

    @Nullable
    private static PsiElement getExportedScopeOrContext(@Nullable PsiElement stopAt) {
        if (stopAt == null) {
            return null;
        }
        PsiElement stopElement = JSResolveUtil.getContext(stopAt);
        if (stopElement != null) {
            return stopElement;
        }
        if (stopAt instanceof PsiFile) {
            return null;
        }
        NavigatablePsiElement type = TypeScriptReferenceExpressionResolver.getParentCandidate(stopAt);
        while (type != null && !TypeScriptReferenceExpressionResolver.isExportedScope((PsiElement)type)) {
            if (TypeScriptReferenceExpressionResolver.isExportedScope(type.getContext())) {
                return type;
            }
            type = TypeScriptReferenceExpressionResolver.getParentCandidate((PsiElement)type);
        }
        return type;
    }

    @Nullable
    private static NavigatablePsiElement getParentCandidate(@Nullable PsiElement stopAt) {
        return (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)stopAt, (Class[])new Class[]{JSStatement.class, JSExecutionScope.class, JSClass.class, PsiFile.class});
    }

    private static boolean isExportedScope(@Nullable PsiElement type) {
        return type instanceof TypeScriptModule || type instanceof PsiFile || ES6PsiUtil.isEmbeddedModule(type);
    }

    private void processLocalDeclarations(@NotNull TypeScriptResolveProcessor<ResolveResultSink> localProcessor, @NotNull PsiElement context, boolean strictTypeContext, @Nullable PsiElement stopAt) {
        if (localProcessor == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(11);
        }
        if (context == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(12);
        }
        JSReferenceExpressionImpl.doProcessLocalDeclarations(context, this.myQualifier, localProcessor, false, false, strictTypeContext, stopAt);
    }

    @Override
    @Nullable
    protected String adjustReferencedName(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(13);
        }
        return TypeScriptReferenceExpressionResolver.adjustPrimitiveTypes(ref);
    }

    @Nullable
    public static String adjustPrimitiveTypes(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(14);
        }
        String referenceName = ref.getReferenceName();
        if (JSResolveUtil.isExprInStrictTypeContext(ref) && ref.getQualifier() == null) {
            if ("boolean".equals(referenceName)) {
                referenceName = "Boolean";
            } else if ("bigint".equals(referenceName)) {
                referenceName = "BigInt";
            } else if ("string".equals(referenceName) || "number".equals(referenceName)) {
                referenceName = StringUtil.capitalize((String)referenceName);
            }
        }
        return referenceName;
    }

    @Override
    protected boolean prepareProcessor(WalkUpResolveProcessor processor, @NotNull SinkResolveProcessor<ResolveResultSink> localProcessor) {
        if (localProcessor == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(15);
        }
        if (!localProcessor.isEncounteredDynamicClasses() || this.myQualifier instanceof JSThisExpression) {
            processor.allowPartialResults();
        } else {
            processor.setAddOnlyCompleteMatches();
        }
        processor.setSkipDefinitions(false);
        return true;
    }

    @Override
    protected ResolveResult[] getResultsForDefinition() {
        JSTypeSource source;
        JSType type;
        if (this.myQualifier == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        if (this.myQualifier instanceof JSReferenceExpression && (type = JSResolveUtil.getExpressionJSType(this.myQualifier)) != null && !(type instanceof JSAnyType) && (source = type.getSource()) != null && source.isStrict()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        return new ResolveResult[]{new JSResolveResult(this.myParent)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceExpressionResolver";
                break;
            }
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceExpressionResolver";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processLocalDeclarationsByExportScopes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processLocalDeclarations";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "adjustReferencedName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "adjustPrimitiveTypes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prepareProcessor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

