/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.editor.JSEditorOptions;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text) {
        if (!JSEditorOptions.getInstance().ESCAPE_PASTED_TEXT) {
            return null;
        }
        if (!file2.isPhysical() || startOffsets.length > 1 || endOffsets.length > 1) {
            return null;
        }
        int selectionStart = startOffsets[0];
        int selectionEnd = endOffsets[0];
        JSLiteralExpression literalExpression = JSStringLiteralCopyPasteProcessor.getSingleElementFromSelectionOrNull(file2, selectionStart, selectionEnd);
        if (literalExpression == null) {
            return null;
        }
        return JSStringUtil.unescapeSimpleStringChars(text);
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file2, Editor editor, String text, RawText rawText) {
        int selectionEnd;
        if (!JSEditorOptions.getInstance().ESCAPE_PASTED_TEXT) {
            String string = text;
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (!file2.isPhysical()) {
            String string = text;
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        JSLiteralExpression literalExpression = JSStringLiteralCopyPasteProcessor.getSingleElementFromSelectionOrNull(file2, selectionStart, selectionEnd = selectionModel.getSelectionEnd());
        if (literalExpression == null || literalExpression.getTextOffset() == selectionStart) {
            String string = text;
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        return JSStringLiteralCopyPasteProcessor.getPastedText(text, literalExpression, rawText);
    }

    @NotNull
    private static String getPastedText(String text, @NotNull JSLiteralExpression literalExpression, RawText rawText) {
        if (literalExpression == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        String literalText = literalExpression.getText();
        boolean isStringTemplate = literalExpression instanceof JSStringTemplateExpression;
        boolean isSlashQuotedDestination = !isStringTemplate && literalText.contains("\\\n");
        boolean destinationAcceptsNewlines = isStringTemplate || JSStringLiteralCopyPasteProcessor.isCoffeeScript(literalExpression) || isSlashQuotedDestination || rawText != null && StringUtil.contains((CharSequence)rawText.rawText, (CharSequence)"\\\n");
        char quote = literalText.charAt(0);
        if (StringUtil.containsChar((String)text, (char)quote) && !isStringTemplate && JSStringLiteralCopyPasteProcessor.isValidStringConcatenation((PsiElement)literalExpression, quote + (isSlashQuotedDestination ? StringUtil.trimEnd((String)text, (String)"\\") : text) + quote)) {
            String string = text;
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (rawText != null && rawText.rawText != null) {
            if (isStringTemplate) {
                String string = JSStringUtil.escapeTemplateStringChars(rawText.rawText, false, false, (PsiElement)literalExpression);
                if (string == null) {
                    JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = JSStringLiteralCopyPasteProcessor.escapeQuote(rawText.rawText, quote, !destinationAcceptsNewlines);
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (isStringTemplate) {
            String string = JSStringUtil.escapeTemplateStringChars(text, true, true, (PsiElement)literalExpression);
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (JSStringLiteralCopyPasteProcessor.isCoffeeScript(literalExpression)) {
            StringBuilder buffer = new StringBuilder();
            JSStringUtil.escapeSimpleStringChars(text, quote, false, true, false, buffer);
            String string = buffer.toString();
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(8);
            }
            return string;
        }
        StringBuilder buffer = new StringBuilder(text.length());
        String lineTail = isSlashQuotedDestination ? "\\\n" : JSStringLiteralCopyPasteProcessor.getTail(quote, (PsiElement)literalExpression);
        String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            JSStringUtil.escapeSimpleStringChars(line, quote, !destinationAcceptsNewlines, true, false, buffer);
            if (i == lines.length - 1) continue;
            buffer.append(lineTail);
        }
        if (text.endsWith("\n")) {
            buffer.append("\\n");
        }
        String string = buffer.toString();
        if (string == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    private static JSLiteralExpression getSingleElementFromSelectionOrNull(@NotNull PsiFile file2, int start, int end) {
        JSLiteralExpression atEnd;
        JSLiteralExpression atStart;
        if (file2 == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(10);
        }
        return (atStart = (JSLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(start), JSLiteralExpression.class)) == (atEnd = (JSLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(end), JSLiteralExpression.class)) && JSStringLiteralCopyPasteProcessor.containedInStringRange(atStart, new TextRange(start, end)) ? atStart : null;
    }

    private static boolean containedInStringRange(@Nullable JSLiteralExpression atStart, TextRange range) {
        if (atStart == null || !atStart.isQuotedLiteral() || !atStart.getTextRange().contains(range)) {
            return false;
        }
        if (atStart instanceof JSStringTemplateExpression) {
            return JSStringLiteralCopyPasteProcessor.isInStringRange((JSStringTemplateExpression)atStart, range);
        }
        return true;
    }

    private static boolean isValidStringConcatenation(@NotNull PsiElement context, @NotNull String text) {
        TextRange range;
        JSExpression expression;
        PsiFile file2;
        if (context == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(11);
        }
        if (text == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(12);
        }
        try {
            file2 = JSChangeUtil.createJSFileFromText(context.getProject(), text, DialectDetector.languageDialectOfElement(context));
        }
        catch (Exception e) {
            return false;
        }
        PsiElement firstStatement = (PsiElement)ArrayUtil.getFirstElement((Object[])file2.getChildren());
        return firstStatement instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)firstStatement).getExpression()) instanceof JSBinaryExpression && JSTokenTypes.PLUS == ((JSBinaryExpression)expression).getOperationSign() && (range = expression.getTextRange()).getStartOffset() == 0 && range.getEndOffset() == file2.getTextLength() && PsiTreeUtil.getDeepestFirst((PsiElement)expression).getParent() instanceof JSLiteralExpression && PsiTreeUtil.getDeepestLast((PsiElement)expression).getParent() instanceof JSLiteralExpression;
    }

    @NotNull
    private static String getTail(char quote, @NotNull PsiElement context) {
        if (context == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(13);
        }
        CommonCodeStyleSettings commonSettings = CodeStyle.getLanguageSettings((PsiFile)context.getContainingFile(), (Language)context.getLanguage());
        String string = "\\n" + quote + (commonSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE ? "\n+" : "+\n") + quote;
        if (string == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static boolean isCoffeeScript(JSLiteralExpression literalExpression) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)literalExpression);
        return holder != null && holder.isCoffeeScript;
    }

    public static boolean isInStringRange(@NotNull JSStringTemplateExpression templateExpression, int offset) {
        if (templateExpression == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(15);
        }
        return JSStringLiteralCopyPasteProcessor.isInStringRange(templateExpression, TextRange.from((int)offset, (int)0));
    }

    public static boolean isInStringRange(@NotNull JSStringTemplateExpression templateExpression, @NotNull TextRange range) {
        if (templateExpression == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(16);
        }
        if (range == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(17);
        }
        TextRange relativeRange = range.shiftLeft(templateExpression.getTextRange().getStartOffset());
        for (TextRange textRange : templateExpression.getStringRangesWithEmpty()) {
            if (!textRange.contains(relativeRange)) continue;
            return true;
        }
        return false;
    }

    private static String escapeQuote(String text, char quote, boolean escapeNewlines) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (escapeNewlines && c == '\n') {
                result2.append('\\').append('n');
                continue;
            }
            if (c == quote && (i == 0 || text.charAt(i - 1) != '\\')) {
                result2.append('\\').append(quote);
                continue;
            }
            result2.append(c);
        }
        return result2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editing/JSStringLiteralCopyPasteProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateExpression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editing/JSStringLiteralCopyPasteProcessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPastedText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTail";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPastedText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSingleElementFromSelectionOrNull";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isValidStringConcatenation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTail";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isInStringRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

