/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions.nullPropagation;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThenableElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNullPropagationIntention
extends JavaScriptIntention
implements LowPriorityAction {
    private String myText = JavaScriptBundle.message((String)"javascript.intention.opt.chain.chain.only", (Object[])new Object[0]);

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        boolean isThen;
        if (project == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(1);
        }
        Trinity<JSExpression, JSExpression, JSExpression> item = JSNullPropagationIntention.findItem(element);
        assert (item != null);
        JSElement parent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSThenableElement.class, JSBinaryExpression.class});
        JSExpression qualifier = JSNullPropagationIntention.getQualifierOf((JSExpression)item.first, (JSExpression)item.second);
        boolean shouldUseConditional = JSNullPropagationIntention.shouldUseConditional((JSExpression)item.first);
        String coalescingSign = shouldUseConditional ? " || " : " ?? ";
        boolean bl = isThen = parent instanceof JSThenableElement && qualifier != null && PsiTreeUtil.isAncestor((PsiElement)((JSThenableElement)parent).getThen(), (PsiElement)qualifier, (boolean)false);
        if (qualifier == null || EquivalenceChecker.expressionsAreEquivalent((JSExpression)item.first, (JSExpression)item.second)) {
            ((JSExpression)item.second).replace(JSPsiElementFactory.createJSExpression(((JSExpression)item.second).getText() + coalescingSign + ((JSExpression)item.third).getText(), element));
        } else {
            JSChangeUtil.setElvisAfter((PsiElement)qualifier);
            if (!JSSymbolUtil.isUndefinedExpression((JSExpression)item.third) && item.third != null) {
                ((JSExpression)item.second).replace(JSPsiElementFactory.createJSExpression(((JSExpression)item.second).getText() + " ?? " + ((JSExpression)item.third).getText(), element));
            }
        }
        if (parent instanceof JSThenableElement) {
            JSSourceElement[] items;
            JSElement then = ((JSThenableElement)parent).getThen();
            JSElement anElse = ((JSThenableElement)parent).getElse();
            if (!isThen && anElse == null) {
                parent.delete();
                return;
            }
            PsiElement replaced = parent.replace(isThen ? (PsiElement)Objects.requireNonNull(then) : (PsiElement)Objects.requireNonNull(anElse));
            if (replaced instanceof JSBlockStatement && (items = ((JSBlockStatement)replaced).getStatementListItems()).length == 1) {
                replaced.replace((PsiElement)items[0]);
            }
        }
    }

    @Nullable
    private static Trinity<JSExpression, JSExpression, JSExpression> findItem(@NotNull PsiElement element) {
        JSElement elseBranch;
        JSElement item;
        if (element == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(2);
        }
        if (!((item = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSThenableElement.class, JSBinaryExpression.class})) instanceof JSThenableElement)) {
            return null;
        }
        JSExpression condition = ((JSThenableElement)item).getCondition();
        JSReferenceExpression expressionInCondition = JSNullPropagationIntention.getExpressionInCondition(condition);
        if (expressionInCondition == null) {
            return null;
        }
        JSElement thenBranch = ((JSThenableElement)item).getThen();
        Pair<JSExpression, JSExpression> expression = JSNullPropagationIntention.findNonNullableExpression(condition, thenBranch, elseBranch = JSNullPropagationIntention.getElse(item));
        if (expression == null) {
            return null;
        }
        if (JSNullPropagationIntention.getQualifierOf((JSExpression)expressionInCondition, (JSExpression)expression.first) != null || elseBranch instanceof JSVariable) {
            return Trinity.create((Object)expressionInCondition, (Object)expression.first, (Object)expression.second);
        }
        return null;
    }

    @Nullable
    private static JSElement getElse(@NotNull JSElement item) {
        JSElement elseBranch;
        if (item == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(3);
        }
        if ((elseBranch = ((JSThenableElement)item).getElse()) != null) {
            return elseBranch;
        }
        JSVarStatement varStatement = (JSVarStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)item, JSStatement.class, (boolean)false), JSVarStatement.class);
        if (varStatement == null) {
            return null;
        }
        JSInitializerOwner[] declarations = varStatement.getDeclarations();
        if (declarations.length == 1 && declarations[0] instanceof JSVariable) {
            elseBranch = declarations[0];
        }
        return elseBranch;
    }

    @Nullable
    private static JSExpression getQualifierOf(@Nullable JSExpression condition, @Nullable JSExpression expression) {
        if (condition == null || expression == null) {
            return null;
        }
        if (!(expression instanceof JSElvisOwner)) {
            return null;
        }
        JSExpression qualifier = JSPsiImplUtils.getElvisQualifier((JSElvisOwner)expression);
        if (qualifier == null && EquivalenceChecker.expressionsAreEquivalent(expression, condition)) {
            return expression;
        }
        while (qualifier != null) {
            if (EquivalenceChecker.expressionsAreEquivalent(qualifier, condition)) {
                return qualifier;
            }
            if (!(qualifier instanceof JSElvisOwner)) {
                return null;
            }
            qualifier = JSPsiImplUtils.getElvisQualifier((JSElvisOwner)qualifier);
        }
        return null;
    }

    @Nullable
    private static JSExpression unwrapItem(@Nullable JSElement element, @NotNull Ref<String> nameRef) {
        JSInitializerOwner[] declarations;
        if (nameRef == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(4);
        }
        boolean hadBlock = false;
        if (element instanceof JSBlockStatement) {
            JSSourceElement[] items = ((JSBlockStatement)element).getStatementListItems();
            if (items.length != 1 || !(items[0] instanceof JSStatement)) {
                return null;
            }
            element = items[0];
            hadBlock = true;
        }
        String name = (String)nameRef.get();
        if (element instanceof JSExpressionStatement && (element = ((JSExpressionStatement)element).getExpression()) instanceof JSAssignmentExpression) {
            JSReferenceExpression leftRef;
            JSExpression operand = ((JSAssignmentExpression)element).getLOperand();
            if (operand instanceof JSDefinitionExpression) {
                operand = ((JSDefinitionExpression)operand).getExpression();
            }
            if ((leftRef = (JSReferenceExpression)ObjectUtils.tryCast((Object)operand, JSReferenceExpression.class)) != null) {
                String leftName = leftRef.getReferenceName();
                if (name == null || name.equals(leftName)) {
                    element = ((JSAssignmentExpression)element).getROperand();
                }
                if (name == null) {
                    nameRef.set((Object)leftName);
                }
            }
        }
        if (element instanceof JSVarStatement && (declarations = ((JSVarStatement)element).getDeclarations()).length == 1 && declarations[0] instanceof JSVariable) {
            element = declarations[0];
        }
        if (element instanceof JSVariable) {
            JSVarStatement statement = ((JSVariable)element).getStatement();
            if (statement == null || hadBlock && statement.getVarKeyword() != JSVarStatement.VarKeyword.VAR) {
                return null;
            }
            String leftName = element.getName();
            if (name == null || name.equals(leftName)) {
                element = ((JSVariable)element).getInitializer();
            }
            if (name == null) {
                nameRef.set((Object)leftName);
            }
        }
        return (JSExpression)ObjectUtils.tryCast((Object)element, JSExpression.class);
    }

    @Nullable
    private static Pair<JSExpression, JSExpression> findNonNullableExpression(@Nullable JSExpression condition, @Nullable JSElement then, @Nullable JSElement anElse) {
        JSElement nonNullablePart;
        JSElement nullablePart;
        JSReferenceExpression expressionInCondition = JSNullPropagationIntention.getExpressionInCondition(condition);
        if (expressionInCondition == null) {
            return null;
        }
        String name = expressionInCondition.getReferenceName();
        if (name == null) {
            return null;
        }
        IElementType sign = condition instanceof JSBinaryExpression ? ((JSBinaryExpression)condition).getOperationSign() : null;
        boolean truthy = condition instanceof JSReferenceExpression || sign == JSTokenTypes.NEQEQ || sign == JSTokenTypes.NE;
        JSElement jSElement = nullablePart = truthy ? anElse : then;
        if (nullablePart instanceof JSVariable) {
            return null;
        }
        JSElement jSElement2 = nonNullablePart = truthy ? then : anElse;
        if (nonNullablePart == null) {
            return null;
        }
        Ref nameRef = Ref.create();
        JSExpression nullableExpression = JSNullPropagationIntention.unwrapItem(nullablePart, (Ref<String>)nameRef);
        JSExpression nonNullableExpression = JSNullPropagationIntention.unwrapItem(nonNullablePart, (Ref<String>)nameRef);
        if (nonNullableExpression == null || (!(nonNullableExpression instanceof JSCallExpression) || nullablePart != null) && nullableExpression == null) {
            return null;
        }
        return Pair.create((Object)nonNullableExpression, (Object)nullableExpression);
    }

    @Nullable
    private static JSReferenceExpression getExpressionInCondition(@Nullable JSExpression condition) {
        if (condition instanceof JSReferenceExpression) {
            return (JSReferenceExpression)condition;
        }
        if (condition instanceof JSBinaryExpression) {
            if (!JSTokenTypes.EQUALITY_OPERATIONS.contains(((JSBinaryExpression)condition).getOperationSign())) {
                return null;
            }
            JSExpression lOperand = ((JSBinaryExpression)condition).getLOperand();
            JSExpression rOperand = ((JSBinaryExpression)condition).getROperand();
            if (lOperand instanceof JSLiteralExpression && ((JSLiteralExpression)lOperand).isNullLiteral() || JSSymbolUtil.isUndefinedExpression(lOperand)) {
                return (JSReferenceExpression)ObjectUtils.tryCast((Object)rOperand, JSReferenceExpression.class);
            }
            if (rOperand instanceof JSLiteralExpression && ((JSLiteralExpression)rOperand).isNullLiteral() || JSSymbolUtil.isUndefinedExpression(rOperand)) {
                return (JSReferenceExpression)ObjectUtils.tryCast((Object)lOperand, JSReferenceExpression.class);
            }
        }
        if (condition instanceof JSPrefixExpression && ((JSPrefixExpression)condition).getOperationSign() == JSTokenTypes.EXCL) {
            return (JSReferenceExpression)ObjectUtils.tryCast((Object)((JSPrefixExpression)condition).getExpression(), JSReferenceExpression.class);
        }
        return null;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        boolean shouldUseConditional;
        if (project == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(6);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        Trinity<JSExpression, JSExpression, JSExpression> item = JSNullPropagationIntention.findItem(element);
        if (item == null) {
            return false;
        }
        boolean isStrictOptChain = JSSymbolUtil.isUndefinedExpression((JSExpression)item.third) || item.third == null;
        boolean isStrictNullish = EquivalenceChecker.expressionsAreEquivalent((JSExpression)item.first, (JSExpression)item.second) || item.second != null && ((JSExpression)item.second).getParent() instanceof JSVariable;
        boolean bl = shouldUseConditional = JSNullPropagationIntention.shouldUseConditional((JSExpression)item.first) && (JSNullPropagationIntention.getQualifierOf((JSExpression)item.first, (JSExpression)item.second) == null || EquivalenceChecker.expressionsAreEquivalent((JSExpression)item.first, (JSExpression)item.second));
        this.myText = isStrictOptChain ? JavaScriptBundle.message((String)"javascript.intention.opt.chain.chain.only", (Object[])new Object[0]) : (isStrictNullish ? (shouldUseConditional ? JavaScriptBundle.message((String)"javascript.intention.opt.chain.conditional.only", (Object[])new Object[0]) : JavaScriptBundle.message((String)"javascript.intention.opt.chain.coalesce.only", (Object[])new Object[0])) : JavaScriptBundle.message((String)"javascript.intention.opt.chain.chain.and.coalesce", (Object[])new Object[0]));
        return true;
    }

    private static boolean shouldUseConditional(JSExpression first) {
        return first instanceof JSReferenceExpression && !(first.getParent() instanceof JSBinaryExpression);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.intention.opt.chain.family", (Object[])new Object[0]);
        if (string == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameRef";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/nullPropagation/JSNullPropagationIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/nullPropagation/JSNullPropagationIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findItem";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElse";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unwrapItem";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

