/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSCDNLibManager;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibraryUtil {
    public static final Logger LOG = Logger.getInstance(JSLibraryUtil.class);
    private static final String[] MIN_SUFFIXES = new String[]{".min.", "-min.", "-yui-compressed"};
    private static final HashMap<String, String> MIN_TO_DEV_VERSION_MAP = new HashMap();
    public static final String NODE_MODULES = "node_modules";
    private static final String BOWER_COMPONENTS = "bower_components";
    private static final String JSPM_PACKAGES = "jspm_packages";
    public static final String[] LIBRARY_DIR_NAMES = new String[]{"node_modules", "bower_components", "jspm_packages"};
    public static final Set<String> LIBRARY_ROOT_DIR_NAME_SET = ContainerUtil.immutableSet((Object[])LIBRARY_DIR_NAMES);
    private static final String JS_EXT = ".js";
    private static final String CSS_EXT = ".css";
    private static final String[] HTTP_PREFIXES;

    private JSLibraryUtil() {
    }

    public static boolean containsLibURL(String location) {
        return HtmlUtil.hasHtmlPrefix((String)location) && (JSLibraryUtil.isPossibleLibFile(location) || JSCDNLibManager.getLibraryForUrl(location) != null);
    }

    public static String getDevVersionLocation(@NotNull String location, boolean forDownload) {
        JSCDNLibManager.JSCDNLibrary library;
        if (location == null) {
            JSLibraryUtil.$$$reportNull$$$0(0);
        }
        if ((library = JSCDNLibManager.getLibraryForUrl(location)) != null) {
            return library.getNonMinifiedUrl(forDownload);
        }
        if (!JSLibraryUtil.isPossibleLibFile(location)) {
            return location;
        }
        String fileName = JSLibraryUtil.extractFileName(location);
        if (MIN_TO_DEV_VERSION_MAP.containsKey(fileName)) {
            return location.replace(fileName, MIN_TO_DEV_VERSION_MAP.get(fileName));
        }
        return JSLibraryUtil.convertLocationSuffixToNonMinimized(location);
    }

    static String convertLocationSuffixToNonMinimized(@NotNull String location) {
        String oldFileName;
        if (location == null) {
            JSLibraryUtil.$$$reportNull$$$0(1);
        }
        String fileName = oldFileName = JSLibraryUtil.extractFileName(location);
        for (String minSuffix : MIN_SUFFIXES) {
            if (!fileName.contains(minSuffix)) continue;
            fileName = oldFileName.replace(minSuffix, ".");
            return location.replace(oldFileName, fileName);
        }
        return location;
    }

    private static boolean isPossibleLibFile(String location) {
        return location.endsWith(JS_EXT) || location.endsWith(CSS_EXT);
    }

    public static String makeUniqueFileName(String filePath, boolean adjustFileName) {
        if (adjustFileName) {
            filePath = JSLibraryUtil.getDevVersionLocation(filePath, false);
        }
        for (String prefix : HTTP_PREFIXES) {
            if (!filePath.contains(prefix)) continue;
            filePath = filePath.replace(prefix, "http_");
            break;
        }
        return filePath.replace('/', '_').replace('\\', '_');
    }

    private static String extractFileName(String filePath) {
        int fileSepIndex = filePath.lastIndexOf(47);
        if (fileSepIndex < 0) {
            fileSepIndex = filePath.lastIndexOf(File.separatorChar);
        }
        return fileSepIndex >= 0 ? filePath.substring(fileSepIndex + 1) : filePath;
    }

    public static String getLibName(String location) {
        int dotIndex;
        JSCDNLibManager.JSCDNLibrary library = JSCDNLibManager.getLibraryForUrl(location);
        if (library != null) {
            return library.getLibraryName();
        }
        String libName = JSLibraryUtil.extractFileName(location);
        if (!MIN_TO_DEV_VERSION_MAP.containsKey(libName)) {
            for (String minSuffix : MIN_SUFFIXES) {
                if (!libName.contains(minSuffix)) continue;
                libName = libName.replace(minSuffix, ".");
                break;
            }
        }
        if ((dotIndex = libName.lastIndexOf(46)) >= 0) {
            libName = libName.substring(0, dotIndex);
        }
        return libName;
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file2, @Nullable Project project) {
        if (file2 == null) {
            JSLibraryUtil.$$$reportNull$$$0(2);
        }
        return JSLibraryUtil.isProbableLibraryFile(file2, project == null ? null : project.getBaseDir());
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSLibraryUtil.$$$reportNull$$$0(3);
        }
        return JSLibraryUtil.isPredefinedLibraryFile(file2) || JSLibraryUtil.hasDirectoryInPath(file2, LIBRARY_DIR_NAMES, null);
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file2, @Nullable VirtualFile fileToStop) {
        if (file2 == null) {
            JSLibraryUtil.$$$reportNull$$$0(4);
        }
        return JSLibraryUtil.isPredefinedLibraryFile(file2) || JSLibraryUtil.hasDirectoryInPath(file2, LIBRARY_DIR_NAMES, fileToStop);
    }

    private static boolean isPredefinedLibraryFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSLibraryUtil.$$$reportNull$$$0(5);
        }
        return JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(file2);
    }

    public static VirtualFile getTopLibraryFolder(@NotNull VirtualFile file2, @NotNull String libraryFolder, @Nullable VirtualFile stopFolder) {
        if (file2 == null) {
            JSLibraryUtil.$$$reportNull$$$0(6);
        }
        if (libraryFolder == null) {
            JSLibraryUtil.$$$reportNull$$$0(7);
        }
        VirtualFile currentTarget = file2;
        VirtualFile current = file2;
        VirtualFile candidate;
        while ((candidate = JSLibraryUtil.getLibraryFolder(currentTarget, libraryFolder)) != null && (stopFolder == null || VfsUtilCore.isAncestor((VirtualFile)stopFolder, (VirtualFile)candidate, (boolean)true))) {
            current = candidate;
            if (current.getParent() == null || current.getParent().getParent() == null) {
                return current;
            }
            currentTarget = current.getParent().getParent();
        }
        return current;
    }

    @Nullable
    public static VirtualFile findAncestorLibraryDir(@NotNull VirtualFile fileOrDir, @NotNull String libraryName) {
        if (fileOrDir == null) {
            JSLibraryUtil.$$$reportNull$$$0(8);
        }
        if (libraryName == null) {
            JSLibraryUtil.$$$reportNull$$$0(9);
        }
        for (VirtualFile f = fileOrDir.getParent(); f != null; f = f.getParent()) {
            if (!StringUtil.equals((CharSequence)libraryName, (CharSequence)f.getNameSequence())) continue;
            return f;
        }
        return null;
    }

    public static VirtualFile getLibraryFolder(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSLibraryUtil.$$$reportNull$$$0(10);
        }
        return JSLibraryUtil.getLibraryFolder(file2, LIBRARY_ROOT_DIR_NAME_SET);
    }

    public static VirtualFile getLibraryFolder(@NotNull VirtualFile file2, @NotNull String parentLibraryFolder) {
        if (file2 == null) {
            JSLibraryUtil.$$$reportNull$$$0(11);
        }
        if (parentLibraryFolder == null) {
            JSLibraryUtil.$$$reportNull$$$0(12);
        }
        return JSLibraryUtil.getLibraryFolder(file2, Collections.singleton(parentLibraryFolder));
    }

    @Nullable
    private static VirtualFile getLibraryFolder(@NotNull VirtualFile file2, @NotNull Set<String> parentLibraryFolders) {
        if (file2 == null) {
            JSLibraryUtil.$$$reportNull$$$0(13);
        }
        if (parentLibraryFolders == null) {
            JSLibraryUtil.$$$reportNull$$$0(14);
        }
        VirtualFile current = file2;
        while (current != null) {
            CharSequence parentName;
            VirtualFile parent = current.getParent();
            CharSequence charSequence = parentName = parent == null ? null : parent.getNameSequence();
            if (parentName != null && parentLibraryFolders.contains(parentName.toString())) {
                return current;
            }
            current = parent;
        }
        return null;
    }

    public static boolean hasDirectoryInPath(@NotNull VirtualFile file2, String @NotNull [] dirNames, @Nullable VirtualFile fileToStop) {
        if (file2 == null) {
            JSLibraryUtil.$$$reportNull$$$0(15);
        }
        if (dirNames == null) {
            JSLibraryUtil.$$$reportNull$$$0(16);
        }
        for (VirtualFile parent = file2.getParent(); parent != null && !parent.equals(fileToStop); parent = parent.getParent()) {
            CharSequence name = parent.getNameSequence();
            for (String dirName : dirNames) {
                if (!StringUtil.equals((CharSequence)dirName, (CharSequence)name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasDirectoryInPath(@NotNull VirtualFile file2, @NotNull String directoryName, @Nullable VirtualFile fileToStop) {
        if (file2 == null) {
            JSLibraryUtil.$$$reportNull$$$0(17);
        }
        if (directoryName == null) {
            JSLibraryUtil.$$$reportNull$$$0(18);
        }
        for (VirtualFile parent = file2.getParent(); parent != null && !parent.equals(fileToStop); parent = parent.getParent()) {
            if (!StringUtil.equals((CharSequence)directoryName, (CharSequence)parent.getNameSequence())) continue;
            return true;
        }
        return false;
    }

    public static boolean isProbableLibraryPath(@NotNull String filePath) {
        if (filePath == null) {
            JSLibraryUtil.$$$reportNull$$$0(19);
        }
        filePath = FileUtil.toSystemIndependentName((String)filePath);
        for (String dirName : LIBRARY_DIR_NAMES) {
            if (!JSLibraryUtil.containsDirInPath(filePath, dirName)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsDirInPath(@NotNull String filePath, @NotNull String dirName) {
        if (filePath == null) {
            JSLibraryUtil.$$$reportNull$$$0(20);
        }
        if (dirName == null) {
            JSLibraryUtil.$$$reportNull$$$0(21);
        }
        int ind = filePath.indexOf(dirName);
        while (ind >= 0) {
            if (!(ind != 0 && filePath.charAt(ind - 1) != '/' || ind + dirName.length() != filePath.length() && filePath.charAt(ind + dirName.length()) != '/')) {
                return true;
            }
            ind = filePath.indexOf(dirName, ind + dirName.length());
        }
        return false;
    }

    @Nullable
    public static VirtualFile findFileByIoFile(@NotNull LocalFileSystem localFileSystem, @NotNull File ioFile) {
        if (localFileSystem == null) {
            JSLibraryUtil.$$$reportNull$$$0(22);
        }
        if (ioFile == null) {
            JSLibraryUtil.$$$reportNull$$$0(23);
        }
        if (!ioFile.isFile()) {
            LOG.warn("Cannot find " + ioFile.getAbsolutePath() + ", the installation is possibly broken.");
            return null;
        }
        VirtualFile file2 = localFileSystem.findFileByIoFile(ioFile);
        if (file2 != null) {
            return file2;
        }
        LOG.warn("Cannot find virtual file for " + ioFile.getAbsolutePath());
        return null;
    }

    public static VirtualFile findUpClosestNodeModulesResolveRoot(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSLibraryUtil.$$$reportNull$$$0(24);
        }
        return JSLibraryUtil.findUpClosestNodeModulesResolveRoot(file2, true);
    }

    @Nullable
    public static VirtualFile findUpClosestNodeModulesResolveRoot(@NotNull VirtualFile file2, boolean strict) {
        VirtualFile parent;
        if (file2 == null) {
            JSLibraryUtil.$$$reportNull$$$0(25);
        }
        VirtualFile virtualFile = parent = strict ? file2.getParent() : file2;
        while (parent != null) {
            VirtualFile nodeModulesDir = parent.findChild(NODE_MODULES);
            if (nodeModulesDir != null && nodeModulesDir.isDirectory()) {
                return nodeModulesDir;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Nullable
    public static VirtualFile findFileByIO(@NotNull File ioFile, boolean includeInvalid) {
        URL libFileUrl;
        if (ioFile == null) {
            JSLibraryUtil.$$$reportNull$$$0(26);
        }
        if ((libFileUrl = JSLibraryUtil.getFileUrl(ioFile)) == null) {
            return null;
        }
        VirtualFile file2 = VfsUtil.findFileByURL((URL)libFileUrl);
        if (file2 != null && (includeInvalid || file2.isValid())) {
            return file2;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.warn("Cannot find virtual file " + ioFile.getName() + " by url " + libFileUrl.toExternalForm());
        }
        return null;
    }

    @Nullable
    public static URL getFileUrl(@NotNull File ioFile) {
        if (ioFile == null) {
            JSLibraryUtil.$$$reportNull$$$0(27);
        }
        URL libFileUrl = null;
        try {
            libFileUrl = ioFile.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (libFileUrl == null) {
            LOG.error("Cannot find " + ioFile.getName() + ", the installation is possibly broken.");
            return null;
        }
        return libFileUrl;
    }

    @Contract(value="_, null, _-> null")
    @Nullable
    public static VirtualFile cacheFile(@NotNull String libFileName, @Nullable VirtualFile file2, @NotNull Map<String, Ref<VirtualFile>> cache) {
        if (libFileName == null) {
            JSLibraryUtil.$$$reportNull$$$0(28);
        }
        if (cache == null) {
            JSLibraryUtil.$$$reportNull$$$0(29);
        }
        cache.put(libFileName, (Ref<VirtualFile>)Ref.create((Object)file2));
        return file2;
    }

    @Contract(value="_, null -> null")
    public static VirtualFile getContentRootForFile(@NotNull Project project, @Nullable VirtualFile file2) {
        if (project == null) {
            JSLibraryUtil.$$$reportNull$$$0(30);
        }
        return JSLibraryUtil.getContentRootForFile(ProjectFileIndex.getInstance((Project)project), file2);
    }

    @Contract(value="_, null -> null")
    public static VirtualFile getContentRootForFile(@NotNull ProjectFileIndex fileIndex, @Nullable VirtualFile file2) {
        if (fileIndex == null) {
            JSLibraryUtil.$$$reportNull$$$0(31);
        }
        if (file2 == null) {
            return null;
        }
        VirtualFile contentRoot = fileIndex.getContentRootForFile(file2, false);
        if (contentRoot == null && (file2 = file2.getParent()) != null) {
            contentRoot = fileIndex.getContentRootForFile(file2, false);
        }
        if (contentRoot == null && file2 != null && fileIndex.isInLibrary(file2)) {
            VirtualFile sourceRoot = fileIndex.getSourceRootForFile(file2);
            VirtualFile virtualFile = file2 = sourceRoot != null ? sourceRoot.getParent() : null;
            if (file2 != null) {
                contentRoot = fileIndex.getContentRootForFile(file2, false);
            }
        }
        return contentRoot;
    }

    @NotNull
    public static GlobalSearchScope getContentScopeWithoutLibraries(@NotNull Project project) {
        if (project == null) {
            JSLibraryUtil.$$$reportNull$$$0(32);
        }
        GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
        final ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        GlobalSearchScope globalSearchScope = scope.intersectWith(new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return file2.isValid() && !file2.isDirectory() && !JSLibraryUtil.isProbableLibraryFile(file2) && !fileIndex.isInLibrary(file2);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    1.$$$reportNull$$$0(1);
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (globalSearchScope == null) {
            JSLibraryUtil.$$$reportNull$$$0(33);
        }
        return globalSearchScope;
    }

    public static boolean isUnderContentRootsAndOutsideOfLibraryRoots(@NotNull Project project, @NotNull VirtualFile file2) {
        VirtualFile contentRoot;
        if (project == null) {
            JSLibraryUtil.$$$reportNull$$$0(34);
        }
        if (file2 == null) {
            JSLibraryUtil.$$$reportNull$$$0(35);
        }
        return (contentRoot = ProjectFileIndex.getInstance((Project)project).getContentRootForFile(file2, false)) != null && !JSLibraryUtil.hasDirectoryInPath(file2, LIBRARY_DIR_NAMES, contentRoot);
    }

    static {
        MIN_TO_DEV_VERSION_MAP.put("dojo.xd.js", "dojo.xd.js.uncompressed.js");
        MIN_TO_DEV_VERSION_MAP.put("dojo.js", "dojo.js.uncompressed.js");
        MIN_TO_DEV_VERSION_MAP.put("ext-core.js", "ext-core-debug.js");
        MIN_TO_DEV_VERSION_MAP.put("swfobject.js", "swfobject_src.js");
        MIN_TO_DEV_VERSION_MAP.put("webfont.js", "webfont_debug.js");
        HTTP_PREFIXES = new String[]{"http://", "https://"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 24: 
            case 25: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFolder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLibraryFolder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLibraryFolders";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirNames";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFileSystem";
                break;
            }
            case 23: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFileName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/JSLibraryUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryUtil";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentScopeWithoutLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDevVersionLocation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertLocationSuffixToNonMinimized";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isProbableLibraryFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedLibraryFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTopLibraryFolder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findAncestorLibraryDir";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryFolder";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasDirectoryInPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isProbableLibraryPath";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "containsDirInPath";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findFileByIoFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findUpClosestNodeModulesResolveRoot";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findFileByIO";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFileUrl";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "cacheFile";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getContentRootForFile";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getContentScopeWithoutLibraries";
                break;
            }
            case 33: {
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isUnderContentRootsAndOutsideOfLibraryRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

