/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class JSEvaluatorComplexityTracker {
    private static final int MAX_COMPLEXITY = JSUtils.getSystemPropertySafely("idea.javascript.max.evaluation.complexity", 50);
    private final int myMaxComplexity;
    private int myComplexityLeft;
    private Object myInitialKey = null;
    private final RecursionGuard<Object> recursionGuard = RecursionManager.createGuard((String)"js.evaluator.complexity.tracker");
    private static boolean ourAssertOnPrevention = false;

    public JSEvaluatorComplexityTracker() {
        this(MAX_COMPLEXITY);
    }

    public JSEvaluatorComplexityTracker(int maxComplexity) {
        this.myMaxComplexity = maxComplexity;
        this.myComplexityLeft = maxComplexity;
    }

    public <T> boolean runTasks(@NotNull Collection<T> elements, boolean checkOnlyIfSubTask, @NotNull Consumer<T> task) {
        if (elements == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(0);
        }
        if (task == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(1);
        }
        int complexity = this.reserveComplexity(elements.size());
        boolean result2 = false;
        for (Object element : elements) {
            result2 |= this.doRunTask(() -> {
                task.accept(element);
                return true;
            }, checkOnlyIfSubTask, complexity);
        }
        return result2;
    }

    public boolean runTask(@NotNull Supplier<Boolean> task) {
        if (task == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(2);
        }
        return this.doRunTask(task, false, this.reserveComplexity(1));
    }

    private int reserveComplexity(int tasks) {
        if (tasks == 0) {
            return 0;
        }
        int result2 = Math.floorDiv(this.myComplexityLeft * 4, tasks * 5);
        if (result2 < 0 || result2 * tasks > this.myComplexityLeft) {
            Logger.getInstance(JSEvaluatorComplexityTracker.class).error(String.format("Invalid complexity reserved: result = %d, myComplexityLeft = %d, tasks = %d", result2, this.myComplexityLeft, tasks));
            return 0;
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRunTask(@NotNull Supplier<Boolean> task, boolean checkOnlyIfSubTask, int complexityLeftForTask) {
        boolean isInitial;
        if (task == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(3);
        }
        boolean bl = isInitial = this.myInitialKey == null;
        if (isInitial && checkOnlyIfSubTask) {
            return task.get();
        }
        Object key = new Object();
        if (isInitial) {
            this.myInitialKey = key;
        }
        if (complexityLeftForTask <= 0) {
            this.recursionGuard.prohibitResultCaching(this.myInitialKey);
            if (isInitial) {
                this.restoreInitialState();
            }
            return false;
        }
        int parentTaskComplexityLeft = this.myComplexityLeft;
        try {
            this.myComplexityLeft = complexityLeftForTask - 1;
            boolean bl2 = Boolean.TRUE.equals(this.recursionGuard.doPreventingRecursion(key, true, task::get));
            return bl2;
        }
        finally {
            this.myComplexityLeft = parentTaskComplexityLeft - (complexityLeftForTask - this.myComplexityLeft);
            if (isInitial) {
                this.restoreInitialState();
            }
        }
    }

    private void restoreInitialState() {
        this.myInitialKey = null;
        this.myComplexityLeft = this.myMaxComplexity;
    }

    public int getComplexityLeft() {
        return this.myComplexityLeft;
    }

    public void useComplexity(int complexity) {
        if (complexity < 0 || complexity > this.myComplexityLeft) {
            throw new IllegalArgumentException("complexity: " + complexity);
        }
        if (this.myInitialKey != null) {
            this.myComplexityLeft -= complexity;
        }
    }

    public static void assertOnRecursionPrevention(@NotNull Disposable disposable) {
        if (disposable == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(4);
        }
        ourAssertOnPrevention = true;
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                ourAssertOnPrevention = false;
            }
        });
    }

    public static boolean isAssertOnPrevention() {
        return ourAssertOnPrevention;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluatorComplexityTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runTasks";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doRunTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "assertOnRecursionPrevention";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

