/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureCommonImpl;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCompositeFunctionPropertySignatureImpl
implements PropertySignatureCommonImpl {
    private final boolean myIsOptional;
    private final boolean myIsReadonly;
    @NotNull
    private final String myName;
    @NotNull
    private final List<JSRecordType.PropertySignature> myFunctionSignatures;
    @NotNull
    private final JSTypeSource myTypeSource;
    @NotNull
    private final NotNullLazyValue<JSType> myType;
    private final NotNullLazyValue<JSRecordType.MemberSource> myMemberSourceLazy;

    public JSCompositeFunctionPropertySignatureImpl(@NotNull String name, @NotNull List<JSRecordType.PropertySignature> functionSignatures, boolean isOptional, boolean isReadonly, @NotNull JSTypeSource typeSource) {
        if (name == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(0);
        }
        if (functionSignatures == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(1);
        }
        if (typeSource == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(2);
        }
        this.myType = NotNullLazyValue.createValue(() -> {
            List<JSRecordType.PropertySignature> members = this.getMembers();
            ArrayList<JSRecordTypeImpl.CallSignatureImpl> toMerge = new ArrayList<JSRecordTypeImpl.CallSignatureImpl>(members.size());
            for (JSRecordType.PropertySignature signature : members) {
                JSType type = signature.getJSType();
                if (!(type instanceof JSFunctionTypeImpl)) continue;
                toMerge.add(new JSRecordTypeImpl.CallSignatureImpl(false, (JSFunctionTypeImpl)type));
            }
            return new JSRecordTypeImpl(this.getTypeSource(), toMerge);
        });
        this.myName = name;
        this.myIsOptional = isOptional;
        this.myIsReadonly = isReadonly;
        this.myFunctionSignatures = functionSignatures;
        this.myTypeSource = typeSource;
        this.myMemberSourceLazy = NotNullLazyValue.createValue(this::computeMemberSource);
    }

    @Override
    public boolean isEquivalentTo(@Nullable JSRecordType.TypeMember other, @Nullable ProcessingContext context, boolean allowResolve) {
        if (this.isFastEquivalentTo(other)) {
            return true;
        }
        return PropertySignatureCommonImpl.arePropertySignaturesEqual(this, other, context, allowResolve);
    }

    final boolean isFastEquivalentTo(@Nullable JSRecordType.TypeMember other) {
        if (!(other instanceof JSCompositeFunctionPropertySignatureImpl)) {
            return false;
        }
        JSCompositeFunctionPropertySignatureImpl otherFPSignature = (JSCompositeFunctionPropertySignatureImpl)other;
        List<JSRecordType.PropertySignature> members = this.getMembers();
        List<JSRecordType.PropertySignature> otherMembers = otherFPSignature.getMembers();
        return ContainerUtil.equalsIdentity(members, otherMembers);
    }

    @NotNull
    public JSRecordType.MemberSource getMemberSource() {
        JSRecordType.MemberSource memberSource = (JSRecordType.MemberSource)this.myMemberSourceLazy.getValue();
        if (memberSource == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(3);
        }
        return memberSource;
    }

    @NotNull
    private JSRecordType.MemberSource computeMemberSource() {
        LinkedHashSet<PsiElement> allSourceElements = new LinkedHashSet<PsiElement>();
        for (JSRecordType.PropertySignature signature : this.myFunctionSignatures) {
            allSourceElements.addAll(signature.getMemberSource().getAllSourceElements());
        }
        JSRecordType.MemberSource memberSource = JSRecordMemberSourceFactory.createSource(allSourceElements, JSRecordType.MemberSourceKind.CompositeSignature);
        if (memberSource == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(4);
        }
        return memberSource;
    }

    @Override
    @NotNull
    public JSRecordType.PropertySignature copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(5);
        }
        List<JSRecordType.PropertySignature> members = this.getMembers();
        ArrayList<JSRecordType.PropertySignature> resultMembers = new ArrayList<JSRecordType.PropertySignature>(members.size());
        for (JSRecordType.PropertySignature propertySignature : members) {
            resultMembers.add(propertySignature.copyTypeHierarchy(childTransform));
        }
        if (ContainerUtil.equalsIdentity(members, resultMembers)) {
            JSCompositeFunctionPropertySignatureImpl jSCompositeFunctionPropertySignatureImpl = this;
            if (jSCompositeFunctionPropertySignatureImpl == null) {
                JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(6);
            }
            return jSCompositeFunctionPropertySignatureImpl;
        }
        return new JSCompositeFunctionPropertySignatureImpl(this.getMemberName(), resultMembers, this.isOptional(), this.isConst(), this.getTypeSource());
    }

    @NotNull
    public String getMemberName() {
        String string = this.myName;
        if (string == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isOptional() {
        return this.myIsOptional;
    }

    public boolean isConst() {
        return this.myIsReadonly;
    }

    public List<JSRecordType.PropertySignature> getMembers() {
        return this.myFunctionSignatures;
    }

    public JSCompositeFunctionPropertySignatureImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(8);
        }
        return new JSCompositeFunctionPropertySignatureImpl(this.getMemberName(), this.getMembers(), this.isOptional(), this.isConst(), source);
    }

    @NotNull
    public JSTypeSource getTypeSource() {
        JSTypeSource jSTypeSource = this.myTypeSource;
        if (jSTypeSource == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(9);
        }
        return jSTypeSource;
    }

    public JSType getJSType() {
        return (JSType)this.myType.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionSignatures";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSCompositeFunctionPropertySignatureImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSCompositeFunctionPropertySignatureImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberSource";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMemberSource";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

