/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.ECMA6SyntaxHighlighterFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.validation.JSKeywordHighlighterVisitor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class ES6KeywordHighlighterVisitor
extends JSKeywordHighlighterVisitor {
    public ES6KeywordHighlighterVisitor(@NotNull HighlightInfoHolder holder) {
        if (holder == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(0);
        }
        super(holder, new ECMA6SyntaxHighlighterFactory.ECMA6SyntaxHighlighter(DialectOptionHolder.ECMA_6, true));
    }

    public ES6KeywordHighlighterVisitor(HighlightInfoHolder holder, JSHighlighter highlighter) {
        super(holder, highlighter);
    }

    @Override
    public void visitJSForInStatement(JSForInStatement element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.OF_KEYWORD);
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.AWAIT_KEYWORD);
        super.visitJSForInStatement(element);
    }

    public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
        this.highlightChildKeywordOfType((PsiElement)exportDeclaration, JSTokenTypes.TYPE_KEYWORD);
        super.visitES6ExportDeclaration(exportDeclaration);
    }

    public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
        this.highlightChildKeywordOfType((PsiElement)importDeclaration, JSTokenTypes.TYPE_KEYWORD);
        super.visitES6ImportDeclaration(importDeclaration);
    }

    public void visitJSAttributeList(JSAttributeList element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.ASYNC_KEYWORD);
        super.visitJSAttributeList(element);
    }

    public void visitJSPrefixExpression(JSPrefixExpression element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.AWAIT_KEYWORD);
        super.visitJSPrefixExpression(element);
    }

    public void visitJSYieldExpression(JSYieldExpression statement) {
        this.highlightChildKeywordOfType((PsiElement)statement, JSTokenTypes.YIELD_KEYWORD);
        super.visitJSYieldExpression(statement);
    }

    public void visitES6Decorator(ES6Decorator decorator) {
        PsiElement element;
        JSExpression expression;
        ASTNode at = decorator.getNode().findChildByType(JSTokenTypes.AT);
        if (at != null) {
            this.highlightDecorator(at.getPsi());
        }
        if ((expression = decorator.getExpression()) instanceof JSCallExpression) {
            expression = ((JSCallExpression)expression).getMethodExpression();
        }
        if (expression instanceof JSReferenceExpression && (element = ((JSReferenceExpression)expression).getReferenceNameElement()) != null) {
            this.highlightDecorator(element);
        }
        super.visitES6Decorator(decorator);
    }

    private void highlightDecorator(@NotNull PsiElement node) {
        if (node == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(1);
        }
        TextAttributesKey key = this.myHighlighter.getMappedKey(JSHighlighter.ES6_DECORATOR);
        this.myHolder.add(JSSemanticHighlightingUtil.justLineMarker(node, key, "decorator"));
    }

    public void visitTypeScriptSingleType(TypeScriptSingleType singleType) {
        JSReferenceExpression referenceExpression = singleType.getReferenceExpression();
        Object parent = referenceExpression != null ? referenceExpression : singleType;
        ASTNode node = parent.getNode();
        ASTNode keyword = node.findChildByType(JSDocumentationUtils.ourPrimitiveTypeFilter);
        if (keyword != null) {
            TextAttributesKey key = this.annotatePrimitiveType(keyword);
            this.myHolder.add(JSKeywordHighlighterVisitor.highlightKeyword(keyword, key));
        }
        super.visitTypeScriptSingleType(singleType);
    }

    @NotNull
    protected TextAttributesKey annotatePrimitiveType(ASTNode keyword) {
        TextAttributesKey textAttributesKey = JSHighlighter.JS_PRIMITIVE_TYPE;
        if (textAttributesKey == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(2);
        }
        return textAttributesKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/ES6KeywordHighlighterVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/ES6KeywordHighlighterVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "annotatePrimitiveType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "highlightDecorator";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

