/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeWithWidening;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.impl.source.xml.XmlTextImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCreateFix
extends FixAndIntentionAction
implements HighPriorityAction {
    private static final String SCRIPT_TAG_NAME = "Script";
    protected boolean myIsProperty;
    private static final Function<PsiElement, Boolean> ourFilter = psiElement -> BaseCreateFix.toSkipElement(psiElement);
    private static final Function<PsiElement, Boolean> ourEnumFilter = psiElement -> psiElement instanceof PsiComment;
    private static final Function<PsiElement, Boolean> ourObjectLiteralFieldLikeFilter = psiElement -> psiElement instanceof PsiComment || psiElement.getNode().getElementType() == JSTokenTypes.COMMA || psiElement instanceof JSProperty && ((JSProperty)psiElement).tryGetFunctionInitializer() == null;
    private static final TokenSet LBRACE_LIKE_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.LBRACE, JSTokenTypes.LBRACE_OR});
    private int uniqueCounter;

    @Override
    protected void applyFix(Project project, PsiElement psiElement, @NotNull PsiFile file2, @Nullable Editor editor) {
        if (file2 == null) {
            BaseCreateFix.$$$reportNull$$$0(0);
        }
        this.doApplyFix(project, psiElement, file2, editor);
    }

    protected final void doApplyFix(Project project, PsiElement psiElement, PsiFile file2, Editor editor) {
        this.doApplyFix(project, psiElement, file2, editor, null, null);
    }

    protected boolean isExportWithoutFrom() {
        PsiElement element = this.myElementPointer == null ? null : this.myElementPointer.getElement();
        return BaseCreateFix.isExportWithoutFrom(element);
    }

    protected boolean isExportDefault() {
        PsiElement element = this.myElementPointer == null ? null : this.myElementPointer.getElement();
        return element instanceof ES6ImportedBinding;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static boolean isExportWithoutFrom(PsiElement element) {
        return element instanceof ES6ExportSpecifier && ES6PsiUtil.computeFromFileForImportExport(element) == element.getContainingFile();
    }

    protected final void doApplyFix(Project project, PsiElement psiElement, PsiFile file2, Editor editor, @Nullable PsiElement predefinedAnchor, @Nullable PsiElement predefinedScope) {
        JSExpression qualifier;
        Pair<JSReferenceExpression, PsiElement> anchor = this.calculateAnchors(psiElement);
        JSReferenceExpression referenceExpression = (JSReferenceExpression)anchor.first;
        PsiElement nodeForAnchor = (PsiElement)anchor.second;
        PsiFile realFile = file2;
        if (file2.getContext() != null) {
            realFile = file2.getContext().getContainingFile();
            Editor editor2 = editor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        }
        assert (psiElement instanceof XmlAttribute || referenceExpression != null || psiElement instanceof ES6ImportExportSpecifier || psiElement instanceof ES6ImportedBinding);
        JSExpression jSExpression = qualifier = referenceExpression == null ? null : referenceExpression.getQualifier();
        if (qualifier != null || psiElement instanceof XmlAttribute || psiElement instanceof ES6ImportExportSpecifier || psiElement instanceof ES6ImportedBinding) {
            PsiElement type;
            if (psiElement instanceof XmlAttribute) {
                XmlTag tag = (XmlTag)psiElement.getParent();
                XmlElementDescriptor descriptor2 = tag.getDescriptor();
                type = descriptor2 == null ? null : descriptor2.getDeclaration();
            } else if (psiElement instanceof ES6ImportExportSpecifier || psiElement instanceof ES6ImportedBinding) {
                PsiElement fileFromSpecifier = ES6PsiUtil.computeFromFileForImportExport(psiElement);
                if (fileFromSpecifier == null) {
                    return;
                }
                type = fileFromSpecifier.getContainingFile();
            } else {
                type = BaseCreateFix.getScope(qualifier, file2);
            }
            if (type == null && DialectDetector.isActionScript((PsiElement)file2)) {
                return;
            }
            if (type != null) {
                if (type instanceof XmlBackedJSClass) {
                    type = type.getParent().getContainingFile();
                }
                editor = null;
                if (type instanceof JSClass || type instanceof TypeScriptObjectType || type instanceof TypeScriptModule || type instanceof JSObjectLiteralExpression) {
                    realFile = file2 = type.getContainingFile();
                    predefinedScope = type instanceof TypeScriptInterface ? ((TypeScriptInterface)type).getBody() : type;
                    predefinedAnchor = BaseCreateFix.findInsertionAnchorForScope(type, this.isIntroducingVariable());
                } else if (type instanceof JSFile) {
                    realFile = file2 = (JSFile)type;
                    predefinedAnchor = null;
                    nodeForAnchor = file2;
                    predefinedScope = file2;
                } else if (type instanceof XmlFile) {
                    realFile = file2 = type.getContainingFile();
                    predefinedAnchor = type;
                }
            }
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(realFile)) {
            return;
        }
        if (editor == null) {
            editor = BaseCreateFix.getEditor(project, realFile);
        }
        if (editor == null) {
            return;
        }
        boolean canHaveClasses = JSClassUtils.canHaveClasses((PsiElement)ObjectUtils.coalesce((Object)referenceExpression, (Object)file2));
        boolean isClassTypeOrObjectMember = psiElement instanceof XmlAttribute || this.produceDeclarationInScope(predefinedAnchor == null ? psiElement : predefinedAnchor);
        PsiElement initialAnchor = (PsiElement)ObjectUtils.coalesce((Object)predefinedAnchor, (Object)JSUtils.findStatementAnchor(nodeForAnchor), (Object)nodeForAnchor);
        PsiElement scope = BaseCreateFix.getInsertionScope(predefinedScope, initialAnchor, isClassTypeOrObjectMember, this.skipParentIfClass());
        initialAnchor = PsiTreeUtil.findFirstParent((PsiElement)initialAnchor, el -> el.getParent() == scope || el == scope);
        InsertPlaceInfo insertPlaceInfo = new InsertPlaceInfo(initialAnchor, realFile, isClassTypeOrObjectMember, this.isIntroducingVariable());
        if (insertPlaceInfo.anchor != null) {
            boolean isStatic = canHaveClasses && BaseCreateFix.isStatic(psiElement, qualifier);
            referenceExpression = this.beforeStartTemplateAction(referenceExpression, editor, insertPlaceInfo.anchor, isStatic);
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = templateManager.createTemplate("", "");
            template.setToReformat(true);
            if (insertPlaceInfo.addNewLineBefore) {
                template.addTextSegment("\n");
            }
            PsiElement anchorParent = (PsiElement)ObjectUtils.coalesce((Object)scope, (Object)insertPlaceInfo.anchor);
            PsiUtilCore.ensureValid((PsiElement)anchorParent);
            this.buildTemplate(template, referenceExpression, isStatic, anchorParent);
            if (scope instanceof JSObjectLiteralExpression) {
                JSProperty nextProperty;
                JSProperty jSProperty = nextProperty = insertPlaceInfo.anchor instanceof JSProperty && !insertPlaceInfo.insertAtEnd ? (JSProperty)insertPlaceInfo.anchor : (JSProperty)PsiTreeUtil.getNextSiblingOfType((PsiElement)insertPlaceInfo.anchor, JSProperty.class);
                if (nextProperty != null) {
                    template.addTextSegment(",");
                }
            }
            if (insertPlaceInfo.toInsertNewLineAfter) {
                template.addTextSegment("\n");
            }
            int offset = BaseCreateFix.calculateOffset(file2, realFile, insertPlaceInfo);
            BaseCreateFix.navigate(project, editor, offset, realFile.getVirtualFile());
            templateManager.startTemplate(editor, template);
        }
    }

    protected boolean skipParentIfClass() {
        return true;
    }

    @Nullable
    private static PsiElement getInsertionScope(@Nullable PsiElement predefinedScope, @NotNull PsiElement initialAnchor, boolean isFieldLevel, boolean skipParentIfClass) {
        if (initialAnchor == null) {
            BaseCreateFix.$$$reportNull$$$0(1);
        }
        if (predefinedScope != null) {
            return predefinedScope;
        }
        if (isFieldLevel) {
            return PsiTreeUtil.getParentOfType((PsiElement)initialAnchor, (Class[])new Class[]{JSClass.class, TypeScriptObjectType.class, JSFile.class, TypeScriptModule.class});
        }
        PsiElement parent = initialAnchor.getParent();
        return skipParentIfClass && parent instanceof JSClass ? parent.getParent() : parent;
    }

    protected JSReferenceExpression beforeStartTemplateAction(JSReferenceExpression referenceExpression, Editor editor, @NotNull PsiElement anchor, boolean isStaticContext) {
        if (anchor == null) {
            BaseCreateFix.$$$reportNull$$$0(2);
        }
        return referenceExpression;
    }

    private static boolean isStatic(PsiElement psiElement, JSExpression qualifier) {
        if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, ES6Decorator.class) != null) {
            return true;
        }
        if (qualifier != null) {
            if (qualifier instanceof JSReferenceExpression) {
                PsiElement qualifierResolve = ((JSReferenceExpression)qualifier).resolve();
                PsiElement target = qualifierResolve != null ? JSStubBasedPsiTreeUtil.calculateMeaningfulElement(qualifierResolve) : null;
                return target instanceof JSClass && !(target instanceof TypeScriptEnum) || target instanceof XmlFile;
            }
            if (qualifier instanceof JSThisExpression && JSClassUtils.isES6ClassImplementation(psiElement)) {
                return JSResolveUtil.calculateStaticFromContext(psiElement);
            }
            return false;
        }
        return JSResolveUtil.calculateStaticFromContext(psiElement);
    }

    private static int calculateOffset(PsiFile file2, PsiFile realFile, InsertPlaceInfo insertPlaceInfo) {
        int offset;
        TextRange anchorRange = insertPlaceInfo.anchor.getTextRange();
        int n = offset = insertPlaceInfo.insertAtEnd ? anchorRange.getEndOffset() : anchorRange.getStartOffset();
        if (file2 != realFile || file2 instanceof XmlFile) {
            PsiFile anchorContainingFile = insertPlaceInfo.anchor.getContainingFile();
            PsiElement anchorFileContext = anchorContainingFile.getContext();
            if (anchorFileContext != null) {
                if (anchorFileContext instanceof XmlText) {
                    if (insertPlaceInfo.cdataStartOffset != 0) {
                        offset += insertPlaceInfo.cdataStartOffset;
                    } else {
                        int cdataOffset = 0;
                        if (anchorFileContext instanceof XmlTextImpl && anchorFileContext.getText().contains("<![CDATA[")) {
                            XmlTextImpl containingText = (XmlTextImpl)anchorFileContext;
                            cdataOffset = containingText.getCDATAInterior().getStartOffset() - "<![CDATA[".length();
                        }
                        offset += ((XmlText)anchorFileContext).displayToPhysical(cdataOffset);
                    }
                }
                offset += anchorFileContext.getTextOffset();
            } else if (insertPlaceInfo.cdataStartOffset != 0) {
                offset = insertPlaceInfo.cdataStartOffset;
            }
        } else if (insertPlaceInfo.anchor instanceof JSFile) {
            JSSourceElement[] statements = ((JSFile)insertPlaceInfo.anchor).getStatements();
            JSSourceElement lastImport = null;
            for (JSSourceElement element : statements) {
                if (!(element instanceof ES6ImportDeclaration)) break;
                lastImport = element;
            }
            if (lastImport != null) {
                offset = lastImport.getTextRange().getEndOffset();
            }
        }
        return offset;
    }

    protected boolean produceDeclarationInScope(PsiElement element) {
        JSElement scope = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSPackageStatement.class, JSClass.class, TypeScriptObjectType.class, JSObjectLiteralExpression.class});
        if (DialectDetector.isActionScript(element)) {
            return !(scope instanceof JSPackageStatement);
        }
        return scope != null;
    }

    @NotNull
    protected Pair<JSReferenceExpression, PsiElement> calculateAnchors(PsiElement psiElement) {
        JSReferenceExpression expression = (JSReferenceExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{JSReferenceExpression.class});
        return new Pair((Object)expression, (Object)expression);
    }

    public static void navigate(@NotNull Project project, @NotNull Editor editor, int offset, VirtualFile vfile) {
        if (project == null) {
            BaseCreateFix.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            BaseCreateFix.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            editor.getCaretModel().moveToOffset(offset);
        } else {
            PsiNavigationSupport.getInstance().createNavigatable(project, vfile, offset).navigate(true);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    private static PsiElement findInsertionAnchorForScope(PsiElement jsClass, boolean isFieldOrVariable) {
        PsiElement element;
        PsiElement candidate;
        ASTNode next;
        ASTNode node;
        PsiElement elementContainer = jsClass;
        if (jsClass instanceof TypeScriptInterface && DialectDetector.isTypeScript(jsClass)) {
            elementContainer = ((TypeScriptInterface)jsClass).getBody();
        }
        if (isFieldOrVariable && (node = elementContainer.getNode().findChildByType(LBRACE_LIKE_TOKENS)) != null && (next = node.getTreeNext()) != null && (candidate = JSChangeUtil.findInsertionPlaceStartingFrom(element = next.getPsi(), false, elementContainer instanceof JSObjectLiteralExpression ? ourObjectLiteralFieldLikeFilter : (elementContainer instanceof TypeScriptEnum ? ourEnumFilter : ourFilter))) != null) {
            return candidate;
        }
        return elementContainer.getLastChild().getPrevSibling();
    }

    private static boolean doesNotContainNewline(PsiElement nextLeaf) {
        return !(nextLeaf instanceof PsiWhiteSpace) && !(nextLeaf instanceof XmlToken) || nextLeaf.getText().indexOf(10) == -1;
    }

    protected boolean isIntroducingVariable() {
        return false;
    }

    private static PsiElement findInsertionPlaceBackward(PsiElement anchor) {
        ASTNode node;
        PsiElement anchorPrevSibling;
        while (!((anchorPrevSibling = anchor.getPrevSibling()) == null || anchorPrevSibling instanceof JSVarStatement || anchorPrevSibling instanceof JSImportStatement || anchorPrevSibling instanceof JSProperty || anchor instanceof PsiWhiteSpace && anchor.getText().contains("\n") && anchorPrevSibling instanceof PsiComment || (node = anchorPrevSibling.getNode()) != null && LBRACE_LIKE_TOKENS.contains(node.getElementType()))) {
            anchor = anchorPrevSibling;
        }
        return anchor;
    }

    private static boolean toSkipElement(PsiElement nextSibling) {
        return nextSibling instanceof PsiComment || nextSibling instanceof JSImportStatement || nextSibling instanceof JSVarStatement;
    }

    @Nullable
    public static Editor getEditor(@NotNull Project project, @NotNull PsiFile realFile) {
        if (project == null) {
            BaseCreateFix.$$$reportNull$$$0(5);
        }
        if (realFile == null) {
            BaseCreateFix.$$$reportNull$$$0(6);
        }
        return FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, realFile.getVirtualFile(), 0), true);
    }

    protected abstract void buildTemplate(Template var1, @Nullable JSReferenceExpression var2, boolean var3, @NotNull PsiElement var4);

    @Nullable
    public static PsiElement resolveScopeFromQualifier(@NotNull JSReferenceExpression qualifier) {
        PsiElement resolvedElement;
        if (qualifier == null) {
            BaseCreateFix.$$$reportNull$$$0(7);
        }
        if ((resolvedElement = qualifier.resolve()) != null) {
            PsiElement meaningfulElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolvedElement);
            if (meaningfulElement instanceof JSInitializerOwner) {
                meaningfulElement = ((JSInitializerOwner)meaningfulElement).getInitializer();
            }
            return meaningfulElement instanceof JSObjectLiteralExpression || meaningfulElement instanceof JSClass || meaningfulElement instanceof TypeScriptModule || meaningfulElement instanceof JSFile ? meaningfulElement : null;
        }
        return null;
    }

    protected static PsiElement getScope(JSExpression qualifier, PsiFile file2) {
        PsiElement sourceElement;
        if (qualifier instanceof JSThisExpression) {
            PsiElement result2 = ((JSThisExpression)qualifier).resolve();
            if (result2 instanceof JSClass) {
                return result2;
            }
            if (result2 instanceof JSInitializerOwner) {
                result2 = ((JSInitializerOwner)result2).getInitializer();
            }
            if (result2 instanceof JSObjectLiteralExpression) {
                return result2;
            }
        }
        JSSimpleTypeProcessor processor = new JSSimpleTypeProcessor();
        JSTypeEvaluator.evaluateTypes(qualifier, file2, processor);
        JSType type = processor.getType();
        PsiElement source = null;
        JSTypeEvaluationResult result3 = processor.getResult();
        if (result3 != null) {
            for (JSTypeEvaluationResult.JSTypeEvaluationResultElement resultElement : result3.getResults()) {
                PsiElement candidateSource = resultElement.getSource();
                if (!BaseCreateFix.isAcceptableScope(candidateSource)) continue;
                source = candidateSource;
                break;
            }
        }
        if ((type = JSTypeUtils.unwrapType(TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type))) instanceof JSGenericTypeImpl) {
            type = JSTypeUtils.unwrapType(((JSGenericTypeImpl)type).getType());
        }
        if (type != null && !BaseCreateFix.isAcceptableScope(source)) {
            source = JSClassResolver.findClassFromNamespace(type.getResolvedTypeText(), (PsiElement)file2);
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)file2);
        if (type == null && source == null && dialect != null && !dialect.isECMA4 && qualifier instanceof JSReferenceExpression) {
            return BaseCreateFix.resolveScopeFromQualifier((JSReferenceExpression)qualifier);
        }
        if (type instanceof JSSimpleRecordTypeImpl && BaseCreateFix.isAcceptableScope(sourceElement = type.getSource().getSourceElement())) {
            return sourceElement;
        }
        if (type != null && source == null && dialect != null && dialect.isTypeScript) {
            List<JSClass> names = TypeScriptClassResolver.getInstance().findClassesByQName(type.getResolvedTypeText(), JSResolveUtil.getResolveScope((PsiElement)file2));
            for (JSClass name : names) {
                if (!name.getContainingFile().isEquivalentTo((PsiElement)file2)) continue;
                return name;
            }
            if (names.size() == 0 && type instanceof JSResolvableType) {
                JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
                JSClass classDeclaration = info.getDeclarationOfType(JSClass.class);
                if (classDeclaration != null) {
                    return classDeclaration;
                }
                TypeScriptModule module = info.getDeclarationOfType(TypeScriptModule.class);
                if (module != null) {
                    return module;
                }
                return null;
            }
            return (PsiElement)ContainerUtil.getFirstItem(names);
        }
        return source;
    }

    private static boolean isAcceptableScope(@Nullable PsiElement sourceElement) {
        return sourceElement instanceof JSClass || sourceElement instanceof TypeScriptObjectType || sourceElement instanceof JSObjectLiteralExpression || sourceElement instanceof XmlFile || sourceElement instanceof JSFile;
    }

    protected void addAccessModifier(Template template, @NotNull JSReferenceExpression referenceExpression, boolean staticContext, @NotNull JSClass targetClass) {
        if (referenceExpression == null) {
            BaseCreateFix.$$$reportNull$$$0(8);
        }
        if (targetClass == null) {
            BaseCreateFix.$$$reportNull$$$0(9);
        }
        boolean isConstructor = referenceExpression.getParent() instanceof JSNewExpression;
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)targetClass);
        if (DialectDetector.hasFeature(dialect, JSLanguageFeature.VISIBILITY_MODIFIERS)) {
            JSClass classOfContextRef = JSResolveUtil.getClassOfContext((PsiElement)referenceExpression);
            if (!isConstructor && targetClass.isEquivalentTo((PsiElement)classOfContextRef)) {
                if (!JSUtils.isPrivateFieldSharpAccessContext((PsiElement)referenceExpression)) {
                    template.addTextSegment("private ");
                }
            } else if (dialect.isECMA4) {
                if (!targetClass.isInterface()) {
                    JSAttributeList attributeList = targetClass.getAttributeList();
                    if (attributeList != null && attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC || classOfContextRef != null && JSPsiImplUtils.differentPackageName(JSResolveUtil.getPackageName((PsiElement)targetClass), JSResolveUtil.getPackageName((PsiElement)classOfContextRef))) {
                        template.addTextSegment("public ");
                    } else {
                        template.addTextSegment("internal ");
                    }
                }
            } else if (dialect.isTypeScript && !targetClass.isInterface() && !(targetClass instanceof TypeScriptEnum) && TypeScriptCodeStyleSettings.getTypeScriptSettings((PsiElement)targetClass).USE_PUBLIC_MODIFIER) {
                template.addTextSegment("public ");
            }
        }
        if (staticContext) {
            template.addTextSegment("static ");
        }
    }

    protected void addCompletionVar(Template template) {
        MacroCallNode paramTypeExpr = new MacroCallNode(MacroFactory.createMacro((String)"complete"));
        template.addVariable("__Type" + this.uniqueCounter++, (Expression)paramTypeExpr, (Expression)paramTypeExpr, true);
    }

    protected void addSemicolonSegment(Template template, PsiElement context) {
        String semicolon = JSCodeStyleSettings.getSemicolon(context);
        if (semicolon.length() > 0) {
            template.addTextSegment(semicolon);
        }
    }

    public static void addTypeVariable(Template template, String var, PsiElement context, String typeName) {
        String type = (String)WriteAction.compute(() -> (String)ImportUtils.importAndShortenReference((String)typeName, (PsiElement)context, (boolean)true, (boolean)true).first);
        ConstantNode paramTypeExpr = new ConstantNode(type);
        template.addVariable(var + "Type", (Expression)paramTypeExpr, (Expression)paramTypeExpr, true);
    }

    protected void guessTypeAndAddTemplateVariable(Template template, JSExpression referenceExpression, PsiElement context, boolean voidAllowed) {
        String type = BaseCreateFix.guessTypeForExpression(referenceExpression, context, voidAllowed);
        if (type == null) {
            this.addCompletionVar(template);
        } else {
            ConstantNode expression = new ConstantNode(type);
            template.addVariable("__type" + referenceExpression.getText(), (Expression)expression, (Expression)expression, true);
        }
    }

    public static String guessTypeForExpression(JSExpression referenceExpression, PsiElement context, boolean voidAllowed) {
        JSType jsType;
        PsiElement parent = referenceExpression.getParent();
        if ((parent instanceof JSExpression || parent instanceof JSProperty) && DialectDetector.isTypeScript(context)) {
            JSType expectedType;
            JSType jSType = expectedType = parent instanceof JSExpression ? JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parent) : JSDialectSpecificHandlersFactory.findExpectedType((JSProperty)parent, JSExpectedTypeKind.EXPECTED);
            if (expectedType != null && !JSTypeUtils.isAnyType(expectedType)) {
                if (!voidAllowed && expectedType instanceof JSVoidType) {
                    return null;
                }
                return BaseCreateFix.getTypeText(expectedType, context);
            }
        }
        boolean isCall = false;
        if (parent instanceof JSCallExpression) {
            isCall = true;
            parent = parent.getParent();
        }
        String type = null;
        JSExpression elementForWhichExprTypeToEvaluate = null;
        if (parent instanceof JSDefinitionExpression) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSAssignmentExpression) {
                elementForWhichExprTypeToEvaluate = ((JSAssignmentExpression)grandParent).getROperand();
            }
        } else if (parent instanceof JSReturnStatement) {
            JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, JSFunction.class);
            if (fun != null) {
                JSType returnType = fun.getReturnType();
                type = BaseCreateFix.isNamedType(returnType) ? JSImportHandlingUtil.resolveTypeName(JSTypeUtils.getTypeMatchingNamespace(returnType.getTypeText()), (PsiElement)fun) : (returnType == null ? null : returnType.getTypeText(JSType.TypeTextFormat.CODE));
            }
        } else if (parent instanceof JSExpressionStatement && voidAllowed) {
            type = "void";
        } else if (parent instanceof JSVariable) {
            JSVariable variable = (JSVariable)parent;
            type = BaseCreateFix.getPossibleTypeText(parent, variable.getJSType());
        } else if (parent instanceof JSArgumentList) {
            JSParameterItem parameter = JSResolveUtil.findParameterForUsedArgument(isCall ? (JSExpression)referenceExpression.getParent() : referenceExpression, (JSArgumentList)parent);
            if (parameter instanceof JSParameter && !parameter.isRest()) {
                JSParameter jsParameter = (JSParameter)parameter;
                type = BaseCreateFix.getPossibleTypeText((PsiElement)jsParameter, jsParameter.getJSType());
            }
        } else if (parent instanceof JSAssignmentExpression) {
            JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
            if (lOperand != null) {
                jsType = JSResolveUtil.getExpressionJSType(lOperand);
                type = jsType == null ? null : BaseCreateFix.getTypeText(jsType, context);
            }
        } else if (parent instanceof JSPrefixExpression) {
            type = BaseCreateFix.getNumberTypeForPrefixSuffixIncrement(context, type, ((JSPrefixExpression)parent).getOperationSign());
        } else if (parent instanceof JSPostfixExpression) {
            type = BaseCreateFix.getNumberTypeForPrefixSuffixIncrement(context, type, ((JSPostfixExpression)parent).getOperationSign());
        } else if (parent instanceof JSBinaryExpression) {
            JSBinaryExpression binOp = (JSBinaryExpression)parent;
            elementForWhichExprTypeToEvaluate = binOp.getLOperand() == referenceExpression ? binOp.getROperand() : binOp.getLOperand();
        } else if (referenceExpression instanceof JSReferenceExpression) {
            elementForWhichExprTypeToEvaluate = referenceExpression;
        }
        String expressionType = null;
        if (elementForWhichExprTypeToEvaluate != null) {
            jsType = JSResolveUtil.getExpressionJSType(elementForWhichExprTypeToEvaluate);
            if (jsType == null) {
                jsType = JSAnyType.get((PsiElement)elementForWhichExprTypeToEvaluate, false);
            }
            expressionType = BaseCreateFix.getTypeText(jsType, context);
        }
        if (expressionType != null && !expressionType.equals("*")) {
            type = expressionType;
        }
        if (type != null && context.getLanguage().is((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
            type = type.endsWith("[]") ? "Array" : (String)ImportUtils.importAndShortenReference((String)type, (PsiElement)referenceExpression, (boolean)true, (boolean)true).first;
        }
        return type;
    }

    @Nullable
    private static String getPossibleTypeText(@NotNull PsiElement context, JSType variableType) {
        if (context == null) {
            BaseCreateFix.$$$reportNull$$$0(10);
        }
        if (BaseCreateFix.isNamedType(variableType)) {
            if (DialectDetector.isTypeScript(context)) {
                return variableType.getTypeText(JSType.TypeTextFormat.CODE);
            }
            String typeText = variableType.getTypeText();
            return JSImportHandlingUtil.resolveTypeName(typeText, context);
        }
        return null;
    }

    private static boolean isNamedType(JSType variableType) {
        return variableType instanceof JSNamedType || variableType instanceof JSGenericTypeImpl || variableType instanceof JSArrayType;
    }

    private static String getNumberTypeForPrefixSuffixIncrement(@Nullable PsiElement context, @Nullable String type, @Nullable IElementType operationSign) {
        if (operationSign == JSTokenTypes.PLUSPLUS || operationSign == JSTokenTypes.MINUSMINUS) {
            DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
            return holder != null && holder.isECMA4 ? "int" : "Number";
        }
        return type;
    }

    private static PsiElement getClassLikeFromAlias(@NotNull TypeScriptTypeAlias element) {
        TypeScriptType typeDeclaration;
        if (element == null) {
            BaseCreateFix.$$$reportNull$$$0(11);
        }
        return (typeDeclaration = element.getTypeDeclaration()) instanceof TypeScriptObjectType ? typeDeclaration : null;
    }

    @Nullable
    protected static PsiElement findClass(PsiElement anchorParent) {
        if (anchorParent instanceof TypeScriptTypeAlias) {
            return BaseCreateFix.getClassLikeFromAlias((TypeScriptTypeAlias)anchorParent);
        }
        if (anchorParent instanceof JSClass) {
            return anchorParent;
        }
        if (anchorParent instanceof TypeScriptObjectType) {
            PsiElement parent = anchorParent.getParent();
            if (parent instanceof JSClass) {
                if (parent instanceof TypeScriptTypeAlias) {
                    return BaseCreateFix.getClassLikeFromAlias((TypeScriptTypeAlias)parent);
                }
                return parent;
            }
            return anchorParent;
        }
        if (anchorParent instanceof JSFile) {
            return JSResolveUtil.getXmlBackedClass((JSFile)anchorParent);
        }
        return null;
    }

    @Override
    protected boolean isAvailable(Project project, PsiElement element, Editor editor, PsiFile file2) {
        JSExpression qualifier;
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        Pair<JSReferenceExpression, PsiElement> anchor = this.calculateAnchors(element);
        JSExpression jSExpression = qualifier = anchor.first == null ? null : ((JSReferenceExpression)anchor.first).getQualifier();
        if (qualifier == null) {
            return true;
        }
        PsiElement scope = BaseCreateFix.getScope(qualifier, file2);
        this.myIsProperty = scope instanceof JSObjectLiteralExpression;
        if (dialect == null || !dialect.isECMA4 && !dialect.isTypeScript && !dialect.isFlow || qualifier instanceof JSThisExpression) {
            return true;
        }
        if (scope == null || dialect.isECMA4 && JSProjectUtil.isInLibrary(scope)) {
            return false;
        }
        if (dialect.isTypeScript) {
            PsiFile containingFile = scope.getContainingFile();
            if (containingFile == null) {
                return false;
            }
            VirtualFile virtualFile = containingFile.getVirtualFile();
            return virtualFile != null && !JSLibraryUtil.isProbableLibraryFile(virtualFile);
        }
        return true;
    }

    @NotNull
    public static String getTypeText(@NotNull JSType type, @Nullable PsiElement contextElement) {
        if (type == null) {
            BaseCreateFix.$$$reportNull$$$0(12);
        }
        if (type instanceof JSResolvableType && type instanceof JSTypeWithWidening) {
            type = ((JSTypeWithWidening)type).widen(true);
        }
        if (contextElement != null) {
            type = JSTypeUtils.copyWithLanguageOfContext(type, contextElement);
        }
        String string = type.getTypeText(JSType.TypeTextFormat.CODE);
        if (string == null) {
            BaseCreateFix.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialAnchor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/BaseCreateFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/BaseCreateFix";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInsertionScope";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "beforeStartTemplateAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveScopeFromQualifier";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAccessModifier";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleTypeText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getClassLikeFromAlias";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InsertPlaceInfo {
        public PsiElement anchor;
        public boolean insertAtEnd;
        public boolean toInsertNewLineAfter;
        public boolean addNewLineBefore;
        public int cdataStartOffset;

        public InsertPlaceInfo(PsiElement initialAnchor, PsiFile file2, boolean isMember, boolean isFieldNotMethod) {
            this.anchor = initialAnchor;
            if (this.anchor != null && isMember) {
                PsiElement anchorParent = this.anchor.getParent();
                XmlFile contextFile = null;
                if (anchorParent instanceof JSFile && anchorParent.getContext() != null) {
                    PsiElement context = anchorParent.getContext();
                    if (context instanceof XmlAttributeValue || context instanceof XmlText && !BaseCreateFix.SCRIPT_TAG_NAME.equals(((XmlTag)context.getParent()).getLocalName())) {
                        contextFile = (XmlFile)context.getContainingFile();
                    }
                } else if (file2 instanceof XmlFile && !(file2 instanceof HtmlFileImpl)) {
                    contextFile = (XmlFile)file2;
                }
                if (contextFile != null) {
                    XmlTag rootTag = contextFile.getDocument().getRootTag();
                    XmlBackedJSClass jsClass = XmlBackedJSClassFactory.getInstance().getXmlBackedClass(rootTag);
                    JSFile jsFile = ((XmlBackedJSClassImpl)jsClass).findFirstScriptTag();
                    if (jsFile != null) {
                        this.anchor = isFieldNotMethod ? JSChangeUtil.findInsertionPlaceStartingFrom(jsFile.getFirstChild(), true, (Function<? super PsiElement, Boolean>)ourFilter) : jsFile.getLastChild();
                    } else {
                        this.anchor = (PsiElement)WriteAction.compute(() -> InsertPlaceInfo.lambda$new$0((JSClass)jsClass));
                        this.insertAtEnd = true;
                    }
                } else if (anchorParent instanceof JSClass || anchorParent instanceof TypeScriptObjectType || anchorParent instanceof JSObjectLiteralExpression || anchorParent instanceof JSFile && anchorParent.getContext() != null) {
                    if (isFieldNotMethod) {
                        this.anchor = BaseCreateFix.findInsertionPlaceBackward(this.anchor);
                    } else {
                        this.insertAtEnd = true;
                    }
                }
            }
            boolean bl = this.toInsertNewLineAfter = !this.insertAtEnd;
            if (!this.toInsertNewLineAfter) {
                PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)this.anchor);
                if (nextLeaf != null && nextLeaf.getNode() != null && nextLeaf.getNode().getElementType() == XmlTokenType.XML_CDATA_START) {
                    this.cdataStartOffset += nextLeaf.getTextRange().getEndOffset() + 1;
                }
                if (BaseCreateFix.doesNotContainNewline(nextLeaf)) {
                    this.toInsertNewLineAfter = true;
                }
            } else if (!BaseCreateFix.doesNotContainNewline(this.anchor)) {
                this.toInsertNewLineAfter = false;
            }
            if (!this.insertAtEnd && this.anchor instanceof PsiWhiteSpace && this.anchor.textToCharArray()[0] == '\n') {
                this.addNewLineBefore = true;
                this.toInsertNewLineAfter = false;
            }
            if (!this.insertAtEnd && this.anchor instanceof PsiWhiteSpace) {
                int at = this.anchor.getText().indexOf("<![CDATA[");
                if (at != -1) {
                    this.cdataStartOffset += at + "<!CDATA[".length() + 1;
                    this.addNewLineBefore = true;
                } else if (this.anchor.getPrevSibling() == null && this.anchor.getContainingFile().getContext() != null) {
                    this.addNewLineBefore = true;
                }
            }
            if (this.insertAtEnd && this.anchor instanceof XmlToken && ((XmlToken)this.anchor).getTokenType() == XmlTokenType.XML_CDATA_START) {
                this.addNewLineBefore = true;
            }
            if (isMember) {
                if (this.anchor instanceof PsiWhiteSpace && BaseCreateFix.doesNotContainNewline(this.anchor)) {
                    PsiElement prevSibling = this.anchor.getPrevSibling();
                    if (prevSibling != null && !(prevSibling instanceof PsiWhiteSpace)) {
                        this.addNewLineBefore = true;
                    }
                } else if (this.insertAtEnd && (this.anchor instanceof JSVarStatement || this.anchor instanceof JSField)) {
                    this.addNewLineBefore = true;
                }
            }
            if (this.anchor != null && this.anchor.getParent() instanceof JSObjectLiteralExpression) {
                JSProperty previousProperty;
                PsiElement scope = this.anchor.getParent();
                JSProperty jSProperty = previousProperty = this.anchor instanceof JSProperty && this.insertAtEnd ? (JSProperty)this.anchor : (JSProperty)PsiTreeUtil.getPrevSiblingOfType((PsiElement)this.anchor, JSProperty.class);
                if (previousProperty != null) {
                    PsiElement nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)previousProperty);
                    if (nextElement != null && nextElement.getNode().getElementType() != JSTokenTypes.COMMA) {
                        PsiElement commaPsiElement = JSChangeUtil.createCommaPsiElement((PsiElement)previousProperty);
                        WriteAction.run(() -> previousProperty.getParent().addAfter(commaPsiElement, (PsiElement)previousProperty));
                    }
                    this.anchor = BaseCreateFix.findInsertionAnchorForScope(scope, isFieldNotMethod);
                }
            }
        }

        private static /* synthetic */ PsiElement lambda$new$0(JSClass jsClass) throws RuntimeException {
            return PsiTreeUtil.firstChild((PsiElement)((XmlBackedJSClassImpl)jsClass).createScriptTag().getContext());
        }
    }
}

