/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action.before;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileBeforeTaskDialog
extends DialogWrapper {
    private final JBCheckBox myFailOnErrors = new JBCheckBox(JavaScriptBundle.message((String)"typescript.before.task.check.errors", (Object[])new Object[0]));
    private final TextFieldWithHistoryWithBrowseButton myConfigPath;

    protected TypeScriptCompileBeforeTaskDialog(@Nullable Project project, boolean isSelected, @Nullable String defaultPath2) {
        super(project);
        this.myFailOnErrors.setSelected(isSelected);
        List<VirtualFile> files = project != null && !DumbService.getInstance((Project)project).isDumb() ? TypeScriptConfigService.Provider.get(project).getConfigFiles() : ContainerUtil.emptyList();
        NotNullProducer configsList = () -> ContainerUtil.map((Collection)files, el -> el.getPath());
        this.myConfigPath = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)JavaScriptBundle.message((String)"typescript.before.task.config.dialog.title", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileDescriptor((String)"json"), (NotNullProducer)configsList);
        this.myConfigPath.setText(StringUtil.notNullize((String)defaultPath2));
        this.setTitle(JavaScriptBundle.message((String)"typescript.before.task.title", (Object[])new Object[0]));
        this.init();
    }

    public boolean isFailOnError() {
        return this.myFailOnErrors.isSelected();
    }

    public String getConfigPath() {
        return this.myConfigPath.getText();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        FormBuilder builder = FormBuilder.createFormBuilder();
        builder.addComponent((JComponent)this.myFailOnErrors);
        builder.addLabeledComponent(JavaScriptBundle.message((String)"typescript.before.task.config.path", (Object[])new Object[0]), (JComponent)this.myConfigPath);
        JPanel panel2 = builder.getPanel();
        panel2.setPreferredSize(new Dimension(350, -1));
        return panel2;
    }
}

