/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.documentation;

import com.intellij.lang.javascript.documentation.JSDocBuilderParameterInfo;
import com.intellij.lang.javascript.documentation.JSDocBuilderSimpleInfo;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.documentation.JavaScriptQuickNavigateBuilder;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptThisType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.documentation.TypeScriptServiceQuickInfoParser;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptQuickNavigateBuilder
extends JavaScriptQuickNavigateBuilder {
    public static final int TIMEOUT_MILLIS = 500;

    @Override
    @Nullable
    public String getQuickNavigateInfoForNavigationElement(@NotNull PsiElement element, @NotNull PsiElement originalElement, boolean jsDoc) {
        String serviceResult;
        if (element == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(1);
        }
        if (!(TypeScriptQuickNavigateBuilder.isWhitelisted(originalElement) || jsDoc || StringUtil.isEmpty((String)(serviceResult = TypeScriptQuickNavigateBuilder.getServiceResult(element, originalElement))))) {
            String s = TypeScriptServiceQuickInfoParser.parseServiceText(element, serviceResult);
            if (Registry.is((String)"typescript.show.own.type")) {
                s = s + "<br/>[ide]<br/>" + super.getQuickNavigateInfoForNavigationElement(element, originalElement, false);
            }
            return s;
        }
        return super.getQuickNavigateInfoForNavigationElement(element, originalElement, jsDoc);
    }

    @Override
    @NotNull
    protected String getFunctionNameWithHtml(@NotNull JSFunctionItem functionItem, @NotNull JSTypeSubstitutor substitutor) {
        if (functionItem == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(2);
        }
        if (substitutor == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(3);
        }
        String name = super.getFunctionNameWithHtml(functionItem, substitutor);
        String generics = TypeScriptQuickNavigateBuilder.getGenerics((JSElement)functionItem, substitutor);
        String string = name + StringUtil.escapeXmlEntities((String)StringUtil.notNullize((String)generics));
        if (string == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static String getServiceResult(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        if (element == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(5);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(6);
        }
        Future<String> future = TypeScriptServiceQuickInfoParser.requestServiceQuickInfo(element, originalElement);
        return JSLanguageServiceUtil.awaitFuture(future, 500L);
    }

    private static boolean isWhitelisted(@NotNull PsiElement originalElement) {
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(7);
        }
        return originalElement instanceof JSThisExpression || originalElement instanceof TypeScriptThisType;
    }

    @Override
    @NotNull
    public CharSequence getFunctionDefinition(@NotNull JSFunctionItem functionItem, @NotNull String escapedName, @NotNull JSTypeSubstitutor substitutor, @NotNull Collection<JSDocBuilderParameterInfo> parameters, @NotNull JSDocBuilderSimpleInfo returnInfo, @NotNull PsiElement originalElement, boolean jsDoc) {
        TypeScriptServiceQuickInfoParser.ParsedInfo info;
        CharSequence highlighting;
        if (functionItem == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(8);
        }
        if (escapedName == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(9);
        }
        if (substitutor == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(10);
        }
        if (parameters == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(11);
        }
        if (returnInfo == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(12);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(13);
        }
        if (jsDoc && (highlighting = this.getServiceFunctionDefinition(functionItem, escapedName, substitutor, parameters, returnInfo, originalElement, info = TypeScriptQuickNavigateBuilder.getParsedServiceInfo((JSElement)functionItem, originalElement))) != null) {
            CharSequence charSequence = highlighting;
            if (charSequence == null) {
                TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(14);
            }
            return charSequence;
        }
        CharSequence charSequence = super.getFunctionDefinition(functionItem, escapedName, substitutor, parameters, returnInfo, originalElement, jsDoc);
        if (charSequence == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(15);
        }
        return charSequence;
    }

    @Nullable
    private CharSequence getServiceFunctionDefinition(@NotNull JSFunctionItem functionItem, @NotNull String escapedName, @NotNull JSTypeSubstitutor substitutor, @NotNull Collection<JSDocBuilderParameterInfo> parameters, @NotNull JSDocBuilderSimpleInfo returnInfo, @NotNull PsiElement originalElement, @Nullable TypeScriptServiceQuickInfoParser.ParsedInfo info) {
        if (functionItem == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(16);
        }
        if (escapedName == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(17);
        }
        if (substitutor == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(18);
        }
        if (parameters == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(19);
        }
        if (returnInfo == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(20);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(21);
        }
        if (info == null) {
            return null;
        }
        String rest = StringUtil.trimStart((String)info.myRestPartWithPlaceHolders, (String)"?");
        String rawNewName = info.myQName;
        if (!rest.startsWith("(")) {
            JSType type;
            if (rest.startsWith(":") && functionItem.isGetProperty() && (type = JSHtmlHighlightingUtil.parseType(StringUtil.trimStart((String)rest, (String)":").trim(), (PsiElement)functionItem)) != null) {
                JSDocBuilderSimpleInfo newReturnInfo = new JSDocBuilderSimpleInfo();
                newReturnInfo.setJSType(type);
                return this.buildForFunctionFromService(functionItem, escapedName, substitutor, parameters, returnInfo, originalElement, info, rawNewName, ContainerUtil.emptyList(), newReturnInfo);
            }
            return null;
        }
        JSFunction parsedFunction = TypeScriptQuickNavigateBuilder.parseFunctionText(rest, (PsiElement)functionItem);
        if (parsedFunction != null) {
            List<JSDocBuilderParameterInfo> newParameters = this.mapParametersToInfos((JSFunctionItem)parsedFunction);
            JSDocBuilderSimpleInfo newReturnInfo = this.mapReturnTypeToInfo((JSFunctionItem)parsedFunction);
            return this.buildForFunctionFromService(functionItem, escapedName, substitutor, parameters, returnInfo, originalElement, info, rawNewName, newParameters, newReturnInfo);
        }
        return null;
    }

    @NotNull
    private CharSequence buildForFunctionFromService(@NotNull JSFunctionItem functionItem, @NotNull String escapedName, @NotNull JSTypeSubstitutor substitutor, @NotNull Collection<JSDocBuilderParameterInfo> parameters, @NotNull JSDocBuilderSimpleInfo returnInfo, @NotNull PsiElement originalElement, @NotNull TypeScriptServiceQuickInfoParser.ParsedInfo info, String rawNewName, List<JSDocBuilderParameterInfo> newParameters, JSDocBuilderSimpleInfo newReturnInfo) {
        CharSequence highlighting;
        CharSequence ownSignature;
        if (functionItem == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(22);
        }
        if (escapedName == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(23);
        }
        if (substitutor == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(24);
        }
        if (parameters == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(25);
        }
        if (returnInfo == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(26);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(27);
        }
        if (info == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(28);
        }
        if ((ownSignature = this.appendOwnSignature(functionItem, escapedName, substitutor, parameters, returnInfo, originalElement, highlighting = TypeScriptQuickNavigateBuilder.restoreHolders(info, super.getFunctionDefinition(functionItem, StringUtil.escapeXmlEntities((String)rawNewName), JSTypeSubstitutor.EMPTY, newParameters, newReturnInfo, originalElement, true)))) != null) {
            CharSequence charSequence = ownSignature;
            if (charSequence == null) {
                TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(29);
            }
            return charSequence;
        }
        CharSequence charSequence = highlighting;
        if (charSequence == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(30);
        }
        return charSequence;
    }

    @Nullable
    private CharSequence appendOwnSignature(@NotNull JSFunctionItem functionItem, @NotNull String escapedName, @NotNull JSTypeSubstitutor substitutor, @NotNull Collection<JSDocBuilderParameterInfo> parameters, @NotNull JSDocBuilderSimpleInfo returnInfo, @NotNull PsiElement originalElement, CharSequence highlighting) {
        if (functionItem == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(31);
        }
        if (escapedName == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(32);
        }
        if (substitutor == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(33);
        }
        if (parameters == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(34);
        }
        if (returnInfo == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(35);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(36);
        }
        if (Registry.is((String)"typescript.show.own.type")) {
            CharSequence ownSignature = super.getFunctionDefinition(functionItem, escapedName, substitutor, parameters, returnInfo, originalElement, true);
            return highlighting + "\n[ide]\n" + ownSignature;
        }
        return null;
    }

    @NotNull
    private static CharSequence restoreHolders(@NotNull TypeScriptServiceQuickInfoParser.ParsedInfo info, @NotNull CharSequence highlighting) {
        if (info == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(37);
        }
        if (highlighting == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(38);
        }
        if (!info.myPlaceholders.isEmpty()) {
            for (JSHtmlHighlightingUtil.TextPlaceholder placeholder : info.myPlaceholders) {
                highlighting = placeholder.restoreText(highlighting);
            }
        }
        CharSequence charSequence = highlighting;
        if (charSequence == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(39);
        }
        return charSequence;
    }

    @Nullable
    private static JSFunction parseFunctionText(@NotNull String text, @NotNull PsiElement originalElement) {
        if (text == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(40);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(41);
        }
        try {
            String prefix = "function test";
            String suffix = " {}";
            JSExpression candidate = JSPsiElementFactory.createJSExpression(prefix + text + suffix, originalElement);
            if (PsiUtilCore.hasErrorElementChild((PsiElement)candidate) || !(candidate instanceof JSFunction) || candidate.getTextLength() != prefix.length() + suffix.length() + text.length()) {
                return null;
            }
            return (JSFunction)candidate;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(TypeScriptQuickNavigateBuilder.class).warn((Throwable)e);
            return null;
        }
    }

    @Override
    protected JSType appendOptionality(@NotNull JSElement variableOrField, @Nullable JSType declaredType, @Nullable JSType narrowedType, @NotNull StringBuilder builder, @NotNull PsiElement originalElement) {
        TypeScriptConfig config2;
        if (variableOrField == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(42);
        }
        if (builder == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(43);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(44);
        }
        if ((config2 = TypeScriptConfigUtil.getConfigForPsiFile(originalElement.getContainingFile())) != null && config2.strictNullChecks() && narrowedType != null && (!(narrowedType instanceof JSUnionType) || narrowedType instanceof JSUndefinedType || !TypeScriptTypeRelations.isUnionWithUndefinedType(narrowedType))) {
            return narrowedType;
        }
        return super.appendOptionality(variableOrField, declaredType, narrowedType, builder, originalElement);
    }

    @Override
    protected void appendTypeWithSeparatorForOwner(@NotNull JSElement typeOwner, @Nullable JSType toUse, @NotNull JSTypeSubstitutor substitutor, @NotNull StringBuilder builder, @NotNull PsiElement originalElement, boolean jsDoc) {
        if (typeOwner == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(45);
        }
        if (substitutor == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(46);
        }
        if (builder == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(47);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(48);
        }
        if (!jsDoc) {
            super.appendTypeWithSeparatorForOwner(typeOwner, toUse, substitutor, builder, originalElement, false);
            return;
        }
        if (this.appendServiceType(typeOwner, toUse, substitutor, builder, originalElement)) {
            return;
        }
        super.appendTypeWithSeparatorForOwner(typeOwner, toUse, substitutor, builder, originalElement, true);
    }

    private boolean appendServiceType(@NotNull JSElement typeOwner, @Nullable JSType toUse, @NotNull JSTypeSubstitutor substitutor, @NotNull StringBuilder builder, @NotNull PsiElement originalElement) {
        TypeScriptServiceQuickInfoParser.ParsedInfo info;
        if (typeOwner == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(49);
        }
        if (substitutor == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(50);
        }
        if (builder == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(51);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(52);
        }
        if ((info = TypeScriptQuickNavigateBuilder.getParsedServiceInfo(typeOwner, originalElement)) == null) {
            return false;
        }
        try {
            String part = info.myRestPartWithPlaceHolders;
            if (!part.startsWith(":") && !part.startsWith("?:")) {
                return false;
            }
            String serviceTypeText = part.substring(part.startsWith(":") ? 1 : 2).trim();
            JSType parsedServiceType = JSHtmlHighlightingUtil.parseType(serviceTypeText, originalElement);
            if (parsedServiceType != null) {
                CharSequence highlighting = TypeScriptQuickNavigateBuilder.restoreHolders(info, JSHtmlHighlightingUtil.getTypeWithLinksHtmlHighlighting(parsedServiceType, originalElement, false));
                if (Registry.is((String)"typescript.show.own.type")) {
                    this.appendType(originalElement, highlighting.toString(), builder);
                    builder.append("\n<span style='color:grey;'>[ide type]</span>");
                    super.appendTypeWithSeparatorForOwner(typeOwner, toUse, substitutor, builder, originalElement, true);
                } else {
                    this.appendType(originalElement, highlighting.toString(), builder);
                }
            } else {
                builder.append(TypeScriptQuickNavigateBuilder.restoreHolders(info, StringUtil.escapeXmlEntities((String)part)));
            }
            return true;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(TypeScriptQuickNavigateBuilder.class).warn((Throwable)e);
            return false;
        }
    }

    @Nullable
    private static TypeScriptServiceQuickInfoParser.ParsedInfo getParsedServiceInfo(@NotNull JSElement typeOwner, @NotNull PsiElement originalElement) {
        String serviceResult;
        if (typeOwner == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(53);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(54);
        }
        return (serviceResult = TypeScriptQuickNavigateBuilder.getServiceResult((PsiElement)typeOwner, originalElement)) == null ? null : TypeScriptServiceQuickInfoParser.parseServiceTextAsInfo(serviceResult);
    }

    @Override
    protected void appendVariableInitializer(@NotNull JSVariable variable, @NotNull StringBuilder result2) {
        if (variable == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(55);
        }
        if (result2 == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(56);
        }
        if (variable instanceof TypeScriptVariable && variable.isConst()) {
            return;
        }
        String text = variable.getLiteralOrReferenceInitializerText();
        if (text != null) {
            super.appendVariableInitializer(variable, result2);
        }
    }

    @Override
    protected void appendClassExtendsAndImplements(@NotNull JSClass jsClass, @NotNull PsiElement originalElement, @NotNull String packageNameOrEmptyString, @NotNull StringBuilder result2) {
        if (jsClass == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(57);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(58);
        }
        if (packageNameOrEmptyString == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(59);
        }
        if (result2 == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(60);
        }
        super.appendClassExtendsAndImplements(jsClass, originalElement, packageNameOrEmptyString, result2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 29: 
            case 30: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 29: 
            case 30: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 13: 
            case 21: 
            case 27: 
            case 36: 
            case 41: 
            case 44: 
            case 48: 
            case 52: 
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 2: 
            case 8: 
            case 16: 
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 3: 
            case 10: 
            case 18: 
            case 24: 
            case 33: 
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 29: 
            case 30: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/documentation/TypeScriptQuickNavigateBuilder";
                break;
            }
            case 9: 
            case 17: 
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedName";
                break;
            }
            case 11: 
            case 19: 
            case 25: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 12: 
            case 20: 
            case 26: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnInfo";
                break;
            }
            case 28: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighting";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableOrField";
                break;
            }
            case 43: 
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 45: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOwner";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNameOrEmptyString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/documentation/TypeScriptQuickNavigateBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionNameWithHtml";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionDefinition";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "buildForFunctionFromService";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreHolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfoForNavigationElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionNameWithHtml";
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 29: 
            case 30: 
            case 39: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getServiceResult";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isWhitelisted";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionDefinition";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getServiceFunctionDefinition";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "buildForFunctionFromService";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "appendOwnSignature";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "restoreHolders";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "parseFunctionText";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "appendOptionality";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "appendTypeWithSeparatorForOwner";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "appendServiceType";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getParsedServiceInfo";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "appendVariableInitializer";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "appendClassExtendsAndImplements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 29: 
            case 30: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

