/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.formatter.blocks;

import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSBlockContext;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.SubBlockVisitor;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSLocalAlignmentFactory;
import com.intellij.lang.javascript.types.TypeScriptClassElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.lang.typescript.formatter.TypedJsLocalAlignmentFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypedJSSubBlockVisitor
extends SubBlockVisitor {
    public TypedJSSubBlockVisitor(@Nullable JSBlock block, @Nullable ASTNodeBasedAlignmentFactory alignmentFactory, @NotNull JSBlockContext jsBlockContext) {
        if (jsBlockContext == null) {
            TypedJSSubBlockVisitor.$$$reportNull$$$0(0);
        }
        super(block, alignmentFactory, jsBlockContext);
    }

    @Override
    @Nullable
    protected Indent getIndent(ASTNode node, ASTNode child, @Nullable Indent sharedSmartIndent) {
        IElementType parentNodeElementType;
        IElementType nodeElementType = node.getElementType();
        IElementType childElementType = child.getElementType();
        ASTNode parentNode = node.getTreeParent();
        IElementType iElementType = parentNodeElementType = parentNode != null ? parentNode.getElementType() : null;
        if (parentNodeElementType instanceof TypeScriptClassElementType && JSElementTypes.FUNCTION_DECLARATIONS.contains(nodeElementType) && JSElementTypes.REFERENCE_EXPRESSION == childElementType) {
            return Indent.getNoneIndent();
        }
        if (JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS == nodeElementType && (JSTokenTypes.COMMENTS.contains(childElementType) || childElementType == JSTokenTypes.TYPE_KEYWORD)) {
            return Indent.getNoneIndent();
        }
        if (TypeScriptElementTypes.TYPE_MEMBERS.contains(nodeElementType)) {
            PsiElement identifier;
            PsiElement psi = node.getPsi();
            PsiElement psiElement = identifier = psi instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)psi).getNameIdentifier() : null;
            if (child == identifier || childElementType == ES6StubElementTypes.COMPUTED_NAME || JSTokenTypes.COMMENTS.contains(childElementType)) {
                return Indent.getNoneIndent();
            }
        }
        if (nodeElementType == JSStubElementTypes.CALL_SIGNATURE && childElementType == JSTokenTypes.NEW_KEYWORD || JSElementTypes.PARAMETER_LISTS.contains(childElementType)) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == TypeScriptStubElementTypes.INDEX_SIGNATURE && childElementType == JSTokenTypes.LBRACKET) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType instanceof TypeScriptClassElementType && childElementType == TypeScriptStubElementTypes.INDEX_SIGNATURE) {
            return Indent.getNormalIndent();
        }
        if (nodeElementType == TypeScriptStubElementTypes.IMPLICIT_MODULE && JSExtendedLanguagesTokenSetProvider.MODULES.contains(childElementType)) {
            return Indent.getNoneIndent();
        }
        if (childElementType == TypeScriptStubElementTypes.UNION_OR_INTERSECTION_TYPE) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == TypeScriptStubElementTypes.UNION_OR_INTERSECTION_TYPE && (childElementType == JSTokenTypes.OR || childElementType == JSTokenTypes.AND || FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child) == null)) {
            return Indent.getSmartIndent((Indent.Type)Indent.Type.CONTINUATION);
        }
        if (nodeElementType == TypeScriptStubElementTypes.MAPPED_TYPE) {
            if (childElementType == JSTokenTypes.LBRACE || childElementType == JSTokenTypes.RBRACE) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (nodeElementType == TypeScriptStubElementTypes.CONDITIONAL_TYPE && child != node.getFirstChildNode()) {
            return sharedSmartIndent;
        }
        if (nodeElementType == TypeScriptElementTypes.NAMED_GENERIC_ARGUMENT_TYPE) {
            return Indent.getContinuationWithoutFirstIndent();
        }
        if (nodeElementType == TypeScriptStubElementTypes.SPREAD_TYPE && childElementType == JSTokenTypes.DOT_DOT_DOT) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == TypeScriptStubElementTypes.TUPLE_TYPE && childElementType == JSTokenTypes.QUEST) {
            return Indent.getNoneIndent();
        }
        return super.getIndent(node, child, sharedSmartIndent);
    }

    @Override
    protected JSLocalAlignmentFactory createLocalAlignmentFactory(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            TypedJSSubBlockVisitor.$$$reportNull$$$0(1);
        }
        return new TypedJsLocalAlignmentFactory(this.myCommonSettings, this.myCustomSettings, this.myFormattingMode);
    }

    @Override
    @Nullable
    protected Wrap getWrap(ASTNode node, ASTNode child, @Nullable Wrap sharedWrap) {
        IElementType parentElementType;
        IElementType nodeElementType = node != null ? node.getElementType() : null;
        IElementType iElementType = parentElementType = node != null && node.getTreeParent() != null ? node.getTreeParent().getElementType() : null;
        if (TypeScriptStubElementTypes.UNION_OR_INTERSECTION_TYPE == nodeElementType && parentElementType == JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS && (child.getElementType() == JSTokenTypes.OR || child.getElementType() == JSTokenTypes.AND || FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child) == null)) {
            return this.getCurrentWrap(sharedWrap, this.myCustomSettings.UNION_TYPES_WRAP);
        }
        if (nodeElementType == TypeScriptStubElementTypes.CONDITIONAL_TYPE) {
            return this.getWrapForConditional(node, child, sharedWrap);
        }
        return super.getWrap(node, child, sharedWrap);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsBlockContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/formatter/blocks/TypedJSSubBlockVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createLocalAlignmentFactory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

