/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSVariablesWithInitializerPredicate;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSVariableDeclaringScope;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeWithWidening;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.inspection.TypeScriptExplicitMemberTypeInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptSpecifyTypeExplicitlyQuickFix
implements LocalQuickFix {
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"typescript.specify.type.explicitly", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            TypeScriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            TypeScriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(2);
        }
        JSElement element = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), (Class[])new Class[]{JSTypeDeclarationOwner.class, JSFunction.class});
        TypeScriptSpecifyTypeExplicitlyQuickFix.doSpecifyExplicitType(element);
    }

    public static void doSpecifyExplicitType(JSElement element) {
        if (element == null || TypeScriptExplicitMemberTypeInspection.getTypeDeclarationElement(element) != null) {
            return;
        }
        JSType inferredType = TypeScriptExplicitMemberTypeInspection.getInferredType((PsiElement)element);
        if (inferredType == null) {
            return;
        }
        String newTypeStr = TypeScriptSpecifyTypeExplicitlyQuickFix.getNewTypeString(element, inferredType);
        JSRefactoringUtil.setType(element, newTypeStr);
    }

    @Nullable
    public static String getNewTypeString(JSElement element, @NotNull JSType inferredType) {
        List<JSType> types2;
        List filteredTypes;
        if (inferredType == null) {
            TypeScriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(3);
        }
        inferredType = inferredType.transformTypeHierarchy(TypeScriptSpecifyTypeExplicitlyQuickFix::getTypeWithEnforcedLiteralStrictness);
        JSType expandedType = inferredType.substitute();
        if (element instanceof JSOptionalOwner && ((JSOptionalOwner)element).isOptional() && inferredType instanceof JSUnionType && (filteredTypes = ContainerUtil.filter(types2 = ((JSUnionType)inferredType).getTypes(), t -> !(t instanceof JSUndefinedType))).size() != types2.size()) {
            inferredType = JSCompositeTypeFactory.createUnionType(inferredType.getSource(), filteredTypes);
        }
        return expandedType instanceof JSUniqueSymbolTypeImpl && ((JSUniqueSymbolTypeImpl)expandedType).getElement() == element ? "unique symbol" : JSVariablesWithInitializerPredicate.formatType(inferredType, (PsiElement)element);
    }

    public static boolean isAvailable(@NotNull PsiElement context) {
        PsiElement parent;
        JSVarStatement statement;
        if (context == null) {
            TypeScriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(4);
        }
        if (context instanceof JSVariable && (statement = ((JSVariable)context).getStatement()) != null && (parent = statement.getParent()) instanceof JSVariableDeclaringScope) {
            return statement != ((JSVariableDeclaringScope)parent).getVarDeclaration();
        }
        return true;
    }

    @Nullable
    @Contract(value="null -> null")
    private static JSType getTypeWithEnforcedLiteralStrictness(@Nullable JSType t) {
        JSResolvedTypeInfo resolvedType;
        if (t instanceof JSLiteralType && ((JSLiteralType)t).allowWidening()) {
            return ((JSLiteralType)t).copyWithAllowWidening(false);
        }
        if (t instanceof JSResolvableType && t instanceof JSTypeWithWidening && ((JSTypeWithWidening)t).allowWidening() && (resolvedType = ((JSResolvableType)t).resolveType()).isEnumLiteral()) {
            return ((JSTypeWithWidening)t).copyWithAllowWidening(false);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspection/TypeScriptSpecifyTypeExplicitlyQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferredType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptSpecifyTypeExplicitlyQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNewTypeString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

