/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImports;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileInclude;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportResolveContext;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportSimpleResolveContextImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptSimpleFileInclude;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptFileImportsBase
implements TypeScriptFileImports {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final TypeScriptFileImportsResolver myResolver;
    @NotNull
    protected final TypeScriptFileInclude myChecker;
    @NotNull
    private final TypeScriptImportResolveContext myContext;

    @Nullable
    public static TypeScriptFileImportsImpl createFileImports(@NotNull PsiElement context) {
        PsiFile contextPsiFile;
        VirtualFile contextFile;
        if (context == null) {
            TypeScriptFileImportsBase.$$$reportNull$$$0(0);
        }
        if ((contextFile = (contextPsiFile = context.getContainingFile().getOriginalFile()).getVirtualFile()) == null) {
            return null;
        }
        Project project = context.getProject();
        TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(contextPsiFile);
        return config2 == null ? new TypeScriptFileImportsImpl(project, contextFile) : new TypeScriptFileImportsImpl(project, config2);
    }

    public TypeScriptFileImportsBase(@NotNull Project project, @NotNull TypeScriptConfig config2) {
        if (project == null) {
            TypeScriptFileImportsBase.$$$reportNull$$$0(1);
        }
        if (config2 == null) {
            TypeScriptFileImportsBase.$$$reportNull$$$0(2);
        }
        this(project, config2.getInclude(), config2.getResolveContext(), config2.getImportResolver());
    }

    public TypeScriptFileImportsBase(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            TypeScriptFileImportsBase.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            TypeScriptFileImportsBase.$$$reportNull$$$0(4);
        }
        this(project, (TypeScriptFileInclude)new TypeScriptSimpleFileInclude(file2), file2, new TypeScriptImportSimpleResolveContextImpl(file2));
    }

    public TypeScriptFileImportsBase(@NotNull Project project, @NotNull TypeScriptFileInclude checker, @NotNull VirtualFile file2, @NotNull TypeScriptImportResolveContext context) {
        if (project == null) {
            TypeScriptFileImportsBase.$$$reportNull$$$0(5);
        }
        if (checker == null) {
            TypeScriptFileImportsBase.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            TypeScriptFileImportsBase.$$$reportNull$$$0(7);
        }
        if (context == null) {
            TypeScriptFileImportsBase.$$$reportNull$$$0(8);
        }
        this(project, checker, context, TypeScriptImportsResolverProvider.getResolver(project, context, file2));
    }

    public TypeScriptFileImportsBase(@NotNull Project project, @NotNull TypeScriptFileInclude checker, @NotNull TypeScriptImportResolveContext context, @NotNull TypeScriptFileImportsResolver resolver) {
        if (project == null) {
            TypeScriptFileImportsBase.$$$reportNull$$$0(9);
        }
        if (checker == null) {
            TypeScriptFileImportsBase.$$$reportNull$$$0(10);
        }
        if (context == null) {
            TypeScriptFileImportsBase.$$$reportNull$$$0(11);
        }
        if (resolver == null) {
            TypeScriptFileImportsBase.$$$reportNull$$$0(12);
        }
        this.myProject = project;
        this.myChecker = checker;
        this.myContext = context;
        this.myResolver = resolver;
    }

    @Override
    @Nullable
    public final VirtualFile resolveFile(@NotNull String normalizedModulePath, @NotNull VirtualFile containingFile) {
        if (normalizedModulePath == null) {
            TypeScriptFileImportsBase.$$$reportNull$$$0(13);
        }
        if (containingFile == null) {
            TypeScriptFileImportsBase.$$$reportNull$$$0(14);
        }
        return this.myResolver.resolveFileModule(normalizedModulePath, containingFile);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeScriptFileImportsBase imports = (TypeScriptFileImportsBase)o;
        if (!this.myContext.equals(imports.myContext)) {
            return false;
        }
        return this.myChecker.equals(imports.myChecker);
    }

    @Override
    public final boolean includesInPattern(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptFileImportsBase.$$$reportNull$$$0(15);
        }
        return this.myChecker.accept(file2);
    }

    public final int hashCode() {
        int result2 = this.myChecker.hashCode();
        result2 = 31 * result2 + this.myContext.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedModulePath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptFileImportsBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileImports";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "includesInPattern";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

