/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.naming;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.naming.ConventionInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FunctionNamingConventionJSInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 4;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        return JSFixFactory.getInstance().renameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        String functionName = ((PsiElement)args[0]).getText();
        assert (functionName != null);
        if (functionName.length() < this.getMinLength()) {
            return InspectionJSBundle.message("function.name.is.too.short.error.string", functionName);
        }
        if (functionName.length() > this.getMaxLength()) {
            return InspectionJSBundle.message("function.name.is.too.long.error.string", functionName);
        }
        return InspectionJSBundle.message("function.name.doesnt.match.regex.error.string", functionName, this.getRegex());
    }

    @Override
    @NonNls
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function2) {
            JSDocComment docComment;
            if (function2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSFunctionDeclaration(function2);
            if (FunctionNamingConventionJSInspection.this.isInvalidName((PsiNameIdentifierOwner)function2) && ((docComment = JSDocumentationUtils.findOwnDocComment((PsiElement)function2)) == null || !docComment.isClassExplicitly() && !function2.isConstructor())) {
                this.registerFunctionError(function2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/naming/FunctionNamingConventionJSInspection$Visitor", "visitJSFunctionDeclaration"));
        }
    }
}

