/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.utils;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.utils.ComparisonUtils;
import com.sixrr.inspectjs.utils.ConditionalUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoolUtils {
    private BoolUtils() {
    }

    public static boolean isNegation(@NotNull JSExpression exp) {
        if (exp == null) {
            BoolUtils.$$$reportNull$$$0(0);
        }
        return exp instanceof JSPrefixExpression && ((JSPrefixExpression)exp).getOperationSign() == JSTokenTypes.EXCL;
    }

    @Contract(value="null -> false")
    public static boolean isTrueLiteral(@Nullable JSExpression expression) {
        return ConditionalUtils.isLiteralWithKind(expression, JSLiteralExpressionKind.TRUE);
    }

    @Contract(value="null -> false")
    public static boolean isFalseLiteral(@Nullable JSExpression expression) {
        return ConditionalUtils.isLiteralWithKind(expression, JSLiteralExpressionKind.FALSE);
    }

    public static String getNegatedExpressionText(@NotNull JSExpression condition) {
        if (condition == null) {
            BoolUtils.$$$reportNull$$$0(1);
        }
        if (condition instanceof JSParenthesizedExpression) {
            JSExpression contentExpression = ((JSParenthesizedExpression)condition).getInnerExpression();
            return '(' + BoolUtils.getNegatedExpressionText(contentExpression) + ')';
        }
        if (BoolUtils.isNegation(condition)) {
            JSExpression negated = BoolUtils.getNegated(condition);
            return negated.getText();
        }
        if (ComparisonUtils.isComparison(condition)) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)condition;
            IElementType sign = binaryExpression.getOperationSign();
            String negatedComparison = ComparisonUtils.getNegatedComparison(sign);
            JSExpression lhs = binaryExpression.getLOperand();
            JSExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return lhs.getText() + negatedComparison;
            }
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        if (JSParenthesesUtils.getPrecedence(condition) > 3) {
            return "!(" + condition.getText() + ')';
        }
        return '!' + condition.getText();
    }

    private static JSExpression getNegated(@NotNull JSExpression exp) {
        if (exp == null) {
            BoolUtils.$$$reportNull$$$0(2);
        }
        JSPrefixExpression prefixExp = (JSPrefixExpression)exp;
        JSExpression operand = prefixExp.getExpression();
        return JSParenthesesUtils.stripParentheses(operand);
    }

    public static boolean isBoolean(@NotNull JSExpression expression, boolean allowNullable) {
        if (expression == null) {
            BoolUtils.$$$reportNull$$$0(3);
        }
        if (expression instanceof JSParenthesizedExpression) {
            expression = JSUtils.unparenthesize(expression);
        }
        if (expression == null) {
            return false;
        }
        boolean isBooleanExpression = false;
        if (expression instanceof JSBinaryExpression) {
            IElementType sign = ((JSBinaryExpression)expression).getOperationSign();
            boolean bl = isBooleanExpression = sign != null && (JSTokenTypes.RELATIONAL_OPERATIONS.contains(sign) || JSTokenTypes.EQUALITY_OPERATIONS.contains(sign));
        }
        if (isBooleanExpression) {
            return true;
        }
        if (allowNullable || DialectDetector.isActionScript((PsiElement)expression) || DialectDetector.isTypeScript((PsiElement)expression) && TypeScriptConfigUtil.strictNullChecks((PsiElement)expression)) {
            JSType type = JSResolveUtil.getExpressionJSType(expression);
            return type instanceof JSBooleanType || type instanceof JSUnionOrIntersectionType && ((JSUnionOrIntersectionType)type).getTypes().stream().allMatch(t -> t instanceof JSBooleanType);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/sixrr/inspectjs/utils/BoolUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isNegation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getNegatedExpressionText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getNegated";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isBoolean";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

