/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.python.psi.resolve.PyThirdPartySdkDetector;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/appengine/AppEngineSdkDetector;", "Lcom/jetbrains/python/psi/resolve/PyThirdPartySdkDetector;", "()V", "isInThirdPartySdk", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.python"})
public final class AppEngineSdkDetector
implements PyThirdPartySdkDetector {
    @Override
    public boolean isInThirdPartySdk(@NotNull PsiElement element) {
        VirtualFile virtualFile2;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"ModuleUtilCore.findModul\u2026(element) ?: return false");
        Module module2 = module;
        AppEngineFacet appEngineFacet = AppEngineFacet.getInstance(module2);
        if (appEngineFacet == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)appEngineFacet), (String)"AppEngineFacet.getInstance(module) ?: return false");
        AppEngineFacet facet = appEngineFacet;
        AppEngineFacetConfiguration appEngineFacetConfiguration = (AppEngineFacetConfiguration)facet.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)appEngineFacetConfiguration, (String)"facet.configuration");
        String string = appEngineFacetConfiguration.getSdkFolder();
        if (string == null) {
            return false;
        }
        String sdkFolder = string;
        if (element instanceof PsiDirectory) {
            virtualFile2 = ((PsiDirectory)element).getVirtualFile();
        } else {
            PsiFile psiFile = element.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"element.containingFile");
            virtualFile2 = psiFile.getVirtualFile();
        }
        VirtualFile file2 = virtualFile2;
        VirtualFile virtualFile3 = VfsUtil.findFile((Path)Paths.get(sdkFolder, new String[0]), (boolean)false);
        if (virtualFile3 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"VfsUtil.findFile(Paths.g\u2026), false) ?: return false");
        VirtualFile sdkRoot = virtualFile3;
        return VfsUtil.isAncestor((VirtualFile)sdkRoot, (VirtualFile)file2, (boolean)false);
    }
}

