/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.facet;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.django.facet.DjangoWizardSettingsHolder;
import com.jetbrains.python.sdk.flavors.WinPythonSdkFlavor;
import java.io.File;
import java.util.ArrayList;

public class AppEngineWizardSettingsHolder
extends DjangoWizardSettingsHolder {
    private static final String PYTHON_APP_ENGINE_SDK_PATH = "python.app.engine.sdk.path";
    private String myApplicationId;
    private String myAppEngineSdkFolder = AppEngineWizardSettingsHolder.getDefaultAppEngineSdkFolder();
    private String myThirdPartyLib;

    public static String getDefaultAppEngineSdkFolder() {
        PropertiesComponent props = PropertiesComponent.getInstance();
        if (!props.isValueSet(PYTHON_APP_ENGINE_SDK_PATH)) {
            String path = AppEngineWizardSettingsHolder.autodetectAppEngineSdkFolder();
            props.setValue(PYTHON_APP_ENGINE_SDK_PATH, path);
        }
        return props.getValue(PYTHON_APP_ENGINE_SDK_PATH);
    }

    private static String autodetectAppEngineSdkFolder() {
        String candidate;
        if (SystemInfo.isMac && AppEngineUtil.isStandaloneAppEgineSdkFolder(candidate = "/usr/local/google_appengine")) {
            return candidate;
        }
        if (SystemInfo.isWindows) {
            ArrayList candidates2 = new ArrayList();
            WinPythonSdkFlavor.findInPath(candidates2, "dev_appserver.py");
            if (!candidates2.isEmpty()) {
                return new File((String)candidates2.get(0)).getParent();
            }
        }
        return "";
    }

    public String getApplicationId() {
        return this.myApplicationId;
    }

    public void setApplicationId(String applicationId) {
        this.myApplicationId = applicationId;
    }

    public String getAppEngineSdkFolder() {
        return this.myAppEngineSdkFolder;
    }

    public void setAppEngineSdkFolder(String path) {
        this.myAppEngineSdkFolder = path;
        AppEngineWizardSettingsHolder.setDefaultAppEngineSdkFolder(path);
    }

    public static void setDefaultAppEngineSdkFolder(String path) {
        if (!StringUtil.isEmptyOrSpaces((String)path)) {
            PropertiesComponent.getInstance().setValue(PYTHON_APP_ENGINE_SDK_PATH, path);
        }
    }

    public String getThirdPartyLib() {
        return this.myThirdPartyLib;
    }

    public void setThirdPartyLib(String thirdPartyLib) {
        this.myThirdPartyLib = thirdPartyLib;
    }
}

