/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.codeInsight;

import com.intellij.util.Processor;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.impl.PyEvaluator;
import org.jetbrains.annotations.Nullable;

final class DjangoFromQuerySetAsManagerFilter
implements Processor<PyElement> {
    @Nullable
    private final FQNamesProvider myAlwaysCopyMembersOfClass;

    DjangoFromQuerySetAsManagerFilter(@Nullable FQNamesProvider alwaysCopyMembersOfClass) {
        this.myAlwaysCopyMembersOfClass = alwaysCopyMembersOfClass;
    }

    DjangoFromQuerySetAsManagerFilter() {
        this(null);
    }

    public boolean process(@Nullable PyElement t) {
        PyClass containingClass;
        if (this.myAlwaysCopyMembersOfClass != null && t instanceof PyPossibleClassMember && (containingClass = ((PyPossibleClassMember)((Object)t)).getContainingClass()) != null && NameResolverTools.isName(containingClass, this.myAlwaysCopyMembersOfClass)) {
            return true;
        }
        if (!(t instanceof PyFunction)) {
            return false;
        }
        PyFunction function = (PyFunction)t;
        boolean methodShouldBeCopied = function.getProtectionLevel() == PyFunction.ProtectionLevel.PUBLIC;
        for (PyAssignmentStatement assignmentStatement : function.findAttributes()) {
            Boolean querySetOnly;
            PyExpression expression = assignmentStatement.getLeftHandSideExpression();
            if (expression == null || !"queryset_only".equals(expression.getName()) || (querySetOnly = PyEvaluator.evaluateAsBoolean(assignmentStatement.getAssignedValue())) == null) continue;
            methodShouldBeCopied = querySetOnly == false;
            break;
        }
        return methodShouldBeCopied;
    }
}

