/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.facet;

import com.intellij.execution.ExecutionException;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableBase;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.django.facet.CreateProjectSettingsEditor;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetType;
import com.jetbrains.django.facet.DjangoWizardSettingsHolder;
import com.jetbrains.django.model.DjangoProjectCreatorAndConfigurator;
import com.jetbrains.django.run.DjangoServerRunConfigurationType;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.django.util.ModuleUtil;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.run.PyRunConfigurationFactory;
import com.jetbrains.python.run.PyRunConfigurationFactoryEx;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.templateLanguages.TemplatesService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoFacetSupportProvider
extends FacetBasedFrameworkSupportProvider<DjangoFacet> {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.django.facet.DjangoFacetSupportProvider");
    private DjangoWizardSettingsHolder mySettingsHolder;

    public DjangoFacetSupportProvider() {
        super((FacetType)DjangoFacetType.getInstance());
    }

    protected void setupConfiguration(DjangoFacet facet, ModifiableRootModel modifiableRootModel, FrameworkVersion frameworkVersion) {
    }

    private static VirtualFile getContentRoot(ModifiableRootModel modifiableRootModel) {
        return ModuleUtil.getFirstContentRoot(modifiableRootModel);
    }

    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            DjangoFacetSupportProvider.$$$reportNull$$$0(0);
        }
        return moduleType.equals((Object)PythonModuleTypeBase.getInstance());
    }

    @NotNull
    public FrameworkSupportConfigurableBase createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            DjangoFacetSupportProvider.$$$reportNull$$$0(1);
        }
        return new CreateProjectSettingsEditor(this, model);
    }

    @Nullable
    static String getDjangoPath(Sdk sdk, String customSdkFolder) {
        if (customSdkFolder != null) {
            return customSdkFolder;
        }
        return DjangoUtil.getDjangoPath(sdk);
    }

    protected void onFacetCreated(DjangoFacet facet, ModifiableRootModel rootModel, FrameworkVersion version) {
        super.onFacetCreated((Facet)facet, rootModel, version);
        Sdk sdk = rootModel.getSdk();
        if (sdk != null && sdk.getSdkType() instanceof PythonSdkType) {
            String templateLanguage;
            VirtualFile templatesFolder;
            this.mySettingsHolder.setSdk(sdk);
            String templatesFolderPath = this.mySettingsHolder.getTemplatesFolder();
            VirtualFile contentRoot = DjangoFacetSupportProvider.getContentRoot(rootModel);
            Module module = facet.getModule();
            ApplicationManager.getApplication().executeOnPooledThread(() -> DjangoFacetSupportProvider.createDjangoProject(sdk, contentRoot, module, this.mySettingsHolder));
            TemplatesService service = TemplatesService.getInstance(module);
            if (!StringUtil.isEmptyOrSpaces((String)templatesFolderPath) && (templatesFolder = contentRoot.findChild(templatesFolderPath)) != null) {
                service.setTemplateFolders(templatesFolder);
            }
            service.setTemplateLanguage((templateLanguage = this.mySettingsHolder.getTemplateLanguage()) == null ? "Django" : templateLanguage);
            StartupManager.getInstance((Project)rootModel.getProject()).runWhenProjectIsInitialized(() -> ((PyRunConfigurationFactoryEx)PyRunConfigurationFactory.getInstance()).createRunConfiguration(module, DjangoServerRunConfigurationType.getInstance().getDjangoFactory()));
        } else {
            Messages.showInfoMessage((String)DjangoBundle.message("need-python-sdk", new Object[0]), (String)DjangoBundle.message("project-create-error", new Object[0]));
        }
    }

    private static void createDjangoProject(@NotNull Sdk sdk, @NotNull VirtualFile contentRoot, @NotNull Module module, @NotNull DjangoWizardSettingsHolder settingsHolder) {
        if (sdk == null) {
            DjangoFacetSupportProvider.$$$reportNull$$$0(2);
        }
        if (contentRoot == null) {
            DjangoFacetSupportProvider.$$$reportNull$$$0(3);
        }
        if (module == null) {
            DjangoFacetSupportProvider.$$$reportNull$$$0(4);
        }
        if (settingsHolder == null) {
            DjangoFacetSupportProvider.$$$reportNull$$$0(5);
        }
        Project project = module.getProject();
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                DjangoProjectCreatorAndConfigurator.createProject(contentRoot, sdk, settingsHolder, module, null);
            }
            catch (ExecutionException e) {
                LOG.error("Error creating Django Facet", (Throwable)e);
            }
        }, DjangoBundle.message("django.creating.django.facet", new Object[0]), false, project));
    }

    void setSettingsHolder(DjangoWizardSettingsHolder settingsHolder) {
        this.mySettingsHolder = settingsHolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsHolder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/facet/DjangoFacetSupportProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForModuleType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfigurable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createDjangoProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

