/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.editor;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.lang.template.DjangoTemplateFileViewProvider;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.django.lang.template.psi.DjangoTemplatePsiUtil;
import com.jetbrains.django.lang.template.psi.impl.DjangoTagElementImpl;
import com.jetbrains.django.model.TagLibrary;
import com.jetbrains.django.util.DjangoTemplateUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EnterBetweenDjangoTagsHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file2 == null) {
            EnterBetweenDjangoTagsHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            EnterBetweenDjangoTagsHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            EnterBetweenDjangoTagsHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            EnterBetweenDjangoTagsHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            EnterBetweenDjangoTagsHandler.$$$reportNull$$$0(4);
        }
        if (file2.getViewProvider() instanceof DjangoTemplateFileViewProvider && EnterBetweenDjangoTagsHandler.isBetweenTags(file2.getViewProvider().getPsi((Language)DjangoTemplateLanguage.INSTANCE), editor2, (Integer)caretOffset.get())) {
            originalHandler.execute(editor2, editor2.getCaretModel().getCurrentCaret(), dataContext);
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean isBetweenTags(PsiFile file2, Editor editor2, int offset) {
        DjangoTagElementImpl endTag;
        List list;
        if (file2 == null) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor2.getDocument());
        PsiElement element = file2.findElementAt(offset);
        if (element == null || EnterBetweenDjangoTagsHandler.containsLineEnd(element)) {
            return false;
        }
        while ((element = element.getNextSibling()) instanceof PsiWhiteSpace && !EnterBetweenDjangoTagsHandler.containsLineEnd(element)) {
        }
        if (element instanceof OuterLanguageElement && (list = PsiTreeUtil.getInjectedElements((OuterLanguageElement)((OuterLanguageElement)element))).size() > 0) {
            element = (PsiElement)list.get(0);
        }
        if ((endTag = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)element, DjangoTagElementImpl.class)) == null) {
            return false;
        }
        String endTagName = DjangoTemplateUtil.getTagName(endTag);
        DjangoTagElementImpl prev = endTag;
        while ((prev = prev.getPrevSibling()) != null && DjangoTemplatePsiUtil.isWhiteSpaceOrComment((PsiElement)prev)) {
        }
        if (endTagName == null || !(prev instanceof DjangoTagElementImpl)) {
            return false;
        }
        DjangoTagElementImpl startTag = prev;
        TagLibrary lib = TagLibrary.getInstance(startTag.getProject());
        return lib.isPair(startTag, endTag);
    }

    private static boolean containsLineEnd(PsiElement element) {
        return element.getText().contains("\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/django/lang/template/editor/EnterBetweenDjangoTagsHandler";
        objectArray[2] = "preprocessEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

