/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.ref;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.lang.template.DjangoTemplateItemReference;
import com.jetbrains.django.lang.template.psi.impl.DjangoMemberNameImpl;
import com.jetbrains.django.lang.template.tags.DjangoUrlTag;
import com.jetbrains.django.ref.DjangoReferenceUtil;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.PythonStringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplateFileReferenceProvider
extends PsiReferenceProvider {
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
        if (psiElement == null) {
            DjangoTemplateFileReferenceProvider.$$$reportNull$$$0(0);
        }
        if (processingContext == null) {
            DjangoTemplateFileReferenceProvider.$$$reportNull$$$0(1);
        }
        if (!DjangoFacet.isPresent(psiElement)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DjangoTemplateFileReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (psiElement instanceof DjangoMemberNameImpl && DjangoTemplateFileReferenceProvider.getUrlTag(psiElement) != null) {
            StringBuilder sb = new StringBuilder();
            for (PsiElement el = psiElement; el != null; el = el.getPrevSibling()) {
                sb.insert(0, el.getText());
            }
            ArrayList result = Lists.newArrayList();
            result.addAll(DjangoTemplateFileReferenceProvider.getFSItemReferences(psiElement, sb.toString()));
            PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                DjangoTemplateFileReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            DjangoTemplateFileReferenceProvider.$$$reportNull$$$0(4);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    public static List<PsiReference> getFSItemReferences(@NotNull PsiElement element, @NotNull String path) {
        if (element == null) {
            DjangoTemplateFileReferenceProvider.$$$reportNull$$$0(5);
        }
        if (path == null) {
            DjangoTemplateFileReferenceProvider.$$$reportNull$$$0(6);
        }
        ArrayList result = Lists.newArrayList();
        PsiDirectory folder = DjangoUtil.getProjectRoot(element);
        if (folder != null) {
            folder = folder.getParent();
            String projectName = PythonStringUtil.getFirstPrefix(path, ".");
            String elementProjectName = DjangoUtil.getProjectName(element);
            String filePath = path.replace(".", "/");
            PsiFileSystemItem item = DjangoReferenceUtil.findProjectFSItem(folder, filePath);
            if (item == null && elementProjectName != null && !elementProjectName.equals(projectName)) {
                item = DjangoReferenceUtil.findProjectFSItem(folder, elementProjectName + "/" + filePath);
            }
            if (item == null) {
                item = DjangoReferenceUtil.findLibraryFSItem(filePath, element);
            }
            if (DjangoTemplateItemReference.isPossibleToCreate(element, item)) {
                result.add(new DjangoTemplateItemReference(element, item));
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            DjangoTemplateFileReferenceProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    public static DjangoUrlTag getUrlTag(PsiElement element) {
        return (DjangoUrlTag)PsiTreeUtil.getParentOfType((PsiElement)element, DjangoUrlTag.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/ref/DjangoTemplateFileReferenceProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/ref/DjangoTemplateFileReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFSItemReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFSItemReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

