/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.run;

import com.google.common.net.HostAndPort;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteProcessControl;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.django.DjangoRunnerUtilsKt;
import com.jetbrains.django.run.DjangoServerRunConfiguration;
import com.jetbrains.django.run.UrlFilterWithRedirection;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonProcessRunner;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class DjangoServerRunCommandLineState
extends PythonCommandLineState {
    private static final String COMMAND_RUNSERVER = "runserver";
    private static final String COMMAND_TESTSERVER = "testserver";
    private static final String COMMAND_RUNCONCURRENTSERVER = "runconcurrentserver";
    private static final String OPTION_NO_RELOAD = "--noreload";
    private static final String OPTION_ADDRPORT = "--addrport";
    private static final int DEFAULT_DJANGO_SERVER_PORT = 8000;
    private final DjangoServerRunConfiguration myConfig;

    public DjangoServerRunCommandLineState(DjangoServerRunConfiguration config, ExecutionEnvironment environment) {
        super(config, environment);
        this.myConfig = config;
        Module module = this.myConfig.getModule();
        if (module != null && !this.myConfig.getEnvs().containsKey("DJANGO_SETTINGS_MODULE") && !System.getenv().containsKey("DJANGO_SETTINGS_MODULE")) {
            DjangoUtil.addDjangoSettingsToEnv(module, this.myConfig.getEnvs(), false);
        }
    }

    @Override
    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        commandLine.withEnvironment(DjangoRunnerUtilsKt.fixEnvsIfNeeded(SystemInfo.isWin10OrNewer, commandLine.getEnvironment(), System.getenv()));
        return PythonProcessRunner.createProcessHandlingCtrlC(commandLine);
    }

    @Override
    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
        String additionalOptions;
        String host;
        Module module = this.myConfig.getModule();
        if (StringUtil.isEmpty((String)this.myConfig.getWorkingDirectory())) {
            commandLine.setWorkDirectory(DjangoUtil.getProjectRoot(module));
        } else {
            commandLine.setWorkDirectory(this.myConfig.getWorkingDirectory());
        }
        ParametersList params = commandLine.getParametersList();
        ParametersList parametersList = commandLine.getParametersList();
        ParamsGroup exe_options = parametersList.getParamsGroup("Exe Options");
        assert (exe_options != null);
        exe_options.addParametersString(this.myConfig.getInterpreterOptions());
        ParamsGroup scriptParams = params.getParamsGroup("Script");
        assert (scriptParams != null);
        String buildoutRunnerScript = DjangoUtil.getBuildoutRunnerScript(module);
        if (buildoutRunnerScript != null) {
            scriptParams.addParameter(buildoutRunnerScript);
        } else {
            String manageScript = DjangoUtil.getManageScript(module);
            if (manageScript.isEmpty()) {
                manageScript = DjangoUtil.getDjangoAdmin(this.myConfig.getInterpreterPath());
            }
            if (manageScript != null) {
                scriptParams.addParameter(manageScript);
            }
        }
        if (this.myConfig.isUseCustomRunCommand()) {
            scriptParams.addParameter(this.myConfig.getCustomRunCommand());
            if (this.isRunServerCommand() && this.needNoReload() || this.myConfig.isRunNoReload()) {
                scriptParams.addParameter(OPTION_NO_RELOAD);
            }
        } else if (!this.myConfig.isRunTestServer()) {
            scriptParams.addParameter(COMMAND_RUNSERVER);
            if (this.needNoReload()) {
                scriptParams.addParameter(OPTION_NO_RELOAD);
            }
        } else {
            scriptParams.addParameter(COMMAND_TESTSERVER);
        }
        String hostPort = null;
        Integer port = this.myConfig.getPort();
        if (port != null) {
            hostPort = Integer.toString(port);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(host = this.myConfig.getHost()))) {
            if (hostPort == null) {
                hostPort = "8000";
            }
            hostPort = host + ":" + hostPort;
        }
        if (hostPort != null) {
            if (this.myConfig.isRunTestServer()) {
                scriptParams.addParameter(OPTION_ADDRPORT);
            }
            scriptParams.addParameter(hostPort);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(additionalOptions = this.myConfig.getAdditionalOptions()))) {
            scriptParams.addParametersString(additionalOptions);
        }
    }

    private boolean isRunServerCommand() {
        String command = this.myConfig.getCustomRunCommand();
        return COMMAND_RUNSERVER.equals(command) || COMMAND_RUNCONCURRENTSERVER.equals(command);
    }

    @Override
    @NotNull
    protected UrlFilter createUrlFilter(ProcessHandler processHandler2) {
        int port;
        HostAndPort localTunnel;
        if (processHandler2 instanceof RemoteProcessControl && this.myConfig.getHost() != null && (localTunnel = ((RemoteProcessControl)processHandler2).getLocalTunnel(port = this.myConfig.getPort() != null ? this.myConfig.getPort() : 8000)) != null) {
            return new UrlFilterWithRedirection(Collections.singletonMap(HostAndPort.fromParts((String)this.myConfig.getHost(), (int)port), localTunnel));
        }
        UrlFilter urlFilter = super.createUrlFilter(processHandler2);
        if (urlFilter == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(0);
        }
        return urlFilter;
    }

    @Override
    @NotNull
    protected ConsoleView createAndAttachConsole(Project project, ProcessHandler processHandler2, Executor executor) throws ExecutionException {
        ConsoleView consoleView = super.createAndAttachConsole(project, processHandler2, executor);
        if (this.myConfig.isDjango13OnUnix() && !this.myConfig.isRunNoReload()) {
            consoleView.print("Starting server with Django 1.3 is only possible in --noreload mode.\nTo fix that, please, apply patch to your Django installation: http://code.djangoproject.com/changeset/15911\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
        if (DjangoUtil.getManageScript(this.myConfig.getModule()).isEmpty()) {
            consoleView.print("No manage.py file specified in Settings->Django Support\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
        ConsoleView consoleView2 = consoleView;
        if (consoleView2 == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(1);
        }
        return consoleView2;
    }

    private boolean needNoReload() {
        if (AppEngineFacet.isPresent(this.myConfig.getModule())) {
            return false;
        }
        return this.myConfig.isRunNoReload() || this.myConfig.isDjango13OnUnix();
    }

    @Override
    public boolean isMultiprocessDebug() {
        return !this.needNoReload();
    }

    @Override
    @NotNull
    protected ProcessHandler startProcess(PythonCommandLineState.PythonProcessStarter processStarter, CommandLinePatcher ... patchers2) throws ExecutionException {
        ProcessHandler processHandler2 = super.startProcess(processStarter, patchers2);
        DjangoServerRunCommandLineState.addRunBrowserListener(processHandler2, this.myConfig.getBrowserUrl(), "development server", (RunConfiguration)this.myConfig, this.myConfig.isLaunchJavascriptDebugger());
        ProcessHandler processHandler3 = processHandler2;
        if (processHandler3 == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(2);
        }
        return processHandler3;
    }

    public static void addRunBrowserListener(ProcessHandler processHandler2, final String url, final String signature, RunConfiguration runConfiguration, boolean launchJavascriptDebugger) {
        if (launchJavascriptDebugger && JavaScriptDebuggerStarter.Util.start((RunConfiguration)runConfiguration, (String)url)) {
            return;
        }
        if (!StringUtil.isEmpty((String)url)) {
            final Ref browserStarted = new Ref((Object)false);
            processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event2, @NotNull Key outputType) {
                    if (event2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (((Boolean)browserStarted.get()).booleanValue()) {
                        return;
                    }
                    if (StringUtil.toLowerCase((String)event2.getText()).contains(signature)) {
                        browserStarted.set((Object)true);
                        BrowserUtil.browse((String)url);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/django/run/DjangoServerRunCommandLineState$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/django/run/DjangoServerRunCommandLineState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createUrlFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAttachConsole";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

