/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.testRunner;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.testRunner.DjangoDotToElementConverter;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.testing.PyTestsLocator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DjangoTestTestIdUrlProvider
implements SMTestLocator,
DumbAware {
    private static final String PROTOCOL_ID = "django_testid";
    public static final DjangoTestTestIdUrlProvider INSTANCE = new DjangoTestTestIdUrlProvider();
    private static final Logger LOG = Logger.getInstance(DjangoTestTestIdUrlProvider.class);

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        VirtualFile[] rootsToCheck;
        if (protocol == null) {
            DjangoTestTestIdUrlProvider.$$$reportNull$$$0(0);
        }
        if (path == null) {
            DjangoTestTestIdUrlProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DjangoTestTestIdUrlProvider.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            DjangoTestTestIdUrlProvider.$$$reportNull$$$0(3);
        }
        LOG.debug(String.format("Starting %s, %s", protocol, path));
        if (!PROTOCOL_ID.equals(protocol)) {
            List<Location<? extends PsiElement>> locations = PyTestsLocator.INSTANCE.getLocation(protocol, path, project, scope);
            if (!locations.isEmpty()) {
                return new ArrayList<Location>(locations);
            }
            LOG.debug(String.format("Class supports protocol %s, but provided protocol is %s", PROTOCOL_ID, project));
            List<Location> list = Collections.emptyList();
            if (list == null) {
                DjangoTestTestIdUrlProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        Module module = DjangoUtil.getDjangoModule(project);
        if (module == null) {
            LOG.debug("No module with Django on project");
            List<Location> list = Collections.emptyList();
            if (list == null) {
                DjangoTestTestIdUrlProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        DjangoFacet facet = DjangoFacet.getInstance(module);
        if (facet == null) {
            LOG.debug("No django facet");
            List<Location> list = Collections.emptyList();
            if (list == null) {
                DjangoTestTestIdUrlProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        VirtualFile djangoProjectRoot = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile();
        if (djangoProjectRoot == null) {
            LOG.debug("Facet does not provide project root");
            List<Location> list = Collections.emptyList();
            if (list == null) {
                DjangoTestTestIdUrlProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = StringUtil.split((String)path, (String)".");
        if (list.isEmpty()) {
            LOG.debug(String.format("No locations found in %s", path));
            List<Location> list2 = Collections.emptyList();
            if (list2 == null) {
                DjangoTestTestIdUrlProvider.$$$reportNull$$$0(8);
            }
            return list2;
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile rootToCheck : rootsToCheck = (VirtualFile[])ArrayUtil.mergeArrays((Object[])new VirtualFile[]{djangoProjectRoot}, (Object[])ArrayUtil.mergeArrays((Object[])rootManager.getSourceRoots(true), (Object[])rootManager.getContentRoots()))) {
            LOG.debug(String.format("Checking root %s", rootToCheck));
            List<Location> locations = DjangoDotToElementConverter.getLocations(list, rootToCheck, project);
            if (locations.isEmpty()) continue;
            List<Location> list3 = locations;
            if (list3 == null) {
                DjangoTestTestIdUrlProvider.$$$reportNull$$$0(9);
            }
            return list3;
        }
        List<Location> list4 = Collections.emptyList();
        if (list4 == null) {
            DjangoTestTestIdUrlProvider.$$$reportNull$$$0(10);
        }
        return list4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/testRunner/DjangoTestTestIdUrlProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/testRunner/DjangoTestTestIdUrlProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

