/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.testRunner;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.django.DjangoRunnerUtilsKt;
import com.jetbrains.django.testRunner.DjangoTestTestIdUrlProvider;
import com.jetbrains.django.testRunner.DjangoTestsRunConfiguration;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.testing.PyTestLegacyInteropKt;
import com.jetbrains.python.testing.PythonTRunnerConsoleProperties;
import com.jetbrains.python.testing.PythonTestCommandLineStateBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DjangoTestsCommandLineState
extends PythonTestCommandLineStateBase<DjangoTestsRunConfiguration> {
    public DjangoTestsCommandLineState(DjangoTestsRunConfiguration configuration, ExecutionEnvironment env) {
        super(configuration, env);
    }

    protected Collection<String> collectPythonPath() {
        String root;
        ArrayList paths = Lists.newArrayList();
        Module module = ((DjangoTestsRunConfiguration)this.myConfiguration).getModule();
        if (module != null && (root = DjangoUtil.getProjectRoot(module)) != null) {
            return DjangoTestsCommandLineState.addDjangoRoot(paths, root);
        }
        return paths;
    }

    private static Collection<String> addDjangoRoot(@NotNull Collection<String> paths, @NotNull String root) {
        String filePath;
        if (paths == null) {
            DjangoTestsCommandLineState.$$$reportNull$$$0(0);
        }
        if (root == null) {
            DjangoTestsCommandLineState.$$$reportNull$$$0(1);
        }
        ArrayList<String> pathsList = new ArrayList<String>(paths);
        HashSet vals = Sets.newHashSet(paths);
        if (!vals.contains(filePath = FileUtil.toSystemDependentName((String)root))) {
            pathsList.add(0, filePath);
        }
        return pathsList;
    }

    @Override
    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        commandLine.withEnvironment(DjangoRunnerUtilsKt.fixEnvsIfNeeded(SystemInfo.isWin10OrNewer, commandLine.getEnvironment(), System.getenv()));
        if (!PyTestLegacyInteropKt.isNewTestsModeEnabled()) {
            commandLine.withEnvironment("_JB_USE_OLD_RUNNERS", "1");
        }
        return super.doCreateProcess(commandLine);
    }

    @Override
    protected void addBeforeParameters(GeneralCommandLine cmd) {
        ParamsGroup scriptGroup = Objects.requireNonNull(cmd.getParametersList().getParamsGroup("Script"));
        scriptGroup.addParameter("test");
        String options = ((DjangoTestsRunConfiguration)this.myConfiguration).getDjangoOptions();
        if (((DjangoTestsRunConfiguration)this.myConfiguration).isUseOptions() && !StringUtil.isEmptyOrSpaces((String)options)) {
            scriptGroup.addParametersString(options);
        }
    }

    @Override
    protected void addAfterParameters(GeneralCommandLine cmd) {
        ParamsGroup scriptGroup = Objects.requireNonNull(cmd.getParametersList().getParamsGroup("Script"));
        Module module = ((DjangoTestsRunConfiguration)this.myConfiguration).getModule();
        Project project = ((DjangoTestsRunConfiguration)this.myConfiguration).getProject();
        if (module == null) {
            module = DjangoUtil.getDjangoModule(project);
        }
        if (module != null) {
            VirtualFile manageFile = DjangoUtil.getManageFile(module);
            String projectRoot = null;
            if (manageFile != null) {
                projectRoot = manageFile.getParent().getPath();
            }
            if (projectRoot == null) {
                projectRoot = project.getBasePath();
            }
            assert (projectRoot != null);
            scriptGroup.addParameters(new String[]{FileUtil.toSystemDependentName((String)projectRoot)});
        }
    }

    @Override
    protected PythonHelper getRunner() {
        return PythonHelper.DJANGO_TEST_MANAGE;
    }

    @Override
    @NotNull
    protected List<String> getTestSpecs() {
        ArrayList<String> specs = new ArrayList<String>();
        String target = ((DjangoTestsRunConfiguration)this.myConfiguration).getTarget();
        if (!StringUtil.isEmptyOrSpaces((String)target)) {
            specs.addAll(StringUtil.split((String)target, (String)" "));
        }
        ArrayList<String> arrayList = specs;
        if (arrayList == null) {
            DjangoTestsCommandLineState.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    public void customizeEnvironmentVars(Map<String, String> envs, boolean passParentEnvs) {
        super.customizeEnvironmentVars(envs, passParentEnvs);
        Module module = ((DjangoTestsRunConfiguration)this.myConfiguration).getModule();
        if (module != null) {
            DjangoUtil.addCustomTestSettingsModule(module, envs, (DjangoTestsRunConfiguration)this.myConfiguration);
            DjangoUtil.addPyCharmManageModule(module, envs);
        }
        Collection<String> paths = this.collectPythonPath();
        PythonEnvUtil.addToPythonPath(envs, paths);
    }

    @Override
    protected PythonTRunnerConsoleProperties createConsoleProperties(Executor executor) {
        return new PythonTRunnerConsoleProperties((ModuleRunConfiguration)this.myConfiguration, executor, true, this.getTestLocator());
    }

    @Override
    protected SMTestLocator getTestLocator() {
        return DjangoTestTestIdUrlProvider.INSTANCE;
    }

    @Override
    protected void setWorkingDirectory(@NotNull GeneralCommandLine cmd) {
        String workingDirectory;
        if (cmd == null) {
            DjangoTestsCommandLineState.$$$reportNull$$$0(3);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(workingDirectory = ((DjangoTestsRunConfiguration)this.myConfiguration).getWorkingDirectory()))) {
            cmd.withWorkDirectory(workingDirectory);
        } else {
            String baseDir;
            Module module = ((DjangoTestsRunConfiguration)this.myConfiguration).getModule();
            if (module != null && !StringUtil.isEmptyOrSpaces((String)(baseDir = DjangoUtil.getProjectRoot(module)))) {
                cmd.withWorkDirectory(baseDir);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/testRunner/DjangoTestsCommandLineState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/testRunner/DjangoTestsCommandLineState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestSpecs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addDjangoRoot";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setWorkingDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

