/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.flask.codeInsight;

import com.intellij.codeInsight.daemon.DefaultGutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.jetbrains.flask.codeInsight.FlaskTemplateManager;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlaskLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        RelatedItemLineMarkerInfo<PsiFile> info;
        if (element == null) {
            FlaskLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            FlaskLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PyFunction) {
            RelatedItemLineMarkerInfo<PsiElement> info2 = FlaskLineMarkerProvider.createCodeLineMarker((PyFunction)element);
            if (info2 != null) {
                result.add(info2);
            }
        } else if (element instanceof PsiFile && ((PsiFile)element).getViewProvider() instanceof TemplateLanguageFileViewProvider && (info = FlaskLineMarkerProvider.createTemplateLineMarker((PsiFile)element)) != null) {
            result.add(info);
        }
    }

    @Nullable
    private static RelatedItemLineMarkerInfo<PsiElement> createCodeLineMarker(PyFunction function) {
        if (function.getText().contains("render_template")) {
            PsiElement identifier;
            ArrayList<PsiFile> referencedFiles = new ArrayList<PsiFile>();
            List<PyStringLiteralExpression> templateReferences = FlaskTemplateManager.collectTemplateReferences(function);
            for (PyStringLiteralExpression literal : templateReferences) {
                for (PsiReference reference : literal.getReferences()) {
                    PsiElement result;
                    if (!(reference instanceof FileReference) || !((result = reference.resolve()) instanceof PsiFile)) continue;
                    referencedFiles.add((PsiFile)result);
                }
            }
            if (!referencedFiles.isEmpty() && (identifier = function.getNameIdentifier()) != null) {
                return FlaskLineMarkerProvider.createNavigationLineMarker(identifier, referencedFiles, "template");
            }
        }
        return null;
    }

    private static <T extends PsiElement, U extends PsiNamedElement & NavigatablePsiElement> RelatedItemLineMarkerInfo<T> createNavigationLineMarker(T identifier, Collection<U> targets, String targetTypeName) {
        PsiNamedElement template = (PsiNamedElement)targets.iterator().next();
        String templateName = ((NavigationItem)template).getName();
        String msg = targets.size() == 1 ? "Go to " + targetTypeName + " '" + templateName + "'" : "Go to " + StringUtil.pluralize((String)targetTypeName);
        return new RelatedItemLineMarkerInfo(identifier, identifier.getTextRange(), AllIcons.FileTypes.Html, 11, (Function)new ConstantFunction((Object)msg), (GutterIconNavigationHandler)new DefaultGutterIconNavigationHandler(targets, msg), GutterIconRenderer.Alignment.RIGHT, (Collection)GotoRelatedItem.createItems(targets, (String)StringUtil.pluralize((String)targetTypeName)));
    }

    @Nullable
    private static RelatedItemLineMarkerInfo<PsiFile> createTemplateLineMarker(PsiFile element) {
        List<PyStringLiteralExpression> references2 = FlaskTemplateManager.findTemplateReferences(element);
        if (!references2.isEmpty()) {
            HashSet<PyFunction> viewFunctions = new HashSet<PyFunction>();
            for (PyStringLiteralExpression literal : references2) {
                PyFunction containingFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)literal, PyFunction.class);
                if (containingFunction == null) continue;
                viewFunctions.add(containingFunction);
            }
            if (!viewFunctions.isEmpty()) {
                return FlaskLineMarkerProvider.createNavigationLineMarker(element, viewFunctions, "view function");
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/flask/codeInsight/FlaskLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

