/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.editor;

import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.jetbrains.mako.MakoNames;
import com.jetbrains.mako.MakoTokenTypes;
import com.jetbrains.mako.MakoUtil;
import com.jetbrains.mako.psi.MakoTagBlock;
import com.jetbrains.mako.psi.impl.MakoCall;
import com.jetbrains.mako.psi.impl.MakoFunction;
import com.jetbrains.mako.psi.impl.MakoNamespace;
import com.jetbrains.mako.psi.impl.MakoTag;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MakoCompletionContributor
extends CompletionContributor {
    public static final PsiElementPattern.Capture<PsiElement> TAG_PATTERN = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType((IElementType)MakoTokenTypes.MAKO_TAG_NAME)).andNot((ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)MakoTokenTypes.MAKO_COLON)));
    public static final PsiElementPattern.Capture<PsiElement> FUNCTION_PATTERN = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType((IElementType)MakoTokenTypes.MAKO_TAG_NAME)).afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)MakoTokenTypes.MAKO_COLON));
    public static final PsiElementPattern.Capture<PsiElement> DOC_COMMENT = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType((IElementType)MakoTokenTypes.COMMENT);

    public MakoCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)TAG_PATTERN, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiElement original;
                PsiElement prevSibling;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((prevSibling = (original = parameters.getPosition()).getPrevSibling()) != null && prevSibling.getNode().getElementType() == MakoTokenTypes.MAKO_END_TAG_START) {
                    PsiElement tag = PsiTreeUtil.getParentOfType((PsiElement)original, (Class[])new Class[]{MakoTagBlock.class, MakoTag.class});
                    if (tag == null) {
                        tag = original.getParent();
                    }
                    while (!(tag == null || tag instanceof PsiFile || tag instanceof MakoTagBlock || tag instanceof MakoTag)) {
                        tag = tag.getPrevSibling();
                    }
                    String name = null;
                    if (tag instanceof MakoFunction) {
                        name = "def";
                    } else if (tag instanceof MakoCall) {
                        name = ((MakoCall)tag).getQualifiedName();
                    } else if (tag instanceof MakoTag || tag instanceof MakoTagBlock) {
                        name = ((NavigatablePsiElement)tag).getName();
                    }
                    if (name != null) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)name).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                                if (context == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (item == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                Editor editor2 = context.getEditor();
                                CaretModel caretModel = editor2.getCaretModel();
                                Document document = context.getDocument();
                                int offset = caretModel.getOffset();
                                document.insertString(offset, (CharSequence)">");
                                caretModel.moveToOffset(offset + 1);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "context";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "item";
                                        break;
                                    }
                                }
                                objectArray[1] = "com/jetbrains/mako/editor/MakoCompletionContributor$1$1";
                                objectArray[2] = "handleInsert";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        }));
                    }
                    return;
                }
                PsiFile file2 = original.getContainingFile();
                for (String tag : MakoNames.PREDEFINED_TAGS) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)tag).withIcon(PlatformIcons.XML_TAG_ICON));
                }
                for (String tag : MakoUtil.getDefaultNamespaces()) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)tag));
                }
                MakoNamespace[] namespaces = (MakoNamespace[])PsiTreeUtil.getChildrenOfType((PsiElement)file2, MakoNamespace.class);
                if (namespaces != null) {
                    for (MakoNamespace namespace : namespaces) {
                        String name = namespace.getName();
                        if (name == null) continue;
                        result.addElement((LookupElement)LookupElementBuilder.create((String)name));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/mako/editor/MakoCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)DOC_COMMENT, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(2);
                }
                PsiElement original = parameters.getPosition();
                String closingTag = "</%doc>";
                if (!original.getText().endsWith("</%doc>")) {
                    result = result.withPrefixMatcher(MakoCompletionContributor.getTagPrefix(parameters.getOffset(), original.getContainingFile()));
                    result.addElement((LookupElement)LookupElementBuilder.create((String)"</%doc>"));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/mako/editor/MakoCompletionContributor$2";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)FUNCTION_PATTERN, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                ASTNode namespaceName;
                if (parameters == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    3.$$$reportNull$$$0(2);
                }
                PsiElement original = parameters.getPosition();
                PsiFile file2 = original.getContainingFile();
                int offset = parameters.getOffset();
                String prefix = MakoCompletionContributor.getPrefix(offset, file2);
                result = result.withPrefixMatcher(prefix);
                ASTNode prev = original.getNode().getTreePrev();
                if (prev != null && prev.getElementType() == MakoTokenTypes.MAKO_COLON && (namespaceName = prev.getTreePrev()) != null) {
                    Set names;
                    if ("self".equals(namespaceName.getText()) || "local".equals(namespaceName.getText())) {
                        names = MakoUtil.getAvailableLocalFunctions(original).keySet();
                        for (String name : names) {
                            if (StringUtil.isEmptyOrSpaces((String)name)) continue;
                            result.addElement((LookupElement)LookupElementBuilder.create((String)name).withIcon(PlatformIcons.METHOD_ICON));
                        }
                    }
                    names = MakoUtil.getAvailableImportedFunctions(original, true).keySet();
                    for (String name : names) {
                        String[] nameParts = name.split(":");
                        if (nameParts.length <= 1 || !nameParts[0].equals(namespaceName.getText()) || StringUtil.isEmptyOrSpaces((String)nameParts[1])) continue;
                        result.addElement((LookupElement)LookupElementBuilder.create((String)nameParts[1]).withIcon(PlatformIcons.METHOD_ICON));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/mako/editor/MakoCompletionContributor$3";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static String getPrefix(int offset, PsiFile file2) {
        if (offset > 0) {
            --offset;
        }
        String text2 = file2.getText();
        StringBuilder prefixBuilder = new StringBuilder();
        while (offset > 0 && Character.isLetterOrDigit(text2.charAt(offset))) {
            prefixBuilder.insert(0, text2.charAt(offset));
            --offset;
        }
        return prefixBuilder.toString();
    }

    private static String getTagPrefix(int offset, PsiFile file2) {
        if (offset > 0) {
            --offset;
        }
        String text2 = file2.getText();
        StringBuilder prefixBuilder = new StringBuilder();
        while (offset > 0 && (Character.isLetterOrDigit(text2.charAt(offset)) || text2.charAt(offset) == '<') || text2.charAt(offset) == '/' || text2.charAt(offset) == '%') {
            prefixBuilder.insert(0, text2.charAt(offset));
            --offset;
        }
        return prefixBuilder.toString();
    }

    public AutoCompletionDecision handleAutoCompletionPossibility(@NotNull AutoCompletionContext context) {
        LookupElement[] items;
        if (context == null) {
            MakoCompletionContributor.$$$reportNull$$$0(0);
        }
        if ((items = context.getItems()).length == 1) {
            return AutoCompletionDecision.insertItem((LookupElement)items[0]);
        }
        return AutoCompletionDecision.SHOW_LOOKUP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/mako/editor/MakoCompletionContributor", "handleAutoCompletionPossibility"));
    }
}

