/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.ref;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.mako.MakoUtil;
import com.jetbrains.python.codeInsight.completion.PyFunctionInsertHandler;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.references.PyQualifiedReference;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MakoQualifiedReference
extends PyQualifiedReference {
    public MakoQualifiedReference(PyQualifiedExpression element, PyResolveContext context) {
        super(element, context);
    }

    @Override
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    @Override
    public Object @NotNull [] getVariants() {
        Object[] superVariants;
        LookupElementBuilder item;
        String name;
        MultiMap<String, PsiElement> names;
        HashSet<PsiElement> elementsSet = new HashSet<PsiElement>();
        PyExpression qualifier = this.myElement.getQualifier();
        assert (qualifier != null);
        String qualifierString = qualifier.getText();
        ArrayList result = Lists.newArrayList();
        if (qualifierString.equals("self") || qualifierString.equals("local")) {
            names = MakoUtil.getAvailableLocalFunctions((PsiElement)this.myElement);
            for (Map.Entry entry : names.entrySet()) {
                name = (String)entry.getKey();
                for (PsiElement element : (Collection)entry.getValue()) {
                    if (!(element instanceof PyFunction)) continue;
                    elementsSet.add(element);
                    item = LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)element).withIcon(PlatformIcons.METHOD_ICON).withInsertHandler((InsertHandler)PyFunctionInsertHandler.INSTANCE);
                    PyParameterList parameterList = ((PyFunction)element).getParameterList();
                    String params = StringUtil.join((Object[])parameterList.getParameters(), pyParameter -> pyParameter.getText(), (String)", ");
                    item = item.withTailText("(" + params + ")");
                    result.add(item);
                }
            }
        }
        names = MakoUtil.getFunctionsFromNamespace((PsiElement)this.myElement, qualifierString);
        for (Map.Entry entry : names.entrySet()) {
            name = (String)entry.getKey();
            for (PsiElement element : (Collection)entry.getValue()) {
                if (!(element instanceof PyFunction)) continue;
                elementsSet.add(element);
                item = LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)element).withIcon(PlatformIcons.METHOD_ICON).withInsertHandler((InsertHandler)PyFunctionInsertHandler.INSTANCE);
                PyFunction function = PyUtil.as(item.getPsiElement(), PyFunction.class);
                if (function == null) continue;
                PyParameterList parameterList = function.getParameterList();
                String params = StringUtil.join((Object[])parameterList.getParameters(), pyParameter -> pyParameter.getText(), (String)", ");
                item = item.withTailText("(" + params + ")");
                result.add(item);
            }
        }
        for (Object variant : superVariants = super.getVariants()) {
            if (!(variant instanceof LookupElementBuilder) || elementsSet.contains(((LookupElementBuilder)variant).getPsiElement())) continue;
            result.add(variant);
        }
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            MakoQualifiedReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    @Override
    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PyExpression qualifier = this.myElement.getQualifier();
        if (qualifier != null && qualifier.getText().equals("caller")) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                MakoQualifiedReference.$$$reportNull$$$0(1);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        List<ResolveResult> result = MakoUtil.resolveFunctionCall((PsiElement)this.myElement);
        if (!result.isEmpty()) {
            ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                MakoQualifiedReference.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = super.multiResolve(incompleteCode);
        if (resolveResultArray == null) {
            MakoQualifiedReference.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    @Override
    @NotNull
    protected PyQualifiedReference copyWithResolveContext(PyResolveContext context) {
        return new MakoQualifiedReference(this.myElement, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/mako/ref/MakoQualifiedReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

